/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.bank;

public enum BankOperationError {
    INSUFFICIENT_FUNDS("Insufficient funds in account"),
    DAILY_LIMIT_EXCEEDED("Daily transaction limit exceeded"),
    ACCOUNT_FROZEN("Account is frozen"),
    ACCOUNT_NOT_FOUND("Bank account not found"),
    INVALID_AMOUNT("Invalid transaction amount"),
    PERMISSION_DENIED("Permission denied for operation"),
    SYSTEM_ERROR("Banking system error"),
    DATABASE_ERROR("Database operation failed"),
    TIER_REQUIREMENTS_NOT_MET("Account tier requirements not met"),
    MINIMUM_BALANCE_VIOLATION("Transaction would violate minimum balance"),
    SECURITY_VIOLATION("Security policy violation"),
    CONCURRENT_MODIFICATION("Account modified by another transaction");

    private final String description;

    private BankOperationError(String description) {
        this.description = description;
    }

    public boolean isUserCorrectable() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case INSUFFICIENT_FUNDS, DAILY_LIMIT_EXCEEDED, INVALID_AMOUNT, TIER_REQUIREMENTS_NOT_MET, MINIMUM_BALANCE_VIOLATION -> true;
            case ACCOUNT_FROZEN, ACCOUNT_NOT_FOUND, PERMISSION_DENIED, SYSTEM_ERROR, DATABASE_ERROR, SECURITY_VIOLATION, CONCURRENT_MODIFICATION -> false;
        };
    }

    public boolean requiresAdminIntervention() {
        return switch (this) {
            case ACCOUNT_FROZEN, PERMISSION_DENIED, SYSTEM_ERROR, DATABASE_ERROR, SECURITY_VIOLATION -> true;
            default -> false;
        };
    }

    public ErrorSeverity getSeverity() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case INSUFFICIENT_FUNDS, DAILY_LIMIT_EXCEEDED, INVALID_AMOUNT -> ErrorSeverity.LOW;
            case TIER_REQUIREMENTS_NOT_MET, MINIMUM_BALANCE_VIOLATION -> ErrorSeverity.MEDIUM;
            case ACCOUNT_FROZEN, ACCOUNT_NOT_FOUND, PERMISSION_DENIED -> ErrorSeverity.HIGH;
            case SYSTEM_ERROR, DATABASE_ERROR, SECURITY_VIOLATION, CONCURRENT_MODIFICATION -> ErrorSeverity.CRITICAL;
        };
    }

    public String getDescription() {
        return this.description;
    }

    public static enum ErrorSeverity {
        LOW,
        MEDIUM,
        HIGH,
        CRITICAL;

    }
}

