/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.events;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import me.koyere.ecoxpert.modules.events.EconomicEventType;
import org.bukkit.Material;

public class EconomicEvent {
    private final String id;
    private final EconomicEventType type;
    private final String name;
    private final String description;
    private final LocalDateTime startTime;
    private final int duration;
    private final double intensity;
    private final List<Material> affectedItems;
    private final Map<String, Object> parameters;
    private EventStatus status;
    private LocalDateTime endTime;
    private String endReason;

    public EconomicEvent(String id, EconomicEventType type, String name, String description, LocalDateTime startTime, int duration, double intensity, List<Material> affectedItems, Map<String, Object> parameters, EventStatus status) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.description = description;
        this.startTime = startTime;
        this.duration = duration;
        this.intensity = intensity;
        this.affectedItems = affectedItems;
        this.parameters = parameters;
        this.status = status;
    }

    public boolean hasExpired() {
        if (this.status != EventStatus.ACTIVE) {
            return true;
        }
        LocalDateTime expectedEndTime = this.startTime.plusMinutes(this.duration);
        return LocalDateTime.now().isAfter(expectedEndTime);
    }

    public long getRemainingMinutes() {
        if (this.status != EventStatus.ACTIVE) {
            return 0L;
        }
        LocalDateTime expectedEndTime = this.startTime.plusMinutes(this.duration);
        Duration remaining = Duration.between(LocalDateTime.now(), expectedEndTime);
        return Math.max(0L, remaining.toMinutes());
    }

    public double getProgress() {
        if (this.status != EventStatus.ACTIVE) {
            return 1.0;
        }
        Duration elapsed = Duration.between(this.startTime, LocalDateTime.now());
        double elapsedMinutes = elapsed.toMinutes();
        return Math.min(1.0, elapsedMinutes / (double)this.duration);
    }

    public void end(String reason) {
        this.status = EventStatus.COMPLETED;
        this.endTime = LocalDateTime.now();
        this.endReason = reason;
    }

    public void cancel(String reason) {
        this.status = EventStatus.CANCELLED;
        this.endTime = LocalDateTime.now();
        this.endReason = reason;
    }

    public <T> T getParameter(String key, Class<T> type) {
        Object value = this.parameters.get(key);
        if (value != null && type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return null;
    }

    public <T> T getParameter(String key, T defaultValue) {
        Object value = this.parameters.get(key);
        if (value != null) {
            try {
                return (T)value;
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public boolean affects(Material material) {
        return this.affectedItems.contains(material);
    }

    public String getFormattedInfo() {
        StringBuilder info = new StringBuilder();
        info.append("\u00a76\u00a7l").append(this.name).append("\n");
        info.append("\u00a77").append(this.description).append("\n");
        info.append("\u00a7eType: \u00a7f").append(this.type.getDisplayName()).append("\n");
        info.append("\u00a7eStatus: \u00a7f").append(this.getStatusColor()).append(this.status.getDisplayName()).append("\n");
        info.append("\u00a7eIntensity: \u00a7f").append(String.format("%.1f%%", this.intensity * 100.0)).append("\n");
        if (this.status == EventStatus.ACTIVE) {
            info.append("\u00a7eRemaining: \u00a7f").append(this.getRemainingMinutes()).append(" minutes\n");
            info.append("\u00a7eProgress: \u00a7f").append(String.format("%.1f%%", this.getProgress() * 100.0)).append("\n");
        }
        if (!this.affectedItems.isEmpty()) {
            info.append("\u00a7eAffected Items: \u00a7f");
            for (int i = 0; i < this.affectedItems.size(); ++i) {
                if (i > 0) {
                    info.append(", ");
                }
                info.append(this.affectedItems.get(i).name().toLowerCase().replace('_', ' '));
            }
            info.append("\n");
        }
        return info.toString();
    }

    private String getStatusColor() {
        return switch (this.status) {
            default -> throw new IncompatibleClassChangeError();
            case EventStatus.ACTIVE -> "\u00a7a";
            case EventStatus.COMPLETED -> "\u00a72";
            case EventStatus.CANCELLED -> "\u00a7c";
            case EventStatus.PENDING -> "\u00a7e";
        };
    }

    public String getId() {
        return this.id;
    }

    public EconomicEventType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public int getDuration() {
        return this.duration;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public List<Material> getAffectedItems() {
        return this.affectedItems;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public EventStatus getStatus() {
        return this.status;
    }

    public void setStatus(EventStatus status) {
        this.status = status;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public String getEndReason() {
        return this.endReason;
    }

    public String toString() {
        return String.format("EconomicEvent{id='%s', type=%s, name='%s', status=%s, intensity=%.2f, duration=%d}", new Object[]{this.id, this.type, this.name, this.status, this.intensity, this.duration});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EconomicEvent that = (EconomicEvent)obj;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static enum EventStatus {
        PENDING("Pending"),
        ACTIVE("Active"),
        COMPLETED("Completed"),
        CANCELLED("Cancelled");

        private final String displayName;

        private EventStatus(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

