/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.events;

public enum EconomicEventType {
    GOVERNMENT_STIMULUS("Government Stimulus", "Crisis Response"),
    TRADE_BOOM("Trade Boom", "Economic Recovery"),
    MARKET_DISCOVERY("Market Discovery", "Innovation"),
    TECHNOLOGICAL_BREAKTHROUGH("Tech Breakthrough", "Innovation"),
    INVESTMENT_OPPORTUNITY("Investment Opportunity", "Market"),
    LUXURY_DEMAND("Luxury Demand", "Market"),
    MARKET_CORRECTION("Market Correction", "Market Adjustment"),
    RESOURCE_SHORTAGE("Resource Shortage", "Supply Chain"),
    SEASONAL_DEMAND("Seasonal Demand", "Natural Cycle"),
    BLACK_SWAN_EVENT("Black Swan Event", "Crisis");

    private final String displayName;
    private final String category;

    private EconomicEventType(String displayName, String category) {
        this.displayName = displayName;
        this.category = category;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isCrisisResponse() {
        return this == GOVERNMENT_STIMULUS || this == TRADE_BOOM;
    }

    public boolean isPositive() {
        return this != MARKET_CORRECTION && this != RESOURCE_SHORTAGE && this != BLACK_SWAN_EVENT;
    }

    public ImpactLevel getImpactLevel() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BLACK_SWAN_EVENT -> ImpactLevel.EXTREME;
            case GOVERNMENT_STIMULUS, MARKET_CORRECTION -> ImpactLevel.HIGH;
            case TRADE_BOOM, TECHNOLOGICAL_BREAKTHROUGH, RESOURCE_SHORTAGE -> ImpactLevel.MEDIUM;
            case INVESTMENT_OPPORTUNITY, LUXURY_DEMAND, MARKET_DISCOVERY -> ImpactLevel.MEDIUM;
            case SEASONAL_DEMAND -> ImpactLevel.LOW;
        };
    }

    public static enum ImpactLevel {
        LOW(0.3),
        MEDIUM(0.6),
        HIGH(0.8),
        EXTREME(1.0);

        private final double intensity;

        private ImpactLevel(double intensity) {
            this.intensity = intensity;
        }

        public double getIntensity() {
            return this.intensity;
        }
    }
}

