/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.events;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Locale;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.gui.BaseGUI;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.modules.events.EconomicEventEngine;
import me.koyere.ecoxpert.modules.events.EconomicEventType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EventsAdminGUI
extends BaseGUI {
    private final EconomicEventEngine engine;
    private final TranslationManager tm;

    public EventsAdminGUI(EcoXpertPlugin plugin, EconomicEventEngine engine, TranslationManager tm) {
        super(plugin);
        this.engine = engine;
        this.tm = tm;
    }

    @Override
    protected Inventory create(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)this.tm.getMessage("events.gui.title", new Object[0]));
        inv.setItem(0, this.item(Material.REDSTONE, this.tm.getMessage("events.gui.pause", new Object[0])));
        inv.setItem(1, this.item(Material.LIME_DYE, this.tm.getMessage("events.gui.resume", new Object[0])));
        inv.setItem(2, this.item(Material.PAPER, this.tm.getMessage("events.gui.status", new Object[0])));
        inv.setItem(3, this.item(Material.CLOCK, this.tm.getMessage("events.gui.recent", new Object[0])));
        int slot = 9;
        for (EconomicEventType type : EconomicEventType.values()) {
            ItemStack it = this.item(this.iconFor(type), this.pretty(type.name()));
            ItemMeta meta = it.getItemMeta();
            if (meta != null) {
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                double weight = this.engine.getConfiguredWeight(type);
                int cooldown = this.engine.getEventCooldownHours(type);
                long remaining = this.engine.getRemainingCooldownHours(type);
                lore.add((CallSite)((Object)("\u00a77Weight: \u00a7e" + String.format(Locale.US, "%.2f", weight))));
                lore.add((CallSite)((Object)("\u00a77Cooldown: \u00a7e" + cooldown + "h")));
                if (remaining > 0L) {
                    lore.add((CallSite)((Object)("\u00a77Remaining: \u00a7c" + remaining + "h")));
                }
                meta.setLore(lore);
                it.setItemMeta(meta);
            }
            inv.setItem(slot++, it);
            if (slot >= 54) break;
        }
        return inv;
    }

    private Material iconFor(EconomicEventType t) {
        return switch (t) {
            default -> throw new IncompatibleClassChangeError();
            case EconomicEventType.GOVERNMENT_STIMULUS -> Material.EMERALD_BLOCK;
            case EconomicEventType.TRADE_BOOM -> Material.GOLD_BLOCK;
            case EconomicEventType.MARKET_DISCOVERY -> Material.SPYGLASS;
            case EconomicEventType.TECHNOLOGICAL_BREAKTHROUGH -> Material.REDSTONE_TORCH;
            case EconomicEventType.INVESTMENT_OPPORTUNITY -> Material.DIAMOND;
            case EconomicEventType.LUXURY_DEMAND -> Material.GOLDEN_APPLE;
            case EconomicEventType.MARKET_CORRECTION -> Material.ANVIL;
            case EconomicEventType.RESOURCE_SHORTAGE -> Material.IRON_INGOT;
            case EconomicEventType.SEASONAL_DEMAND -> Material.HAY_BLOCK;
            case EconomicEventType.BLACK_SWAN_EVENT -> Material.WITHER_SKELETON_SKULL;
        };
    }

    private String pretty(String name) {
        return name.toLowerCase().replace('_', ' ');
    }

    private ItemStack item(Material m, String name) {
        ItemStack it = new ItemStack(m);
        ItemMeta meta = it.getItemMeta();
        meta.setDisplayName("\u00a7e" + name);
        it.setItemMeta(meta);
        return it;
    }

    @Override
    protected void onClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        ItemStack it = e.getCurrentItem();
        if (it == null || !it.hasItemMeta() || !it.getItemMeta().hasDisplayName()) {
            return;
        }
        String name = it.getItemMeta().getDisplayName();
        if (name.contains(this.tm.getMessage("events.gui.pause", new Object[0]))) {
            this.engine.pauseEngine();
            p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + this.tm.getMessage("events.admin.engine.paused", new Object[0]));
        } else if (name.contains(this.tm.getMessage("events.gui.resume", new Object[0]))) {
            this.engine.resumeEngine();
            p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + this.tm.getMessage("events.admin.engine.resumed", new Object[0]));
        } else if (name.contains(this.tm.getMessage("events.gui.status", new Object[0]))) {
            p.performCommand("ecoxpert events status");
        } else if (name.contains(this.tm.getMessage("events.gui.recent", new Object[0]))) {
            p.performCommand("ecoxpert events recent");
        } else {
            String raw = name.replace("\u00a7e", "").toUpperCase().replace(' ', '_');
            try {
                EconomicEventType type = EconomicEventType.valueOf(raw);
                boolean ok = this.engine.triggerEvent(type);
                p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + (ok ? this.tm.getMessage("events.admin.triggered", type.name(), new Object[0]) : this.tm.getMessage("events.admin.trigger.failed", type.name(), new Object[0])));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

