/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.market;

import java.math.BigDecimal;
import java.util.Objects;
import org.bukkit.Material;

public final class MarketItemStats {
    private final Material material;
    private final int totalSold;
    private final int totalBought;
    private final BigDecimal totalSellVolume;
    private final BigDecimal totalBuyVolume;
    private final BigDecimal averageSellPrice;
    private final BigDecimal averageBuyPrice;
    private final int rank;

    public MarketItemStats(Material material, int totalSold, int totalBought, BigDecimal totalSellVolume, BigDecimal totalBuyVolume, BigDecimal averageSellPrice, BigDecimal averageBuyPrice, int rank) {
        this.material = Objects.requireNonNull(material, "Material cannot be null");
        this.totalSold = Math.max(0, totalSold);
        this.totalBought = Math.max(0, totalBought);
        this.totalSellVolume = Objects.requireNonNull(totalSellVolume, "Total sell volume cannot be null");
        this.totalBuyVolume = Objects.requireNonNull(totalBuyVolume, "Total buy volume cannot be null");
        this.averageSellPrice = Objects.requireNonNull(averageSellPrice, "Average sell price cannot be null");
        this.averageBuyPrice = Objects.requireNonNull(averageBuyPrice, "Average buy price cannot be null");
        this.rank = Math.max(1, rank);
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getTotalSold() {
        return this.totalSold;
    }

    public int getTotalBought() {
        return this.totalBought;
    }

    public BigDecimal getTotalSellVolume() {
        return this.totalSellVolume;
    }

    public BigDecimal getTotalBuyVolume() {
        return this.totalBuyVolume;
    }

    public BigDecimal getAverageSellPrice() {
        return this.averageSellPrice;
    }

    public BigDecimal getAverageBuyPrice() {
        return this.averageBuyPrice;
    }

    public int getRank() {
        return this.rank;
    }

    public int getTotalTransactions() {
        return this.totalSold + this.totalBought;
    }

    public BigDecimal getTotalVolume() {
        return this.totalSellVolume.add(this.totalBuyVolume);
    }

    public int getNetItemsTraded() {
        return this.totalBought - this.totalSold;
    }

    public BigDecimal getNetVolume() {
        return this.totalBuyVolume.subtract(this.totalSellVolume);
    }

    public double getAverageTransactionSize() {
        int totalTransactions = this.getTotalTransactions();
        if (totalTransactions == 0) {
            return 0.0;
        }
        return (double)(this.totalSold + this.totalBought) / (double)totalTransactions;
    }

    public double getActivityScore() {
        int transactions = this.getTotalTransactions();
        BigDecimal volume = this.getTotalVolume();
        double transactionScore = Math.min(1.0, (double)transactions / 1000.0);
        double volumeScore = Math.min(1.0, volume.doubleValue() / 100000.0);
        return (transactionScore + volumeScore) / 2.0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MarketItemStats that = (MarketItemStats)obj;
        return this.material == that.material;
    }

    public int hashCode() {
        return Objects.hash(this.material);
    }

    public String toString() {
        return String.format("MarketItemStats{material=%s, rank=%d, transactions=%d, volume=%s}", this.material, this.rank, this.getTotalTransactions(), this.getTotalVolume());
    }
}

