/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.market;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;
import org.bukkit.Material;

public final class MarketPriceHistory {
    private final Material material;
    private final BigDecimal buyPrice;
    private final BigDecimal sellPrice;
    private final LocalDateTime timestamp;
    private final int transactionCount;
    private final BigDecimal volume;

    public MarketPriceHistory(Material material, BigDecimal buyPrice, BigDecimal sellPrice, LocalDateTime timestamp, int transactionCount, BigDecimal volume) {
        this.material = Objects.requireNonNull(material, "Material cannot be null");
        this.buyPrice = Objects.requireNonNull(buyPrice, "Buy price cannot be null");
        this.sellPrice = Objects.requireNonNull(sellPrice, "Sell price cannot be null");
        this.timestamp = Objects.requireNonNull(timestamp, "Timestamp cannot be null");
        this.transactionCount = Math.max(0, transactionCount);
        this.volume = Objects.requireNonNull(volume, "Volume cannot be null");
    }

    public Material getMaterial() {
        return this.material;
    }

    public BigDecimal getBuyPrice() {
        return this.buyPrice;
    }

    public BigDecimal getSellPrice() {
        return this.sellPrice;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public int getTransactionCount() {
        return this.transactionCount;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getAveragePrice() {
        return this.buyPrice.add(this.sellPrice).divide(BigDecimal.valueOf(2L), 2, 4);
    }

    public BigDecimal getPriceSpread() {
        return this.buyPrice.subtract(this.sellPrice);
    }

    public BigDecimal getPriceSpreadPercentage() {
        if (this.buyPrice.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        return this.getPriceSpread().divide(this.buyPrice, 4, 4).multiply(BigDecimal.valueOf(100L));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MarketPriceHistory that = (MarketPriceHistory)obj;
        return this.material == that.material && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.material, this.timestamp);
    }

    public String toString() {
        return String.format("MarketPriceHistory{material=%s, buyPrice=%s, sellPrice=%s, timestamp=%s}", this.material, this.buyPrice, this.sellPrice, this.timestamp);
    }
}

