/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.market.orders;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.data.QueryResult;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.market.MarketManager;
import me.koyere.ecoxpert.modules.market.orders.MarketOrder;
import me.koyere.ecoxpert.modules.market.orders.MarketOrderService;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MarketOrderServiceImpl
implements MarketOrderService {
    private final EcoXpertPlugin plugin;
    private final DataManager dataManager;
    private final EconomyManager economyManager;
    private final MarketManager marketManager;
    private final TranslationManager tm;

    public MarketOrderServiceImpl(EcoXpertPlugin plugin, DataManager dataManager, EconomyManager economyManager, MarketManager marketManager, TranslationManager tm) {
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.economyManager = economyManager;
        this.marketManager = marketManager;
        this.tm = tm;
    }

    @Override
    public CompletableFuture<String> createListing(Player seller, Material material, int quantity, BigDecimal unitPrice, int expiryHours) {
        return CompletableFuture.supplyAsync(() -> {
            if (quantity <= 0 || unitPrice == null || unitPrice.signum() <= 0) {
                return this.tm.getMessage("market.order.invalid", new Object[0]);
            }
            int have = this.marketManager.countItems(seller, material);
            if (have < quantity) {
                return this.tm.getMessage("market.order.insufficient-items", material.name(), new Object[0]);
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.marketManager.removeItemsFromInventory(seller, material, quantity));
            String sql = "INSERT INTO ecoxpert_market_orders (seller_uuid, material, unit_price, remaining_quantity, status, expires_at) VALUES (?, ?, ?, ?, 'OPEN', datetime('now', '+' || ? || ' hours'))";
            this.dataManager.executeUpdate(sql, seller.getUniqueId().toString(), material.name(), unitPrice.setScale(2, RoundingMode.HALF_UP), quantity, expiryHours).join();
            long id = 0L;
            try (QueryResult qr = this.dataManager.executeQuery("SELECT last_insert_rowid() as id", new Object[0]).join();){
                if (qr.next()) {
                    id = qr.getLong("id");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.tm.getMessage("market.order.created", quantity, material.name(), this.economyManager.formatMoney(unitPrice), id);
        });
    }

    @Override
    public CompletableFuture<String> buyFromOrder(Player buyer, long orderId, int quantity) {
        return CompletableFuture.supplyAsync(() -> {
            try (QueryResult qr = this.dataManager.executeQuery("SELECT id, seller_uuid, material, unit_price, remaining_quantity, status, expires_at FROM ecoxpert_market_orders WHERE id = ?", orderId).join();){
                if (!qr.next()) {
                    String string = this.tm.getMessage("market.order.not-found", orderId);
                    return string;
                }
                if (!"OPEN".equalsIgnoreCase(qr.getString("status"))) {
                    String string = this.tm.getMessage("market.order.closed", orderId);
                    return string;
                }
                Timestamp ex = qr.getTimestamp("expires_at");
                if (ex != null && ex.toInstant().isBefore(Instant.now())) {
                    String string = this.tm.getMessage("market.order.expired", orderId);
                    return string;
                }
                int remaining = qr.getInt("remaining_quantity");
                if (remaining <= 0) {
                    String string = this.tm.getMessage("market.order.invalid", new Object[0]);
                    return string;
                }
                if (remaining < quantity) {
                    String string = this.tm.getMessage("market.order.insufficient-remaining", remaining);
                    return string;
                }
                Material mat = Material.valueOf((String)qr.getString("material"));
                BigDecimal price = qr.getBigDecimal("unit_price").setScale(2, RoundingMode.HALF_UP);
                if (price.compareTo(BigDecimal.ZERO) <= 0) {
                    String string = this.tm.getMessage("market.order.invalid", new Object[0]);
                    return string;
                }
                BigDecimal total = price.multiply(BigDecimal.valueOf(quantity)).setScale(2, RoundingMode.HALF_UP);
                if (total.compareTo(BigDecimal.ZERO) <= 0) {
                    String string = this.tm.getMessage("market.order.invalid", new Object[0]);
                    return string;
                }
                UUID seller = UUID.fromString(qr.getString("seller_uuid"));
                boolean okFunds = this.economyManager.hasSufficientFunds(buyer.getUniqueId(), total).join();
                if (!okFunds) {
                    String string = this.tm.getMessage("market.error.insufficient-funds", this.economyManager.formatMoney(total), "");
                    return string;
                }
                boolean ok = this.economyManager.transferMoney(buyer.getUniqueId(), seller, total, "OrderBook purchase").join();
                if (!ok) {
                    String string = this.tm.getMessage("market.error.system-error", new Object[0]);
                    return string;
                }
                ItemStack stack = new ItemStack(mat, quantity);
                boolean added = this.marketManager.addItemsToInventory(buyer, stack);
                if (!added) {
                    String string = this.tm.getMessage("market.error.inventory-full", new Object[0]);
                    return string;
                }
                int newRem = remaining - quantity;
                String status = newRem <= 0 ? "CLOSED" : "OPEN";
                this.dataManager.executeUpdate("UPDATE ecoxpert_market_orders SET remaining_quantity = ?, status = ? WHERE id = ?", newRem, status, orderId).join();
                String string = this.tm.getMessage("market.order.buy.success", quantity, mat.name(), this.economyManager.formatMoney(total), orderId);
                return string;
            }
            catch (Exception e) {
                return this.tm.getMessage("market.system-error", new Object[0]);
            }
        });
    }

    @Override
    public CompletableFuture<List<MarketOrder>> listOpenOrders(Material filter) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<MarketOrder> out = new ArrayList<MarketOrder>();
            String base = "SELECT id, seller_uuid, material, unit_price, remaining_quantity, status, created_at, expires_at FROM ecoxpert_market_orders WHERE status='OPEN'" + (filter != null ? " AND material = ?" : "") + " ORDER BY created_at DESC LIMIT 25";
            try (QueryResult qr = filter == null ? this.dataManager.executeQuery(base, new Object[0]).join() : this.dataManager.executeQuery(base, filter.name()).join();){
                while (qr.next()) {
                    out.add(new MarketOrder(qr.getLong("id"), UUID.fromString(qr.getString("seller_uuid")), Material.valueOf((String)qr.getString("material")), qr.getBigDecimal("unit_price"), qr.getInt("remaining_quantity"), qr.getString("status"), qr.getTimestamp("created_at").toLocalDateTime(), qr.getTimestamp("expires_at") != null ? qr.getTimestamp("expires_at").toLocalDateTime() : null));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return out;
        });
    }
}

