/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.professions;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.data.QueryResult;
import me.koyere.ecoxpert.modules.professions.ProfessionRole;
import me.koyere.ecoxpert.modules.professions.ProfessionsManager;
import org.bukkit.configuration.file.FileConfiguration;

public class ProfessionsManagerImpl
implements ProfessionsManager {
    private final EcoXpertPlugin plugin;
    private final DataManager dataManager;

    public ProfessionsManagerImpl(EcoXpertPlugin plugin, DataManager dataManager) {
        this.plugin = plugin;
        this.dataManager = dataManager;
    }

    @Override
    public CompletableFuture<Optional<ProfessionRole>> getRole(UUID player) {
        return this.dataManager.executeQuery("SELECT role FROM ecoxpert_professions WHERE player_uuid = ?", player.toString()).thenApply(result -> this.mapRole((QueryResult)result));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<ProfessionRole> mapRole(QueryResult result) {
        try (QueryResult queryResult = result;){
            if (!result.next()) {
                Optional<ProfessionRole> optional = Optional.empty();
                return optional;
            }
            String r = result.getString("role");
            if (r == null || r.isBlank()) {
                Optional<ProfessionRole> optional = Optional.empty();
                return optional;
            }
            Optional<ProfessionRole> optional = Optional.of(ProfessionRole.fromString(r));
            return optional;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to map profession role: " + e.getMessage());
            return Optional.empty();
        }
    }

    @Override
    public CompletableFuture<Boolean> setRole(UUID player, ProfessionRole role) {
        return this.canChange(player).thenCompose(allowed -> {
            if (!allowed.booleanValue()) {
                return CompletableFuture.completedFuture(false);
            }
            String sql = "INSERT INTO ecoxpert_professions (player_uuid, role, level, selected_at) VALUES (?, ?, 1, CURRENT_TIMESTAMP) ON CONFLICT(player_uuid) DO UPDATE SET role = excluded.role, selected_at = CURRENT_TIMESTAMP, level = 1";
            return this.dataManager.executeUpdate(sql, player.toString(), role.name()).thenApply(rows -> rows > 0);
        });
    }

    @Override
    public List<ProfessionRole> getAvailableRoles() {
        return Arrays.asList(ProfessionRole.values());
    }

    @Override
    public CompletableFuture<Integer> getLevel(UUID player) {
        return this.dataManager.executeQuery("SELECT level FROM ecoxpert_professions WHERE player_uuid = ?", player.toString()).thenApply(result -> {
            try (QueryResult queryResult = result;){
                if (!result.next()) return 1;
                Integer n = Math.max(1, result.getInt("level"));
                return n;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 1;
        });
    }

    @Override
    public CompletableFuture<Boolean> setLevel(UUID player, int level) {
        int lvl = Math.max(1, level);
        return this.dataManager.executeUpdate("INSERT INTO ecoxpert_professions (player_uuid, role, level, selected_at) VALUES (?, ?, ?, CURRENT_TIMESTAMP) ON CONFLICT(player_uuid) DO UPDATE SET level = excluded.level", player.toString(), ProfessionRole.SAVER.name(), lvl).thenApply(rows -> rows > 0);
    }

    @Override
    public CompletableFuture<Integer> getXp(UUID player) {
        return this.dataManager.executeQuery("SELECT xp FROM ecoxpert_profession_xp WHERE player_uuid = ?", player.toString()).thenApply(result -> {
            try (QueryResult queryResult = result;){
                if (!result.next()) return 0;
                Integer n = Math.max(0, result.getInt("xp"));
                return n;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        });
    }

    @Override
    public CompletableFuture<Integer> addXp(UUID player, int delta) {
        int d = Math.max(0, delta);
        return this.getLevel(player).thenCompose(prevLevel -> ((CompletableFuture)this.dataManager.executeUpdate("INSERT INTO ecoxpert_profession_xp (player_uuid, xp, last_gain_at) VALUES (?, ?, CURRENT_TIMESTAMP) ON CONFLICT(player_uuid) DO UPDATE SET xp = xp + excluded.xp, last_gain_at = CURRENT_TIMESTAMP", player.toString(), d).thenCompose(rows -> this.getXp(player))).thenCompose(totalXp -> {
            int newLevel = this.computeLevelFromXp((int)totalXp);
            if (newLevel > prevLevel) {
                return this.setLevel(player, newLevel).thenApply(ok -> newLevel);
            }
            return CompletableFuture.completedFuture(prevLevel);
        }));
    }

    private int computeLevelFromXp(int xp) {
        try {
            FileConfiguration cfg = this.plugin.getServiceRegistry().getInstance(ConfigManager.class).getModuleConfig("professions");
            int maxLevel = Math.max(1, cfg.getInt("max_level", 5));
            List<Integer> thresholds = cfg.getIntegerList("xp.level_thresholds");
            if (thresholds == null || thresholds.isEmpty()) {
                thresholds = Arrays.asList(0, 100, 250, 500, 1000, 2000);
            }
            int level = 1;
            int i = 1;
            while (i <= maxLevel) {
                int t;
                int idx = i - 1;
                int n = t = idx < thresholds.size() ? (Integer)thresholds.get(idx) : (Integer)thresholds.get(thresholds.size() - 1) * 2;
                if (xp < t) break;
                level = i++;
            }
            if (level > maxLevel) {
                level = maxLevel;
            }
            if (level < 1) {
                level = 1;
            }
            return level;
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public CompletableFuture<Boolean> canChange(UUID player) {
        return CompletableFuture.supplyAsync(() -> {
            try (QueryResult qr = this.dataManager.executeQuery("SELECT selected_at FROM ecoxpert_professions WHERE player_uuid = ?", player.toString()).join();){
                if (!qr.next()) {
                    Boolean bl = true;
                    return bl;
                }
                Timestamp ts = qr.getTimestamp("selected_at");
                if (ts == null) {
                    Boolean bl = true;
                    return bl;
                }
                FileConfiguration cfg = this.plugin.getServiceRegistry().getInstance(ConfigManager.class).getModuleConfig("professions");
                int cooldown = cfg.getInt("cooldown_minutes", 1440);
                long elapsedMin = Duration.between(ts.toInstant(), Instant.now()).toMinutes();
                Boolean bl = elapsedMin >= (long)cooldown;
                return bl;
            }
            catch (Exception ignored) {
                return true;
            }
        });
    }
}

