/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.api.services;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.api.InflationService;
import me.koyere.ecoxpert.api.dto.EconomicCycleInfo;
import me.koyere.ecoxpert.api.dto.PlayerEconomyProfile;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.data.QueryResult;
import me.koyere.ecoxpert.modules.inflation.EconomicIntelligenceEngine;
import me.koyere.ecoxpert.modules.inflation.InflationManager;
import me.koyere.ecoxpert.modules.inflation.PlayerEconomicProfile;

public class InflationServiceImpl
implements InflationService {
    private final InflationManager inflationManager;
    private final DataManager dataManager;

    public InflationServiceImpl(InflationManager inflationManager, DataManager dataManager) {
        this.inflationManager = inflationManager;
        this.dataManager = dataManager;
    }

    @Override
    public double getCurrentInflation() {
        return this.inflationManager.getInflationRate();
    }

    @Override
    public double getEconomicHealth() {
        return this.inflationManager.getEconomicHealth();
    }

    @Override
    public EconomicCycleInfo getCurrentCycle() {
        EconomicIntelligenceEngine.EconomicCycle cycle = this.inflationManager.getCurrentCycle();
        if (cycle == null) {
            return new EconomicCycleInfo("UNKNOWN", 0.0, 0.0, "Economic system initializing");
        }
        return new EconomicCycleInfo(cycle.name(), this.getEconomicHealth(), this.getCurrentInflation(), this.getCycleDescription(cycle));
    }

    @Override
    public Optional<PlayerEconomyProfile> getPlayerProfile(UUID playerId) {
        PlayerEconomicProfile profile = this.inflationManager.getPlayerProfile(playerId);
        if (profile == null) {
            return Optional.empty();
        }
        return Optional.of(new PlayerEconomyProfile(playerId, profile.getRiskScore(), 0.0, BigDecimal.valueOf(profile.getPredictedFutureBalance()), this.classifyEconomicClass(profile.getPredictedFutureBalance())));
    }

    @Override
    public CompletableFuture<BigDecimal> getTotalMoney() {
        return CompletableFuture.supplyAsync(() -> {
            try (QueryResult result = this.dataManager.executeQuery("SELECT COALESCE(SUM(balance), 0) AS total FROM ecoxpert_accounts", new Object[0]).join();){
                if (result.next()) {
                    BigDecimal total = result.getBigDecimal("total");
                    BigDecimal bigDecimal = total != null ? total : BigDecimal.ZERO;
                    return bigDecimal;
                }
                BigDecimal bigDecimal = BigDecimal.ZERO;
                return bigDecimal;
            }
            catch (Exception e) {
                return BigDecimal.ZERO;
            }
        });
    }

    @Override
    public CompletableFuture<BigDecimal> getAverageBalance() {
        return CompletableFuture.supplyAsync(() -> {
            try (QueryResult result = this.dataManager.executeQuery("SELECT COALESCE(AVG(balance), 0) AS avg FROM ecoxpert_accounts", new Object[0]).join();){
                if (result.next()) {
                    BigDecimal avg = result.getBigDecimal("avg");
                    BigDecimal bigDecimal = avg != null ? avg : BigDecimal.ZERO;
                    return bigDecimal;
                }
                BigDecimal bigDecimal = BigDecimal.ZERO;
                return bigDecimal;
            }
            catch (Exception e) {
                return BigDecimal.ZERO;
            }
        });
    }

    @Override
    public CompletableFuture<Double> getGiniCoefficient() {
        return CompletableFuture.supplyAsync(() -> {
            try (QueryResult result = this.dataManager.executeQuery("SELECT balance FROM ecoxpert_accounts ORDER BY balance ASC", new Object[0]).join();){
                Number balance;
                ArrayList<Double> balances = new ArrayList<Double>();
                while (result.next()) {
                    balance = result.getBigDecimal("balance");
                    if (balance == null) continue;
                    balances.add(((BigDecimal)balance).doubleValue());
                }
                if (balances.isEmpty()) {
                    balance = 0.0;
                    return balance;
                }
                int n = balances.size();
                double sumOfDifferences = 0.0;
                double sumOfBalances = 0.0;
                for (int i = 0; i < n; ++i) {
                    sumOfBalances += ((Double)balances.get(i)).doubleValue();
                    for (int j = 0; j < n; sumOfDifferences += Math.abs((Double)balances.get(i) - (Double)balances.get(j)), ++j) {
                    }
                }
                if (sumOfBalances == 0.0) {
                    Double d = 0.0;
                    return d;
                }
                Double d = sumOfDifferences / (2.0 * (double)n * sumOfBalances);
                return d;
            }
            catch (Exception e) {
                return 0.0;
            }
        });
    }

    private String getCycleDescription(EconomicIntelligenceEngine.EconomicCycle cycle) {
        return switch (cycle) {
            default -> throw new IncompatibleClassChangeError();
            case EconomicIntelligenceEngine.EconomicCycle.DEPRESSION -> "Severe economic downturn with deflation";
            case EconomicIntelligenceEngine.EconomicCycle.RECESSION -> "Economic slowdown with reduced activity";
            case EconomicIntelligenceEngine.EconomicCycle.STABLE -> "Balanced economic conditions";
            case EconomicIntelligenceEngine.EconomicCycle.GROWTH -> "Economic expansion with increasing activity";
            case EconomicIntelligenceEngine.EconomicCycle.BOOM -> "High economic activity and rapid growth";
            case EconomicIntelligenceEngine.EconomicCycle.BUBBLE -> "Overheated economy with potential correction";
        };
    }

    private String classifyEconomicClass(double balance) {
        if (balance < 1000.0) {
            return "POOR";
        }
        if (balance < 10000.0) {
            return "LOWER_MIDDLE";
        }
        if (balance < 100000.0) {
            return "MIDDLE";
        }
        if (balance < 1000000.0) {
            return "UPPER_MIDDLE";
        }
        return "WEALTHY";
    }
}

