/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.api.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.api.ProfessionService;
import me.koyere.ecoxpert.api.dto.ProfessionConfig;
import me.koyere.ecoxpert.api.dto.ProfessionInfo;
import me.koyere.ecoxpert.modules.professions.ProfessionRole;
import me.koyere.ecoxpert.modules.professions.ProfessionsManager;

public class ProfessionServiceImpl
implements ProfessionService {
    private final ProfessionsManager professionsManager;

    public ProfessionServiceImpl(ProfessionsManager professionsManager) {
        this.professionsManager = professionsManager;
    }

    @Override
    public Optional<ProfessionInfo> getProfession(UUID playerId) {
        try {
            Optional<ProfessionRole> roleOpt = this.professionsManager.getRole(playerId).join();
            if (roleOpt.isEmpty()) {
                return Optional.empty();
            }
            ProfessionRole internalRole = roleOpt.get();
            int level = this.professionsManager.getLevel(playerId).join();
            int xp = this.professionsManager.getXp(playerId).join();
            double nextLevelXP = 1000.0 * Math.pow(1.5, level);
            return Optional.of(new ProfessionInfo(playerId, this.mapProfessionRole(internalRole), level, xp, nextLevelXP));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public CompletableFuture<Boolean> setProfession(UUID playerId, me.koyere.ecoxpert.api.dto.ProfessionRole role) {
        ProfessionRole internalRole = this.unmapProfessionRole(role);
        return this.professionsManager.setRole(playerId, internalRole);
    }

    @Override
    public Map<me.koyere.ecoxpert.api.dto.ProfessionRole, ProfessionConfig> getAvailableProfessions() {
        HashMap<me.koyere.ecoxpert.api.dto.ProfessionRole, ProfessionConfig> configs = new HashMap<me.koyere.ecoxpert.api.dto.ProfessionRole, ProfessionConfig>();
        List<ProfessionRole> available = this.professionsManager.getAvailableRoles();
        for (ProfessionRole internalRole : available) {
            me.koyere.ecoxpert.api.dto.ProfessionRole apiRole = this.mapProfessionRole(internalRole);
            configs.put(apiRole, new ProfessionConfig(apiRole, 1.0, 1.0, new HashMap<String, Object>()));
        }
        return configs;
    }

    @Override
    public CompletableFuture<Integer> getProfessionLevel(UUID playerId) {
        return this.professionsManager.getLevel(playerId);
    }

    @Override
    public CompletableFuture<Double> getProfessionXP(UUID playerId) {
        return this.professionsManager.getXp(playerId).thenApply(Integer::doubleValue);
    }

    private me.koyere.ecoxpert.api.dto.ProfessionRole mapProfessionRole(ProfessionRole internal) {
        return switch (internal) {
            default -> throw new IncompatibleClassChangeError();
            case ProfessionRole.TRADER -> me.koyere.ecoxpert.api.dto.ProfessionRole.TRADER;
            case ProfessionRole.INVESTOR -> me.koyere.ecoxpert.api.dto.ProfessionRole.INDUSTRIALIST;
            case ProfessionRole.SPECULATOR -> me.koyere.ecoxpert.api.dto.ProfessionRole.ARTISAN;
            case ProfessionRole.SAVER -> me.koyere.ecoxpert.api.dto.ProfessionRole.BUILDER;
            case ProfessionRole.SPENDER -> me.koyere.ecoxpert.api.dto.ProfessionRole.FARMER;
            case ProfessionRole.HOARDER -> me.koyere.ecoxpert.api.dto.ProfessionRole.MINER;
            case ProfessionRole.PHILANTHROPIST -> me.koyere.ecoxpert.api.dto.ProfessionRole.TRADER;
        };
    }

    private ProfessionRole unmapProfessionRole(me.koyere.ecoxpert.api.dto.ProfessionRole external) {
        return switch (external) {
            default -> throw new IncompatibleClassChangeError();
            case me.koyere.ecoxpert.api.dto.ProfessionRole.TRADER -> ProfessionRole.TRADER;
            case me.koyere.ecoxpert.api.dto.ProfessionRole.INDUSTRIALIST -> ProfessionRole.INVESTOR;
            case me.koyere.ecoxpert.api.dto.ProfessionRole.ARTISAN -> ProfessionRole.SPECULATOR;
            case me.koyere.ecoxpert.api.dto.ProfessionRole.BUILDER -> ProfessionRole.SAVER;
            case me.koyere.ecoxpert.api.dto.ProfessionRole.FARMER -> ProfessionRole.SPENDER;
            case me.koyere.ecoxpert.api.dto.ProfessionRole.MINER -> ProfessionRole.HOARDER;
        };
    }
}

