/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.commands;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.koyere.ecoxpert.commands.BaseCommand;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BalanceCommand
extends BaseCommand {
    public BalanceCommand(EconomyManager economyManager, TranslationManager translationManager) {
        super(economyManager, translationManager);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.handleCommandSafely(sender, "balance", () -> {
            Player target;
            this.logger.info("ECOXPERT DEBUG - BalanceCommand started for: " + sender.getName());
            if (!this.hasPermission(sender, "ecoxpert.economy.balance")) {
                this.logger.warning("ECOXPERT DEBUG - Permission denied for: " + sender.getName());
                return;
            }
            if (args.length == 0) {
                Player player = this.requirePlayer(sender);
                if (player == null) {
                    this.logger.warning("ECOXPERT DEBUG - requirePlayer returned null");
                    return;
                }
                target = player;
                this.logger.info("ECOXPERT DEBUG - Checking own balance for: " + player.getName());
            } else {
                if (!this.hasPermission(sender, "ecoxpert.admin.economy")) {
                    this.logger.warning("ECOXPERT DEBUG - Admin permission denied for: " + sender.getName());
                    return;
                }
                target = this.findPlayer(sender, args[0]);
                if (target == null) {
                    this.logger.warning("ECOXPERT DEBUG - findPlayer returned null for: " + args[0]);
                    return;
                }
                this.logger.info("ECOXPERT DEBUG - Checking balance for other player: " + target.getName());
            }
            this.logger.info("ECOXPERT DEBUG - About to ensureAccount for UUID: " + String.valueOf(target.getUniqueId()));
            ((CompletableFuture)this.ensureAccount(target.getUniqueId()).thenRun(() -> this.lambda$onCommand$2((OfflinePlayer)target, sender))).exceptionally(arg_0 -> this.lambda$onCommand$3((OfflinePlayer)target, sender, arg_0));
        });
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1 && sender.hasPermission("ecoxpert.admin.economy")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private /* synthetic */ Void lambda$onCommand$3(OfflinePlayer target, CommandSender sender, Throwable throwable) {
        this.logger.log(Level.SEVERE, "ECOXPERT ERROR - ensureAccount failed in command for: " + target.getName(), throwable);
        this.sendMessage(sender, "error.database_error", new Object[0]);
        return null;
    }

    private /* synthetic */ void lambda$onCommand$2(OfflinePlayer target, CommandSender sender) {
        this.logger.info("ECOXPERT DEBUG - ensureAccount completed, getting balance for: " + String.valueOf(target.getUniqueId()));
        ((CompletableFuture)this.economyManager.getBalance(target.getUniqueId()).thenAccept(balance -> {
            this.logger.info("ECOXPERT DEBUG - getBalance returned: " + String.valueOf(balance) + " for: " + target.getName());
            String formattedBalance = this.economyManager.formatMoney((BigDecimal)balance);
            if (target.equals(sender)) {
                this.sendMessage(sender, "commands.balance.own", formattedBalance);
            } else {
                this.sendMessage(sender, "commands.balance.other", target.getName(), formattedBalance);
            }
            this.logger.info("ECOXPERT DEBUG - Balance command completed successfully");
        })).exceptionally(throwable -> {
            this.logger.log(Level.SEVERE, "ECOXPERT ERROR - getBalance failed for: " + target.getName(), (Throwable)throwable);
            this.sendMessage(sender, "error.database_error", new Object[0]);
            return null;
        });
    }
}

