/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.commands;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.commands.BaseCommand;
import me.koyere.ecoxpert.core.safety.RateLimitManager;
import me.koyere.ecoxpert.core.safety.SafeModeManager;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.bank.BankManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class BankCommand
extends BaseCommand {
    private final BankManager bankManager;

    public BankCommand(BankManager bankManager, EconomyManager economyManager, TranslationManager translationManager) {
        super(economyManager, translationManager);
        this.bankManager = bankManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, "error.player_only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.showBalance(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "balance": {
                this.showBalance(player);
                break;
            }
            case "deposit": {
                this.handleDeposit(player, args);
                break;
            }
            case "withdraw": {
                this.handleWithdraw(player, args);
                break;
            }
            case "transfer": {
                this.handleTransfer(player, args);
                break;
            }
            case "help": {
                this.showHelp(player);
                break;
            }
            default: {
                this.sendMessage(sender, "command.usage.bank", new Object[0]);
            }
        }
        return true;
    }

    private void showBalance(Player player) {
        ((CompletableFuture)this.bankManager.getBalance(player.getUniqueId()).thenAccept(balance -> player.sendMessage(this.translationManager.getMessage("bank.balance", this.economyManager.formatMoney((BigDecimal)balance), new Object[0])))).exceptionally(ex -> {
            player.sendMessage(this.translationManager.getMessage("bank.error.generic", new Object[0]));
            return null;
        });
    }

    private void handleDeposit(Player player, String[] args) {
        SafeModeManager safe = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(SafeModeManager.class);
        if (safe != null && safe.isActive()) {
            player.sendMessage(this.translationManager.getMessage("bank.error.safe-mode", new Object[0]));
            return;
        }
        RateLimitManager limiter = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(RateLimitManager.class);
        if (limiter != null && !limiter.allow(player.getUniqueId(), "bank.deposit")) {
            player.sendMessage(this.translationManager.getMessage("errors.rate_limited", new Object[0]));
            return;
        }
        if (args.length < 2) {
            player.sendMessage(this.translationManager.getMessage("command.usage.bank.deposit", new Object[0]));
            return;
        }
        BigDecimal amount = this.parseAmount((CommandSender)player, args[1]);
        if (amount == null) {
            return;
        }
        this.bankManager.deposit(player, amount).thenAccept(result -> {
            if (result.isSuccess()) {
                player.sendMessage(this.translationManager.getMessage("bank.deposit.success", this.economyManager.formatMoney(amount), new Object[0]));
            } else {
                player.sendMessage(result.getFormattedMessage());
            }
        });
    }

    private void handleWithdraw(Player player, String[] args) {
        SafeModeManager safe = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(SafeModeManager.class);
        if (safe != null && safe.isActive()) {
            player.sendMessage(this.translationManager.getMessage("bank.error.safe-mode", new Object[0]));
            return;
        }
        RateLimitManager limiter = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(RateLimitManager.class);
        if (limiter != null && !limiter.allow(player.getUniqueId(), "bank.withdraw")) {
            player.sendMessage(this.translationManager.getMessage("errors.rate_limited", new Object[0]));
            return;
        }
        if (args.length < 2) {
            player.sendMessage(this.translationManager.getMessage("command.usage.bank.withdraw", new Object[0]));
            return;
        }
        BigDecimal amount = this.parseAmount((CommandSender)player, args[1]);
        if (amount == null) {
            return;
        }
        this.bankManager.withdraw(player, amount).thenAccept(result -> {
            if (result.isSuccess()) {
                player.sendMessage(this.translationManager.getMessage("bank.withdraw.success", this.economyManager.formatMoney(amount), new Object[0]));
            } else {
                player.sendMessage(result.getFormattedMessage());
            }
        });
    }

    private void handleTransfer(Player player, String[] args) {
        SafeModeManager safe = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(SafeModeManager.class);
        if (safe != null && safe.isActive()) {
            player.sendMessage(this.translationManager.getMessage("bank.error.safe-mode", new Object[0]));
            return;
        }
        RateLimitManager limiter = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(RateLimitManager.class);
        if (limiter != null && !limiter.allow(player.getUniqueId(), "bank.transfer")) {
            player.sendMessage(this.translationManager.getMessage("errors.rate_limited", new Object[0]));
            return;
        }
        if (args.length < 3) {
            player.sendMessage(this.translationManager.getMessage("command.usage.bank.transfer", new Object[0]));
            return;
        }
        BigDecimal amount = this.parseAmount((CommandSender)player, args[2]);
        if (amount == null) {
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            player.sendMessage(this.translationManager.getMessage("command.error.player-not-found", new Object[0]));
            return;
        }
        this.bankManager.transfer(player, target.getUniqueId(), amount).thenAccept(result -> {
            if (result.isSuccess()) {
                player.sendMessage(this.translationManager.getMessage("bank.transfer.success.sender", this.economyManager.formatMoney(amount), target.getName()));
                target.sendMessage(this.translationManager.getMessage("bank.transfer.success.receiver", this.economyManager.formatMoney(amount), player.getName()));
            } else {
                player.sendMessage(result.getFormattedMessage());
            }
        });
    }

    private void showHelp(Player player) {
        player.sendMessage("\u00a76=== Bank Commands ===");
        player.sendMessage("\u00a7e/bank balance \u00a77- View your bank balance");
        player.sendMessage("\u00a7e/bank deposit <amount> \u00a77- Deposit money");
        player.sendMessage("\u00a7e/bank withdraw <amount> \u00a77- Withdraw money");
        player.sendMessage("\u00a7e/bank transfer <player> <amount> \u00a77- Transfer money");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            return List.of("balance", "deposit", "withdraw", "transfer", "help");
        }
        return Collections.emptyList();
    }
}

