/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.commands;

import java.math.BigDecimal;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public abstract class BaseCommand
implements CommandExecutor,
TabCompleter {
    protected final EconomyManager economyManager;
    protected final TranslationManager translationManager;
    protected final Logger logger;

    protected BaseCommand(EconomyManager economyManager, TranslationManager translationManager) {
        this.economyManager = economyManager;
        this.translationManager = translationManager;
        this.logger = Bukkit.getLogger();
    }

    protected void sendMessage(CommandSender sender, String key, Object ... args) {
        String message = this.translationManager.getMessage(key, args);
        sender.sendMessage(message);
    }

    protected boolean hasPermission(CommandSender sender, String permission) {
        if (sender.hasPermission(permission)) {
            return true;
        }
        this.sendMessage(sender, "error.no_permission", new Object[0]);
        return false;
    }

    protected Player requirePlayer(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, "error.player_only", new Object[0]);
            return null;
        }
        return (Player)sender;
    }

    protected BigDecimal parseAmount(CommandSender sender, String amountStr) {
        try {
            double amount = Double.parseDouble(amountStr);
            if (amount <= 0.0) {
                this.sendMessage(sender, "error.invalid_amount", new Object[0]);
                return null;
            }
            return BigDecimal.valueOf(amount);
        }
        catch (NumberFormatException e) {
            this.sendMessage(sender, "error.invalid_number", amountStr);
            return null;
        }
    }

    protected OfflinePlayer findPlayer(CommandSender sender, String playerName) {
        Player online = Bukkit.getPlayer((String)playerName);
        if (online != null) {
            return online;
        }
        OfflinePlayer offline = Bukkit.getOfflinePlayer((String)playerName);
        if (!offline.hasPlayedBefore()) {
            this.sendMessage(sender, "error.player_not_found", playerName);
            return null;
        }
        return offline;
    }

    protected CompletableFuture<Void> ensureAccount(UUID playerUuid) {
        return ((CompletableFuture)this.economyManager.hasAccount(playerUuid).thenCompose(hasAccount -> {
            if (!hasAccount.booleanValue()) {
                return this.economyManager.createAccount(playerUuid, this.economyManager.getStartingBalance());
            }
            return CompletableFuture.completedFuture(null);
        })).exceptionally(throwable -> {
            this.logger.log(Level.SEVERE, "ECOXPERT ERROR - ensureAccount failed for UUID: " + String.valueOf(playerUuid), (Throwable)throwable);
            return null;
        });
    }

    protected void handleCommandSafely(CommandSender sender, String commandName, Runnable command) {
        try {
            this.logger.info("ECOXPERT DEBUG - Executing command: " + commandName + " for sender: " + sender.getName());
            command.run();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "ECOXPERT ERROR - Command execution failed: " + commandName, e);
            this.sendMessage(sender, "error.database_error", new Object[0]);
        }
    }
}

