/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.commands;

import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.commands.AdminGuiCommand;
import me.koyere.ecoxpert.commands.BalanceCommand;
import me.koyere.ecoxpert.commands.BankCommand;
import me.koyere.ecoxpert.commands.BankGuiCommand;
import me.koyere.ecoxpert.commands.EcoCommand;
import me.koyere.ecoxpert.commands.EventsGuiCommand;
import me.koyere.ecoxpert.commands.LoansCommand;
import me.koyere.ecoxpert.commands.LoansGuiCommand;
import me.koyere.ecoxpert.commands.MarketCommand;
import me.koyere.ecoxpert.commands.PayCommand;
import me.koyere.ecoxpert.commands.ProfessionCommand;
import me.koyere.ecoxpert.commands.ProfessionGuiCommand;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.bank.BankManager;
import me.koyere.ecoxpert.modules.events.EconomicEventEngine;
import me.koyere.ecoxpert.modules.loans.LoanManager;
import me.koyere.ecoxpert.modules.loans.LoanNotificationListener;
import me.koyere.ecoxpert.modules.market.MarketManager;
import me.koyere.ecoxpert.modules.professions.ProfessionsManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CommandManager {
    private final EcoXpertPlugin plugin;
    private final EconomyManager economyManager;
    private final MarketManager marketManager;
    private final BankManager bankManager;
    private final TranslationManager translationManager;
    private final EconomicEventEngine eventEngine;
    private final LoanManager loanManager;
    private MarketCommand marketCommand;

    public CommandManager(EcoXpertPlugin plugin, EconomyManager economyManager, MarketManager marketManager, BankManager bankManager, TranslationManager translationManager) {
        this.plugin = plugin;
        this.economyManager = economyManager;
        this.marketManager = marketManager;
        this.bankManager = bankManager;
        this.translationManager = translationManager;
        this.eventEngine = plugin.getServiceRegistry().getInstance(EconomicEventEngine.class);
        this.loanManager = plugin.getServiceRegistry().getInstance(LoanManager.class);
    }

    public void registerCommands() {
        EcoCommand ecoCommand = new EcoCommand(this.economyManager, this.translationManager, this.eventEngine);
        this.plugin.getCommand("ecoxpert").setExecutor((CommandExecutor)ecoCommand);
        this.plugin.getCommand("ecoxpert").setTabCompleter((TabCompleter)ecoCommand);
        BalanceCommand balanceCommand = new BalanceCommand(this.economyManager, this.translationManager);
        this.plugin.getCommand("ecobalance").setExecutor((CommandExecutor)balanceCommand);
        this.plugin.getCommand("ecobalance").setTabCompleter((TabCompleter)balanceCommand);
        PayCommand payCommand = new PayCommand(this.economyManager, this.translationManager);
        this.plugin.getCommand("ecopay").setExecutor((CommandExecutor)payCommand);
        this.plugin.getCommand("ecopay").setTabCompleter((TabCompleter)payCommand);
        this.marketCommand = new MarketCommand(this.marketManager, this.translationManager, this.plugin.getLogger());
        this.plugin.getCommand("market").setExecutor((CommandExecutor)this.marketCommand);
        this.plugin.getCommand("market").setTabCompleter((TabCompleter)this.marketCommand);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.marketCommand.getMarketGUI(), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.marketCommand.getOrdersGUI(), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new LoanNotificationListener(this.plugin, this.plugin.getServiceRegistry().getInstance(DataManager.class), this.translationManager), (Plugin)this.plugin);
        BankCommand bankCommand = new BankCommand(this.bankManager, this.economyManager, this.translationManager);
        this.plugin.getCommand("bank").setExecutor((CommandExecutor)bankCommand);
        this.plugin.getCommand("bank").setTabCompleter((TabCompleter)bankCommand);
        if (this.plugin.getCommand("bankgui") != null) {
            this.plugin.getCommand("bankgui").setExecutor((CommandExecutor)new BankGuiCommand(this.plugin, this.bankManager, this.economyManager, this.translationManager));
        }
        LoansCommand loansCommand = new LoansCommand(this.loanManager, this.economyManager, this.translationManager);
        if (this.plugin.getCommand("loans") != null) {
            this.plugin.getCommand("loans").setExecutor((CommandExecutor)loansCommand);
            this.plugin.getCommand("loans").setTabCompleter((TabCompleter)loansCommand);
        }
        if (this.plugin.getCommand("loansgui") != null) {
            this.plugin.getCommand("loansgui").setExecutor((CommandExecutor)new LoansGuiCommand(this.plugin, this.loanManager, this.economyManager, this.translationManager));
        }
        if (this.plugin.getCommand("ecoadmin") != null) {
            this.plugin.getCommand("ecoadmin").setExecutor((CommandExecutor)new AdminGuiCommand(this.plugin, this.translationManager));
        }
        if (this.plugin.getCommand("ecoevents") != null) {
            this.plugin.getCommand("ecoevents").setExecutor((CommandExecutor)new EventsGuiCommand(this.plugin, this.plugin.getServiceRegistry().getInstance(EconomicEventEngine.class), this.translationManager));
        }
        if (this.plugin.getCommand("professiongui") != null) {
            this.plugin.getCommand("professiongui").setExecutor((CommandExecutor)new ProfessionGuiCommand(this.plugin, this.plugin.getServiceRegistry().getInstance(ProfessionsManager.class), this.translationManager));
        }
        if (this.plugin.getCommand("profession") != null) {
            this.plugin.getCommand("profession").setExecutor((CommandExecutor)new ProfessionCommand(this.plugin.getServiceRegistry().getInstance(ProfessionsManager.class), this.translationManager));
            this.plugin.getCommand("profession").setTabCompleter((TabCompleter)new ProfessionCommand(this.plugin.getServiceRegistry().getInstance(ProfessionsManager.class), this.translationManager));
        }
        this.plugin.getLogger().info("Registered economy and market commands");
    }

    public void unregisterCommands() {
        if (this.marketCommand != null) {
            this.marketCommand.getMarketGUI().closeAllGUIs();
        }
        this.plugin.getLogger().info("Unregistered economy commands");
    }
}

