/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.commands;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.commands.BaseCommand;
import me.koyere.ecoxpert.core.ServiceRegistry;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.data.DatabaseStatus;
import me.koyere.ecoxpert.core.data.QueryResult;
import me.koyere.ecoxpert.core.economy.EconomyConflictDetector;
import me.koyere.ecoxpert.core.economy.EconomySyncManager;
import me.koyere.ecoxpert.core.economy.EconomySystemTestRunner;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.events.EconomicEvent;
import me.koyere.ecoxpert.modules.events.EconomicEventEngine;
import me.koyere.ecoxpert.modules.events.EconomicEventType;
import me.koyere.ecoxpert.modules.inflation.InflationManager;
import me.koyere.ecoxpert.modules.integrations.IntegrationsManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class EcoCommand
extends BaseCommand {
    private final EconomicEventEngine eventEngine;

    public EcoCommand(EconomyManager economyManager, TranslationManager translationManager, EconomicEventEngine eventEngine) {
        super(economyManager, translationManager);
        this.eventEngine = eventEngine;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        String subcommand = args[0].toLowerCase();
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (subcommand) {
            case "balance": 
            case "bal": {
                return this.handleBalance(sender, subArgs);
            }
            case "pay": {
                return this.handlePay(sender, subArgs);
            }
            case "set": {
                return this.handleSet(sender, subArgs);
            }
            case "add": 
            case "give": {
                return this.handleAdd(sender, subArgs);
            }
            case "remove": 
            case "take": {
                return this.handleRemove(sender, subArgs);
            }
            case "events": {
                return this.handleEvents(sender, subArgs);
            }
            case "economy": {
                return this.handleEconomy(sender, subArgs);
            }
            case "integrations": {
                return this.handleIntegrations(sender, subArgs);
            }
            case "migrate": 
            case "import": {
                return this.handleMigrate(sender, subArgs);
            }
        }
        this.sendHelpMessage(sender);
        return true;
    }

    private boolean handleIntegrations(CommandSender sender, String[] args) {
        if (!sender.hasPermission("ecoxpert.admin.integrations")) {
            this.sendMessage(sender, "error.no_permission", new Object[0]);
            return true;
        }
        ServiceRegistry sr = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry();
        IntegrationsManager integ = sr.getInstance(IntegrationsManager.class);
        FileConfiguration cfg = sr.getInstance(ConfigManager.class).getModuleConfig("integrations");
        boolean enabled = cfg.getBoolean("enabled", true);
        sender.sendMessage("\u00a76=== Integrations Status ===");
        sender.sendMessage("\u00a77Enabled: \u00a7e" + enabled);
        try {
            sender.sendMessage("\u00a77Jobs: \u00a7e" + (integ != null && integ.hasJobs()));
            sender.sendMessage("\u00a77WorldGuard: \u00a7e" + (integ != null && integ.hasWorldGuard()));
            sender.sendMessage("\u00a77Lands: \u00a7e" + (integ != null && integ.hasLands()));
            sender.sendMessage("\u00a77Towny: \u00a7e" + (integ != null && integ.hasTowny()));
            sender.sendMessage("\u00a77Slimefun: \u00a7e" + (integ != null && integ.hasSlimefun()));
            sender.sendMessage("\u00a77McMMO: \u00a7e" + (integ != null && integ.hasMcMMO()));
            if (cfg.getBoolean("jobs.dynamic.enabled", true)) {
                List th = cfg.getList("jobs.dynamic.inflation.thresholds");
                sender.sendMessage("\u00a77Jobs dynamic thresholds: \u00a7e" + (th != null ? th.size() : 0));
            }
            if (cfg.getBoolean("territory.enabled", true)) {
                ConfigurationSection wg = cfg.getConfigurationSection("territory.worldguard.rules");
                ConfigurationSection ld = cfg.getConfigurationSection("territory.lands");
                ConfigurationSection ty = cfg.getConfigurationSection("territory.towny.rules");
                sender.sendMessage("\u00a77Territory WG rules: \u00a7e" + (wg != null ? wg.getKeys(false).size() : 0));
                sender.sendMessage("\u00a77Territory Lands entries: \u00a7e" + (ld != null ? ld.getKeys(false).size() : 0));
                sender.sendMessage("\u00a77Territory Towny rules: \u00a7e" + (ty != null ? ty.getKeys(false).size() : 0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private boolean handleEvents(CommandSender sender, String[] args) {
        String sub;
        if (!sender.hasPermission("ecoxpert.admin.events")) {
            this.sendMessage(sender, "error.no_permission", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.sendMessage(sender, "events.admin.help.header", new Object[0]);
            this.sendMessage(sender, "events.admin.help.status", new Object[0]);
            this.sendMessage(sender, "events.admin.help.active", new Object[0]);
            this.sendMessage(sender, "events.admin.help.history", new Object[0]);
            this.sendMessage(sender, "events.admin.help.trigger", new Object[0]);
            this.sendMessage(sender, "events.admin.help.end", new Object[0]);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "status": {
                return this.handleEventsStatus(sender);
            }
            case "active": {
                return this.handleEventsActive(sender);
            }
            case "history": {
                return this.handleEventsHistory(sender);
            }
            case "stats": {
                return this.handleEventsStats(sender, args);
            }
            case "recent": {
                return this.handleEventsRecent(sender);
            }
            case "statsdetail": {
                return this.handleEventsStatsDetail(sender, args);
            }
            case "anti-stagnation": 
            case "antistagnation": {
                return this.handleEventsAntiStagnation(sender);
            }
            case "pause": {
                return this.handleEventsPause(sender);
            }
            case "resume": {
                return this.handleEventsResume(sender);
            }
            case "trigger": {
                return this.handleEventsTrigger(sender, args);
            }
            case "end": {
                return this.handleEventsEnd(sender, args);
            }
        }
        this.sendMessage(sender, "events.admin.unknown", new Object[0]);
        return true;
    }

    private boolean handleEventsStatus(CommandSender sender) {
        boolean engineActive = this.eventEngine.isEventEngineActive();
        int active = this.eventEngine.getActiveEvents().size();
        int history = this.eventEngine.getEventHistory().size();
        this.sendMessage(sender, "events.admin.status", engineActive, active, history);
        return true;
    }

    private boolean handleEventsRecent(CommandSender sender) {
        try {
            DataManager dm = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(DataManager.class);
            try (QueryResult qr = dm.executeQuery("SELECT event_id, type, status, start_time, end_time FROM ecoxpert_economic_events ORDER BY id DESC LIMIT 10", new Object[0]).join();){
                boolean any = false;
                this.sendMessage(sender, "events.admin.recent.header", new Object[0]);
                while (qr.next()) {
                    any = true;
                    String id = qr.getString("event_id");
                    String type = qr.getString("type");
                    String status = qr.getString("status");
                    String start = String.valueOf(qr.getTimestamp("start_time"));
                    String end = String.valueOf(qr.getTimestamp("end_time"));
                    this.sendMessage(sender, "events.admin.recent.item", id, type, status, start, end);
                }
                if (!any) {
                    this.sendMessage(sender, "events.admin.recent.none", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to load recent events");
        }
        return true;
    }

    private boolean handleEventsAntiStagnation(CommandSender sender) {
        long hoursSince = this.eventEngine.getHoursSinceLastEvent();
        int quiet = this.eventEngine.getConsecutiveQuietHours();
        this.sendMessage(sender, "events.admin.antistagnation.info", hoursSince, quiet);
        return true;
    }

    private boolean handleEventsPause(CommandSender sender) {
        this.eventEngine.pauseEngine();
        this.sendMessage(sender, "events.admin.engine.paused", new Object[0]);
        return true;
    }

    private boolean handleEventsResume(CommandSender sender) {
        this.eventEngine.resumeEngine();
        this.sendMessage(sender, "events.admin.engine.resumed", new Object[0]);
        return true;
    }

    private boolean handleEventsActive(CommandSender sender) {
        Map<String, EconomicEvent> active = this.eventEngine.getActiveEvents();
        if (active.isEmpty()) {
            this.sendMessage(sender, "events.admin.active.none", new Object[0]);
            return true;
        }
        this.sendMessage(sender, "events.admin.active.header", new Object[0]);
        for (EconomicEvent ev : active.values()) {
            this.sendMessage(sender, "events.admin.active.item", ev.getId(), ev.getName(), ev.getType().name(), ev.getDuration());
        }
        return true;
    }

    private boolean handleEventsHistory(CommandSender sender) {
        List<EconomicEvent> history = this.eventEngine.getEventHistory();
        if (history.isEmpty()) {
            this.sendMessage(sender, "events.admin.history.none", new Object[0]);
            return true;
        }
        this.sendMessage(sender, "events.admin.history.header", new Object[0]);
        int start = Math.max(0, history.size() - 10);
        for (int i = history.size() - 1; i >= start; --i) {
            EconomicEvent ev = history.get(i);
            this.sendMessage(sender, "events.admin.history.item", ev.getId(), ev.getName(), ev.getType().name(), ev.getStatus().name());
        }
        return true;
    }

    private boolean handleEventsTrigger(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.sendMessage(sender, "events.admin.trigger.usage", new Object[0]);
            return true;
        }
        try {
            EconomicEventType type = EconomicEventType.valueOf(args[1].toUpperCase());
            boolean ok = this.eventEngine.triggerEvent(type);
            if (ok) {
                this.sendMessage(sender, "events.admin.triggered", type.name());
            } else if (!this.eventEngine.getActiveEvents().isEmpty()) {
                this.sendMessage(sender, "events.admin.active.header", new Object[0]);
                for (EconomicEvent ev : this.eventEngine.getActiveEvents().values()) {
                    this.sendMessage(sender, "events.admin.active.item", ev.getId(), ev.getName(), ev.getType().name(), ev.getDuration());
                }
                sender.sendMessage("\u00a77Hint: end the active event or wait for cooldown.");
            } else {
                this.sendMessage(sender, "events.admin.trigger.failed", type.name());
            }
        }
        catch (IllegalArgumentException e) {
            this.sendMessage(sender, "events.admin.unknown_type", args[1]);
        }
        return true;
    }

    private boolean handleEventsEnd(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.sendMessage(sender, "events.admin.end.usage", new Object[0]);
            return true;
        }
        String id = args[1];
        boolean ended = this.eventEngine.endEventById(id);
        if (ended) {
            this.sendMessage(sender, "events.admin.ended", id);
        } else {
            this.sendMessage(sender, "events.admin.not_found", id);
        }
        return true;
    }

    private boolean handleEventsStats(CommandSender sender, String[] args) {
        int days = 30;
        if (args.length >= 2) {
            try {
                days = Math.max(1, Integer.parseInt(args[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            DataManager dm = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(DataManager.class);
            try (QueryResult qr = dm.executeQuery("SELECT type, COUNT(*) as cnt FROM ecoxpert_economic_events WHERE start_time >= datetime('now', '-' || ? || ' days') GROUP BY type ORDER BY cnt DESC", days).join();){
                boolean any = false;
                this.sendMessage(sender, "events.admin.stats.header", days);
                int total = 0;
                while (qr.next()) {
                    any = true;
                    String type = qr.getString("type");
                    Integer cntObj = qr.getInt("cnt");
                    int cnt = cntObj != null ? cntObj : (qr.getLong("cnt") != null ? qr.getLong("cnt").intValue() : 0);
                    total += cnt;
                    this.sendMessage(sender, "events.admin.stats.item", type, cnt);
                }
                if (!any) {
                    this.sendMessage(sender, "events.admin.stats.none", days);
                } else {
                    this.sendMessage(sender, "events.admin.stats.total", total);
                }
            }
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to load event stats");
        }
        return true;
    }

    private boolean handleEventsStatsDetail(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /ecoxpert events statsdetail <TYPE> [days]");
            return true;
        }
        String typeArg = args[1].toUpperCase();
        int days = 30;
        if (args.length >= 3) {
            try {
                days = Math.max(1, Integer.parseInt(args[2]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            EconomicEventType type = EconomicEventType.valueOf(typeArg);
            DataManager dm = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(DataManager.class);
            try (QueryResult qr = dm.executeQuery("SELECT parameters, start_time, end_time FROM ecoxpert_economic_events WHERE type = ? AND start_time >= datetime('now', '-' || ? || ' days')", type.name(), days).join();){
                int count = 0;
                long durSum = 0L;
                int durCount = 0;
                int itemsSum = 0;
                int itemsCount = 0;
                double buySum = 0.0;
                int buyCount = 0;
                double sellSum = 0.0;
                int sellCount = 0;
                double stimulusSum = 0.0;
                while (qr.next()) {
                    Double stim;
                    Double sd;
                    Double bd;
                    Integer items;
                    ++count;
                    String params = qr.getString("parameters");
                    Long dur = this.parseJsonLong(params, "metrics.duration_minutes");
                    if (dur == null) {
                        try {
                            Timestamp s = qr.getTimestamp("start_time");
                            Timestamp e = qr.getTimestamp("end_time");
                            if (s != null && e != null) {
                                long mins = Duration.between(s.toLocalDateTime(), e.toLocalDateTime()).toMinutes();
                                dur = mins;
                            }
                        }
                        catch (Exception s) {
                            // empty catch block
                        }
                    }
                    if (dur != null) {
                        durSum += dur.longValue();
                        ++durCount;
                    }
                    if ((items = this.parseJsonInt(params, "metrics.items")) != null) {
                        itemsSum += items.intValue();
                        ++itemsCount;
                    }
                    if ((bd = this.parseJsonDouble(params, "metrics.buy_delta")) != null) {
                        buySum += bd.doubleValue();
                        ++buyCount;
                    }
                    if ((sd = this.parseJsonDouble(params, "metrics.sell_delta")) != null) {
                        sellSum += sd.doubleValue();
                        ++sellCount;
                    }
                    if ((stim = this.parseJsonDouble(params, "metrics.total_stimulus")) == null) continue;
                    stimulusSum += stim.doubleValue();
                }
                this.sendMessage(sender, "events.admin.statsdetail.header", type.name(), days);
                this.sendMessage(sender, "events.admin.statsdetail.count", count);
                if (durCount > 0) {
                    this.sendMessage(sender, "events.admin.statsdetail.avg_duration", durSum / (long)Math.max(1, durCount));
                }
                if (itemsCount > 0) {
                    this.sendMessage(sender, "events.admin.statsdetail.avg_items", itemsSum / Math.max(1, itemsCount));
                }
                if (buyCount > 0) {
                    this.sendMessage(sender, "events.admin.statsdetail.avg_buy_delta", String.format("%.2f%%", buySum / (double)buyCount * 100.0));
                }
                if (sellCount > 0) {
                    this.sendMessage(sender, "events.admin.statsdetail.avg_sell_delta", String.format("%.2f%%", sellSum / (double)sellCount * 100.0));
                }
                if (stimulusSum > 0.0) {
                    String money = this.economyManager.formatMoney(BigDecimal.valueOf(stimulusSum));
                    this.sendMessage(sender, "events.admin.statsdetail.total_stimulus", money);
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.sendMessage(sender, "events.admin.unknown_type", args[1]);
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to load detailed stats");
        }
        return true;
    }

    private Double parseJsonDouble(String json, String key) {
        try {
            int j;
            String token = "\"" + key + "\":";
            int i = json.indexOf(token);
            if (i < 0) {
                return null;
            }
            for (j = i += token.length(); j < json.length() && "-+.0123456789".indexOf(json.charAt(j)) >= 0; ++j) {
            }
            return Double.parseDouble(json.substring(i, j));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private Integer parseJsonInt(String json, String key) {
        Double d = this.parseJsonDouble(json, key);
        return d != null ? Integer.valueOf((int)Math.round(d)) : null;
    }

    private Long parseJsonLong(String json, String key) {
        Double d = this.parseJsonDouble(json, key);
        return d != null ? Long.valueOf(d.longValue()) : null;
    }

    private boolean handleEconomy(CommandSender sender, String[] args) {
        String sub;
        if (!sender.hasPermission("ecoxpert.admin") && !sender.hasPermission("ecoxpert.admin.economy")) {
            this.sendMessage(sender, "error.no_permission", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.sendMessage(sender, "economy.admin.help.header", new Object[0]);
            this.sendMessage(sender, "economy.admin.help.status", new Object[0]);
            this.sendMessage(sender, "economy.admin.help.diagnostics", new Object[0]);
            this.sendMessage(sender, "economy.admin.help.policy", new Object[0]);
            sender.sendMessage("\u00a77Use \u00a7e/ecoxpert economy health \u00a77to view CPI and score");
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "status": {
                return this.handleEconomyStatus(sender);
            }
            case "diagnostics": {
                return this.handleEconomyDiagnostics(sender);
            }
            case "health": {
                return this.handleEconomyHealth(sender);
            }
            case "policy": {
                return this.handleEconomyPolicy(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "loans": {
                return this.handleEconomyLoans(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        this.sendMessage(sender, "economy.admin.unknown", new Object[0]);
        return true;
    }

    private boolean handleEconomyLoans(CommandSender sender, String[] args) {
        block48: {
            if (!sender.hasPermission("ecoxpert.admin") && !sender.hasPermission("ecoxpert.admin.loans")) {
                this.sendMessage(sender, "error.no_permission", new Object[0]);
                return true;
            }
            if (args.length == 0) {
                this.sendMessage(sender, "economy.admin.loans.help.header", new Object[0]);
                this.sendMessage(sender, "economy.admin.loans.help.stats", new Object[0]);
                this.sendMessage(sender, "economy.admin.loans.help.statsdetail", new Object[0]);
                return true;
            }
            String sub = args[0].toLowerCase();
            int days = 30;
            if (args.length >= 2) {
                try {
                    days = Math.max(1, Integer.parseInt(args[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                DataManager dm = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(DataManager.class);
                if (sub.equals("stats")) {
                    Integer c;
                    int active = 0;
                    String outstanding = "0";
                    String avgRate = "0";
                    int late = 0;
                    try (QueryResult q1 = dm.executeQuery("SELECT COUNT(*) as c FROM ecoxpert_loans WHERE status='ACTIVE'", new Object[0]).join();){
                        if (q1.next()) {
                            c = q1.getInt("c");
                            active = c != null ? c : (q1.getLong("c") != null ? q1.getLong("c").intValue() : 0);
                        }
                    }
                    try (QueryResult q2 = dm.executeQuery("SELECT SUM(outstanding) as s, AVG(interest_rate) as r FROM ecoxpert_loans WHERE status='ACTIVE'", new Object[0]).join();){
                        if (q2.next()) {
                            BigDecimal s = q2.getBigDecimal("s");
                            BigDecimal r = q2.getBigDecimal("r");
                            outstanding = s != null ? ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(EconomyManager.class).formatMoney(s) : "$0";
                            avgRate = r != null ? String.valueOf(r.multiply(new BigDecimal("100")).setScale(2)) + "%" : "0%";
                        }
                    }
                    try (QueryResult q3 = dm.executeQuery("SELECT COUNT(*) as c FROM ecoxpert_loan_schedules WHERE status='LATE' AND due_date >= date('now', '-' || ? || ' days')", days).join();){
                        if (q3.next()) {
                            c = q3.getInt("c");
                            late = c != null ? c : (q3.getLong("c") != null ? q3.getLong("c").intValue() : 0);
                        }
                    }
                    this.sendMessage(sender, "economy.admin.loans.stats.header", days);
                    this.sendMessage(sender, "economy.admin.loans.stats.active", active);
                    this.sendMessage(sender, "economy.admin.loans.stats.outstanding", outstanding);
                    this.sendMessage(sender, "economy.admin.loans.stats.avg_rate", avgRate);
                    this.sendMessage(sender, "economy.admin.loans.stats.late", late);
                    return true;
                }
                if (!sub.equals("statsdetail")) break block48;
                int created = 0;
                int paidInst = 0;
                int pendingInst = 0;
                int lateInst = 0;
                try (QueryResult q1 = dm.executeQuery("SELECT COUNT(*) as c FROM ecoxpert_loans WHERE created_at >= datetime('now', '-' || ? || ' days')", days).join();){
                    if (q1.next()) {
                        Integer c = q1.getInt("c");
                        created = c != null ? c : (q1.getLong("c") != null ? q1.getLong("c").intValue() : 0);
                    }
                }
                try (QueryResult q2 = dm.executeQuery("SELECT status, COUNT(*) as c FROM ecoxpert_loan_schedules WHERE due_date >= date('now', '-' || ? || ' days') GROUP BY status", days).join();){
                    while (q2.next()) {
                        int v;
                        String st = q2.getString("status");
                        Integer c = q2.getInt("c");
                        int n = c != null ? c : (v = q2.getLong("c") != null ? q2.getLong("c").intValue() : 0);
                        if ("PAID".equalsIgnoreCase(st)) {
                            paidInst = v;
                            continue;
                        }
                        if ("LATE".equalsIgnoreCase(st)) {
                            lateInst = v;
                            continue;
                        }
                        pendingInst = v;
                    }
                }
                this.sendMessage(sender, "economy.admin.loans.statsdetail.header", days);
                this.sendMessage(sender, "economy.admin.loans.statsdetail.created", created);
                this.sendMessage(sender, "economy.admin.loans.statsdetail.installments", paidInst + pendingInst + lateInst, paidInst, pendingInst, lateInst);
                return true;
            }
            catch (Exception e) {
                sender.sendMessage("\u00a7cFailed to load loans stats");
            }
        }
        return true;
    }

    private boolean handleEconomyHealth(CommandSender sender) {
        if (!sender.hasPermission("ecoxpert.admin") && !sender.hasPermission("ecoxpert.admin.economy")) {
            this.sendMessage(sender, "error.no_permission", new Object[0]);
            return true;
        }
        EcoXpertPlugin plugin = (EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class);
        ServiceRegistry services = plugin.getServiceRegistry();
        ConfigManager cfg = services.getInstance(ConfigManager.class);
        DataManager dm = services.getInstance(DataManager.class);
        EconomyManager econ = services.getInstance(EconomyManager.class);
        FileConfiguration inflCfg = cfg.getModuleConfig("inflation");
        double targetInflation = inflCfg.getDouble("targets.inflation", 1.02);
        int windowHours = inflCfg.getInt("metrics.cpi_window_hours", 72);
        FileConfiguration marketCfg = cfg.getModuleConfig("market");
        List<String> basket = marketCfg.getStringList("metrics.basket");
        if (basket == null || basket.isEmpty()) {
            basket = List.of("WHEAT", "BREAD", "APPLE", "COAL", "IRON_INGOT", "GOLD_INGOT");
        }
        try {
            BigDecimal cpiSum = BigDecimal.ZERO;
            int cpiCount = 0;
            BigDecimal windowInflationSum = BigDecimal.ZERO;
            int inflCount = 0;
            for (String mat : basket) {
                try (QueryResult qr2 = dm.executeQuery("SELECT base_price, current_buy_price FROM ecoxpert_market_items WHERE material = ?", mat).join();){
                    if (qr2.next()) {
                        BigDecimal base = qr2.getBigDecimal("base_price");
                        BigDecimal cur = qr2.getBigDecimal("current_buy_price");
                        if (base != null && cur != null && base.compareTo(BigDecimal.ZERO) > 0) {
                            cpiSum = cpiSum.add(cur.divide(base, 6, RoundingMode.HALF_UP));
                            ++cpiCount;
                        }
                    }
                }
                catch (Exception qr2) {
                    // empty catch block
                }
                try {
                    QueryResult qwin = dm.executeQuery("SELECT buy_price, snapshot_time FROM ecoxpert_market_price_history WHERE material = ? AND snapshot_time >= datetime('now', '-' || ? || ' hours') ORDER BY snapshot_time ASC", mat, windowHours).join();
                    try {
                        BigDecimal first = null;
                        BigDecimal last = null;
                        while (qwin.next()) {
                            if (first == null) {
                                first = qwin.getBigDecimal("buy_price");
                            }
                            last = qwin.getBigDecimal("buy_price");
                        }
                        if (first == null || last == null || first.compareTo(BigDecimal.ZERO) <= 0) continue;
                        windowInflationSum = windowInflationSum.add(last.divide(first, 6, RoundingMode.HALF_UP));
                        ++inflCount;
                    }
                    finally {
                        if (qwin == null) continue;
                        qwin.close();
                    }
                }
                catch (Exception qwin) {}
            }
            double cpi = cpiCount > 0 ? cpiSum.divide(BigDecimal.valueOf(cpiCount), 4, RoundingMode.HALF_UP).doubleValue() : 1.0;
            double windowInflation = inflCount > 0 ? windowInflationSum.divide(BigDecimal.valueOf(inflCount), 6, RoundingMode.HALF_UP).doubleValue() : 1.0;
            double annualized = windowHours > 0 ? Math.pow(windowInflation, 8760.0 / (double)windowHours) - 1.0 : 0.0;
            double deviation = Math.abs(cpi - targetInflation);
            double tolerance = 0.05;
            int healthScore = (int)Math.max(0.0, 100.0 - Math.min(100.0, deviation / tolerance * 100.0));
            this.sendMessage(sender, "economy.admin.health.header", new Object[0]);
            sender.sendMessage(String.format("\u00a77CPI Index: \u00a7e%.3f", cpi));
            sender.sendMessage(String.format("\u00a77Annualized Inflation: \u00a7e%.2f%%", annualized * 100.0));
            sender.sendMessage(String.format("\u00a77Target Inflation: \u00a7e%.3f", targetInflation));
            sender.sendMessage(String.format("\u00a77Health Score: \u00a7e%d/100", healthScore));
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to compute economy health");
        }
        return true;
    }

    private boolean handleEconomyPolicy(CommandSender sender, String[] args) {
        if (!sender.hasPermission("ecoxpert.admin") && !sender.hasPermission("ecoxpert.admin.economy")) {
            this.sendMessage(sender, "error.no_permission", new Object[0]);
            return true;
        }
        InflationManager infl = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(InflationManager.class);
        if (infl == null) {
            sender.sendMessage("Policy not available");
            return true;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("show")) {
            this.sendMessage(sender, "economy.admin.policy.header", new Object[0]);
            sender.sendMessage(infl.getPolicyInfo());
            double[] f = infl.getMarketFactors();
            sender.sendMessage(String.format("\u00a77Global factors: buy=%.3f, sell=%.3f", f[0], f[1]));
            return true;
        }
        if (args[0].equalsIgnoreCase("set") && args.length >= 3) {
            String name = args[1];
            try {
                double value = Double.parseDouble(args[2]);
                boolean ok = infl.setPolicyParam(name, value);
                if (ok) {
                    this.sendMessage(sender, "economy.admin.policy.updated", name, value);
                } else {
                    this.sendMessage(sender, "economy.admin.policy.unknown_param", name);
                }
            }
            catch (NumberFormatException e) {
                this.sendMessage(sender, "economy.admin.policy.invalid_value", args[2]);
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            infl.reloadPolicy();
            this.sendMessage(sender, "economy.admin.policy.reloaded", new Object[0]);
            return true;
        }
        this.sendMessage(sender, "economy.admin.policy.usage", new Object[0]);
        return true;
    }

    private boolean handleEconomyStatus(CommandSender sender) {
        EconomyConflictDetector detector = new EconomyConflictDetector((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class));
        EconomyConflictDetector.EconomyProviderStatus status = detector.detectEconomyProvider();
        EconomyConflictDetector.InstalledEconomyPlugins plugins = detector.detectInstalledEconomyPlugins();
        DataManager dm = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(DataManager.class);
        DatabaseStatus dbStatus = dm.getStatus();
        this.sendMessage(sender, "economy.admin.status.header", new Object[0]);
        this.sendMessage(sender, "economy.admin.status.provider", status.getStatus().name(), String.valueOf(status.getPluginName()));
        this.sendMessage(sender, "economy.admin.status.plugins", plugins.getInstalledCount());
        this.sendMessage(sender, "economy.admin.status.db", dbStatus.getCurrentType(), dbStatus.isConnected(), dbStatus.isHealthy());
        try (QueryResult qr2 = dm.executeQuery("SELECT COUNT(*) as cnt, COALESCE(SUM(balance),0) as total, COALESCE(AVG(balance),0) as avg FROM ecoxpert_accounts", new Object[0]).join();){
            if (qr2.next()) {
                long cnt = qr2.getLong("cnt");
                BigDecimal total = qr2.getBigDecimal("total");
                BigDecimal avg = qr2.getBigDecimal("avg");
                sender.sendMessage(String.format("\u00a77Accounts: \u00a7e%d \u00a77| Total: \u00a7e%s \u00a77| Avg: \u00a7e%s", cnt, ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(EconomyManager.class).formatMoney(total), ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(EconomyManager.class).formatMoney(avg)));
            }
        }
        catch (Exception qr2) {
            // empty catch block
        }
        InflationManager infl = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(InflationManager.class);
        if (infl != null) {
            double[] f = infl.getMarketFactors();
            sender.sendMessage(String.format("\u00a77Market factors: buy=%.3f, sell=%.3f", f[0], f[1]));
        }
        return true;
    }

    private boolean handleEconomyDiagnostics(CommandSender sender) {
        EcoXpertPlugin plugin = (EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class);
        EconomySystemTestRunner runner = new EconomySystemTestRunner(plugin);
        EconomySystemTestRunner.TestResults results = runner.runSafeTests();
        sender.sendMessage(results.toString());
        return true;
    }

    private boolean handleMigrate(CommandSender sender, String[] args) {
        String providerPlugin;
        if (!sender.hasPermission("ecoxpert.admin.database") && !sender.hasPermission("ecoxpert.admin.economy")) {
            this.sendMessage(sender, "error.no_permission", new Object[0]);
            return true;
        }
        if (args.length > 0 && !args[0].equalsIgnoreCase("balances")) {
            this.sendMessage(sender, "commands.migrate.usage", new Object[0]);
            return true;
        }
        RegisteredServiceProvider registration = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (registration == null || registration.getProvider() == null) {
            this.sendMessage(sender, "admin.migrate.none", new Object[0]);
            return true;
        }
        String string = providerPlugin = registration.getPlugin() != null ? registration.getPlugin().getName() : "Unknown";
        if (providerPlugin.toLowerCase().contains("ecoxpert")) {
            this.sendMessage(sender, "admin.migrate.none", new Object[0]);
            return true;
        }
        this.sendMessage(sender, "admin.migrate.started", providerPlugin);
        EcoXpertPlugin plugin = (EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class);
        EconomySyncManager sync = new EconomySyncManager(plugin, this.economyManager, (Economy)registration.getProvider());
        ((CompletableFuture)sync.importBalancesFromFallback().thenAccept(imported -> this.sendMessage(sender, "admin.migrate.completed", imported))).exceptionally(ex -> {
            this.sendMessage(sender, "admin.migrate.error", ex.getMessage());
            return null;
        });
        return true;
    }

    private boolean handleBalance(CommandSender sender, String[] args) {
        Player target;
        if (!this.hasPermission(sender, "ecoxpert.economy.balance")) {
            return true;
        }
        if (args.length == 0) {
            Player player = this.requirePlayer(sender);
            if (player == null) {
                return true;
            }
            target = player;
        } else {
            if (!this.hasPermission(sender, "ecoxpert.admin.economy")) {
                return true;
            }
            target = this.findPlayer(sender, args[0]);
            if (target == null) {
                return true;
            }
        }
        this.ensureAccount(target.getUniqueId());
        ((CompletableFuture)this.economyManager.getBalance(target.getUniqueId()).thenAccept(arg_0 -> this.lambda$handleBalance$2((OfflinePlayer)target, sender, arg_0))).exceptionally(throwable -> {
            this.sendMessage(sender, "error.database_error", new Object[0]);
            return null;
        });
        return true;
    }

    private boolean handlePay(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "ecoxpert.economy.pay")) {
            return true;
        }
        Player player = this.requirePlayer(sender);
        if (player == null) {
            return true;
        }
        if (args.length < 2) {
            this.sendMessage(sender, "commands.pay.usage", new Object[0]);
            return true;
        }
        OfflinePlayer target = this.findPlayer(sender, args[0]);
        if (target == null) {
            return true;
        }
        if (target.getUniqueId().equals(player.getUniqueId())) {
            this.sendMessage(sender, "error.cannot_pay_self", new Object[0]);
            return true;
        }
        BigDecimal amount = this.parseAmount(sender, args[1]);
        if (amount == null) {
            return true;
        }
        this.ensureAccount(player.getUniqueId());
        this.ensureAccount(target.getUniqueId());
        ((CompletableFuture)this.economyManager.transferMoney(player.getUniqueId(), target.getUniqueId(), amount, "Player payment from " + player.getName()).thenAccept(success -> {
            String formattedAmount = this.economyManager.formatMoney(amount);
            if (success.booleanValue()) {
                this.sendMessage(sender, "commands.pay.success", formattedAmount, target.getName());
                if (target.isOnline()) {
                    Player targetPlayer = target.getPlayer();
                    this.sendMessage((CommandSender)targetPlayer, "commands.pay.received", formattedAmount, player.getName());
                }
            } else {
                this.sendMessage(sender, "error.insufficient_funds", new Object[0]);
            }
        })).exceptionally(throwable -> {
            this.sendMessage(sender, "error.database_error", new Object[0]);
            return null;
        });
        return true;
    }

    private boolean handleSet(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "ecoxpert.admin.economy")) {
            return true;
        }
        if (args.length < 2) {
            this.sendMessage(sender, "commands.set.usage", new Object[0]);
            return true;
        }
        OfflinePlayer target = this.findPlayer(sender, args[0]);
        if (target == null) {
            return true;
        }
        BigDecimal amount = this.parseAmount(sender, args[1]);
        if (amount == null) {
            return true;
        }
        this.ensureAccount(target.getUniqueId());
        ((CompletableFuture)this.economyManager.setBalance(target.getUniqueId(), amount, "Admin set by " + sender.getName()).thenRun(() -> {
            String formattedAmount = this.economyManager.formatMoney(amount);
            this.sendMessage(sender, "commands.set.success", target.getName(), formattedAmount);
        })).exceptionally(throwable -> {
            this.sendMessage(sender, "error.database_error", new Object[0]);
            return null;
        });
        return true;
    }

    private boolean handleAdd(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "ecoxpert.admin.economy")) {
            return true;
        }
        if (args.length < 2) {
            this.sendMessage(sender, "commands.add.usage", new Object[0]);
            return true;
        }
        OfflinePlayer target = this.findPlayer(sender, args[0]);
        if (target == null) {
            return true;
        }
        BigDecimal amount = this.parseAmount(sender, args[1]);
        if (amount == null) {
            return true;
        }
        this.ensureAccount(target.getUniqueId());
        ((CompletableFuture)this.economyManager.addMoney(target.getUniqueId(), amount, "Admin add by " + sender.getName()).thenRun(() -> {
            String formattedAmount = this.economyManager.formatMoney(amount);
            this.sendMessage(sender, "commands.add.success", formattedAmount, target.getName());
        })).exceptionally(throwable -> {
            this.sendMessage(sender, "error.database_error", new Object[0]);
            return null;
        });
        return true;
    }

    private boolean handleRemove(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "ecoxpert.admin.economy")) {
            return true;
        }
        if (args.length < 2) {
            this.sendMessage(sender, "commands.remove.usage", new Object[0]);
            return true;
        }
        OfflinePlayer target = this.findPlayer(sender, args[0]);
        if (target == null) {
            return true;
        }
        BigDecimal amount = this.parseAmount(sender, args[1]);
        if (amount == null) {
            return true;
        }
        this.ensureAccount(target.getUniqueId());
        ((CompletableFuture)this.economyManager.removeMoney(target.getUniqueId(), amount, "Admin remove by " + sender.getName()).thenAccept(success -> {
            String formattedAmount = this.economyManager.formatMoney(amount);
            if (success.booleanValue()) {
                this.sendMessage(sender, "commands.remove.success", formattedAmount, target.getName());
            } else {
                this.sendMessage(sender, "error.insufficient_funds", new Object[0]);
            }
        })).exceptionally(throwable -> {
            this.sendMessage(sender, "error.database_error", new Object[0]);
            return null;
        });
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        this.sendMessage(sender, "commands.help.header", new Object[0]);
        this.sendMessage(sender, "commands.help.balance", new Object[0]);
        this.sendMessage(sender, "commands.help.pay", new Object[0]);
        if (sender.hasPermission("ecoxpert.admin.economy")) {
            this.sendMessage(sender, "commands.help.admin_header", new Object[0]);
            this.sendMessage(sender, "commands.help.set", new Object[0]);
            this.sendMessage(sender, "commands.help.add", new Object[0]);
            this.sendMessage(sender, "commands.help.remove", new Object[0]);
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subcommands = Arrays.asList("balance", "pay", "help");
            if (sender.hasPermission("ecoxpert.admin.economy")) {
                subcommands = Arrays.asList("balance", "pay", "set", "add", "remove", "help");
            }
            return subcommands.stream().filter(sub -> sub.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && !args[0].equalsIgnoreCase("help")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return completions;
    }

    private /* synthetic */ void lambda$handleBalance$2(OfflinePlayer target, CommandSender sender, BigDecimal balance) {
        String formattedBalance = this.economyManager.formatMoney(balance);
        if (target.equals(sender)) {
            this.sendMessage(sender, "commands.balance.own", formattedBalance);
        } else {
            this.sendMessage(sender, "commands.balance.other", target.getName(), formattedBalance);
        }
    }
}

