/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.commands;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.commands.BaseCommand;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.loans.Loan;
import me.koyere.ecoxpert.modules.loans.LoanManager;
import me.koyere.ecoxpert.modules.loans.LoanPayment;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LoansCommand
extends BaseCommand {
    private final LoanManager loanManager;

    public LoansCommand(LoanManager loanManager, EconomyManager economyManager, TranslationManager translationManager) {
        super(economyManager, translationManager);
        this.loanManager = loanManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        Player player = this.requirePlayer(sender);
        if (player == null) {
            return true;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            this.showHelp(player);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "request": {
                return this.handleRequestSmart(player, args);
            }
            case "pay": {
                return this.handlePay(player, args);
            }
            case "status": {
                return this.handleStatus(player);
            }
            case "offer": {
                return this.handleOffer(player, args);
            }
            case "schedule": {
                return this.handleSchedule(player);
            }
            case "policy": {
                return this.handlePolicy(player, args);
            }
        }
        this.showHelp(player);
        return true;
    }

    private boolean handleRequestSmart(Player player, String[] args) {
        if (!player.hasPermission("ecoxpert.loans.request")) {
            this.sendMessage((CommandSender)player, "error.no_permission", new Object[0]);
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(this.translationManager.getMessage("loans.usage.request", new Object[0]));
            return true;
        }
        BigDecimal amount = this.parseAmount((CommandSender)player, args[1]);
        if (amount == null) {
            return true;
        }
        ((CompletableFuture)((CompletableFuture)this.loanManager.getOffer(player.getUniqueId(), amount).thenCompose(offer -> {
            if (!offer.approved()) {
                player.sendMessage(this.translationManager.getMessage("loans.loan-denied", offer.reason(), new Object[0]));
                return CompletableFuture.completedFuture(false);
            }
            String fmtAmount = this.economyManager.formatMoney(amount);
            String fmtRate = String.valueOf(offer.interestRate().multiply(new BigDecimal("100")).setScale(2)) + "%";
            player.sendMessage(this.translationManager.getMessage("loans.offer.summary", fmtAmount, fmtRate, offer.termDays(), offer.score()));
            return this.loanManager.requestLoanSmart(player.getUniqueId(), amount);
        })).thenAccept(success -> {
            if (success.booleanValue()) {
                player.sendMessage(this.translationManager.getMessage("loans.loan-approved", this.economyManager.formatMoney(amount), new Object[0]));
            } else {
                player.sendMessage(this.translationManager.getMessage("loans.loan-denied", "Active loan exists or invalid amount", new Object[0]));
            }
        })).exceptionally(ex -> {
            player.sendMessage(this.translationManager.getMessage("errors.database-error", new Object[0]));
            return null;
        });
        return true;
    }

    private boolean handlePay(Player player, String[] args) {
        if (!player.hasPermission("ecoxpert.loans.pay")) {
            this.sendMessage((CommandSender)player, "error.no_permission", new Object[0]);
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(this.translationManager.getMessage("loans.usage.pay", new Object[0]));
            return true;
        }
        BigDecimal amount = this.parseAmount((CommandSender)player, args[1]);
        if (amount == null) {
            return true;
        }
        ((CompletableFuture)this.loanManager.payLoan(player.getUniqueId(), amount).thenAccept(success -> {
            if (success.booleanValue()) {
                player.sendMessage(this.translationManager.getMessage("loans.payment-made", this.economyManager.formatMoney(amount), new Object[0]));
            } else {
                player.sendMessage(this.translationManager.getMessage("loans.loan-denied", "Insufficient funds or no active loan", new Object[0]));
            }
        })).exceptionally(ex -> {
            player.sendMessage(this.translationManager.getMessage("errors.database-error", new Object[0]));
            return null;
        });
        return true;
    }

    private boolean handleStatus(Player player) {
        ((CompletableFuture)this.loanManager.getActiveLoan(player.getUniqueId()).thenAccept(opt -> {
            if (opt.isEmpty()) {
                player.sendMessage(this.translationManager.getMessage("loans.no-active-loans", new Object[0]));
                return;
            }
            Loan loan = (Loan)opt.get();
            player.sendMessage(this.translationManager.getMessage("loans.status", this.economyManager.formatMoney(loan.getOutstanding()), this.economyManager.formatMoney(loan.getPrincipal()), String.valueOf(loan.getInterestRate().multiply(new BigDecimal("100")).setScale(1)) + "%"));
        })).exceptionally(ex -> {
            player.sendMessage(this.translationManager.getMessage("errors.database-error", new Object[0]));
            return null;
        });
        return true;
    }

    private boolean handleOffer(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.translationManager.getMessage("loans.usage.request", new Object[0]));
            return true;
        }
        BigDecimal amount = this.parseAmount((CommandSender)player, args[1]);
        if (amount == null) {
            return true;
        }
        ((CompletableFuture)this.loanManager.getOffer(player.getUniqueId(), amount).thenAccept(offer -> {
            if (!offer.approved()) {
                player.sendMessage(this.translationManager.getMessage("loans.loan-denied", offer.reason(), new Object[0]));
                return;
            }
            String fmtAmount = this.economyManager.formatMoney(offer.amount());
            String fmtRate = String.valueOf(offer.interestRate().multiply(new BigDecimal("100")).setScale(2)) + "%";
            player.sendMessage(this.translationManager.getMessage("loans.offer.header", new Object[0]));
            player.sendMessage(this.translationManager.getMessage("loans.offer.details", fmtAmount, fmtRate, offer.termDays(), offer.score()));
        })).exceptionally(ex -> {
            player.sendMessage(this.translationManager.getMessage("errors.database-error", new Object[0]));
            return null;
        });
        return true;
    }

    private boolean handleSchedule(Player player) {
        ((CompletableFuture)this.loanManager.getSchedule(player.getUniqueId()).thenAccept(list -> {
            if (list.isEmpty()) {
                player.sendMessage(this.translationManager.getMessage("loans.no-active-loans", new Object[0]));
                return;
            }
            player.sendMessage(this.translationManager.getMessage("loans.schedule.header", new Object[0]));
            int shown = 0;
            for (LoanPayment p : list) {
                if (shown++ > 15) {
                    player.sendMessage("\u00a77...");
                    break;
                }
                player.sendMessage(this.translationManager.getMessage("loans.schedule.item", p.installmentNo(), p.dueDate(), this.economyManager.formatMoney(p.amountDue()), p.status()));
            }
        })).exceptionally(ex -> {
            player.sendMessage(this.translationManager.getMessage("errors.database-error", new Object[0]));
            return null;
        });
        return true;
    }

    private boolean handlePolicy(Player player, String[] args) {
        if (!player.hasPermission("ecoxpert.admin.loans")) {
            this.sendMessage((CommandSender)player, "error.no_permission", new Object[0]);
            return true;
        }
        player.sendMessage("\u00a77Policy is loaded from modules/loans.yml. Use config reload to apply changes.");
        return true;
    }

    private void showHelp(Player player) {
        player.sendMessage(this.translationManager.getMessage("loans.help.header", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("loans.help.request", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("loans.help.pay", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("loans.help.status", new Object[0]));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> out;
        block3: {
            block2: {
                out = new ArrayList<String>();
                if (args.length != 1) break block2;
                for (String s : new String[]{"request", "offer", "pay", "status", "schedule", "policy"}) {
                    if (!s.startsWith(args[0].toLowerCase())) continue;
                    out.add(s);
                }
                break block3;
            }
            if (args.length != 2 || !"request".equalsIgnoreCase(args[0]) && !"pay".equalsIgnoreCase(args[0]) && !"offer".equalsIgnoreCase(args[0])) break block3;
            for (String s : new String[]{"100", "500", "1000", "5000"}) {
                if (!s.startsWith(args[1])) continue;
                out.add(s);
            }
        }
        return out;
    }
}

