/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.data;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.koyere.ecoxpert.core.data.DatabaseTransaction;
import me.koyere.ecoxpert.core.data.QueryResult;
import me.koyere.ecoxpert.core.data.QueryResultImpl;

public class DatabaseTransactionImpl
implements DatabaseTransaction {
    private final Connection connection;
    private final Executor executor;
    private final Logger logger = Logger.getLogger("EcoXpert");
    private boolean active = true;
    private boolean committed = false;

    public DatabaseTransactionImpl(Connection connection, Executor executor) throws SQLException {
        this.connection = connection;
        this.executor = executor;
        connection.setAutoCommit(false);
    }

    @Override
    public CompletableFuture<Integer> executeUpdate(String sql, Object ... params) {
        return CompletableFuture.supplyAsync(() -> {
            Integer n;
            block10: {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("ECOXPERT DEBUG - DatabaseTransaction.executeUpdate: " + sql);
                }
                this.checkActive();
                PreparedStatement stmt = this.connection.prepareStatement(sql);
                try {
                    this.setParameters(stmt, params);
                    int result = stmt.executeUpdate();
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("ECOXPERT DEBUG - executeUpdate result: " + result + " rows affected");
                    }
                    n = result;
                    if (stmt == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.logger.log(Level.SEVERE, "ECOXPERT ERROR - executeUpdate failed for SQL: " + sql, e);
                        throw new RuntimeException("Failed to execute update: " + sql, e);
                    }
                }
                stmt.close();
            }
            return n;
        }, this.executor);
    }

    @Override
    public CompletableFuture<QueryResult> executeQuery(String sql, Object ... params) {
        return CompletableFuture.supplyAsync(() -> {
            QueryResultImpl queryResultImpl;
            block10: {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("ECOXPERT DEBUG - DatabaseTransaction.executeQuery: " + sql);
                }
                this.checkActive();
                PreparedStatement stmt = this.connection.prepareStatement(sql);
                try {
                    this.setParameters(stmt, params);
                    QueryResultImpl result = new QueryResultImpl(stmt.executeQuery());
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("ECOXPERT DEBUG - executeQuery completed successfully");
                    }
                    queryResultImpl = result;
                    if (stmt == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.logger.log(Level.SEVERE, "ECOXPERT ERROR - executeQuery failed for SQL: " + sql, e);
                        throw new RuntimeException("Failed to execute query: " + sql, e);
                    }
                }
                stmt.close();
            }
            return queryResultImpl;
        }, this.executor);
    }

    @Override
    public CompletableFuture<Void> commit() {
        return CompletableFuture.runAsync(() -> {
            this.checkActive();
            try {
                this.connection.commit();
                this.committed = true;
                this.active = false;
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to commit transaction", e);
            }
        }, this.executor);
    }

    @Override
    public CompletableFuture<Void> rollback() {
        return CompletableFuture.runAsync(() -> {
            if (this.active) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed to rollback transaction", e);
                }
                finally {
                    this.active = false;
                }
            }
        }, this.executor);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void close() {
        if (this.active && !this.committed) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                System.err.println("Warning: Failed to rollback transaction during close: " + e.getMessage());
            }
        }
        try {
            this.connection.setAutoCommit(true);
            this.connection.close();
        }
        catch (SQLException e) {
            System.err.println("Warning: Failed to close connection: " + e.getMessage());
        }
        finally {
            this.active = false;
        }
    }

    private void setParameters(PreparedStatement stmt, Object ... params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            stmt.setObject(i + 1, params[i]);
        }
    }

    private void checkActive() {
        if (!this.active) {
            throw new IllegalStateException("Transaction is no longer active");
        }
    }
}

