/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.economy;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.koyere.ecoxpert.EcoXpertPlugin;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyConflictDetector {
    private final EcoXpertPlugin plugin;

    public EconomyConflictDetector(EcoXpertPlugin plugin) {
        this.plugin = plugin;
    }

    public EconomyProviderStatus detectEconomyProvider() {
        try {
            RegisteredServiceProvider registration = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (registration == null) {
                return new EconomyProviderStatus(EconomyProviderStatus.Status.NO_PROVIDER, null, null, "No economy provider found");
            }
            Economy provider = (Economy)registration.getProvider();
            String providerName = provider.getClass().getSimpleName();
            String pluginName = registration.getPlugin().getName();
            boolean isEcoXpert = provider.getClass().getName().contains("ecoxpert");
            if (isEcoXpert) {
                return new EconomyProviderStatus(EconomyProviderStatus.Status.ECOXPERT_ACTIVE, providerName, pluginName, "EcoXpert is the active economy provider");
            }
            return new EconomyProviderStatus(EconomyProviderStatus.Status.OTHER_PROVIDER_ACTIVE, providerName, pluginName, "Another economy provider is active: " + pluginName);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error detecting economy provider: " + e.getMessage());
            return new EconomyProviderStatus(EconomyProviderStatus.Status.DETECTION_ERROR, null, null, "Error during detection: " + e.getMessage());
        }
    }

    public InstalledEconomyPlugins detectInstalledEconomyPlugins() {
        InstalledEconomyPlugins.Builder builder = new InstalledEconomyPlugins.Builder();
        if (this.plugin.getServer().getPluginManager().getPlugin("Essentials") != null) {
            builder.addPlugin("Essentials", true);
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("EssentialsX") != null) {
            builder.addPlugin("EssentialsX", true);
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("CMI") != null) {
            builder.addPlugin("CMI", true);
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("GriefPrevention") != null) {
            builder.addPlugin("GriefPrevention", true);
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("Towny") != null) {
            builder.addPlugin("Towny", true);
        }
        return builder.build();
    }

    public boolean canSafelyRegister() {
        try {
            if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
                return false;
            }
            return this.plugin.getServer().getServicesManager() != null;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Cannot safely register economy provider: " + e.getMessage());
            return false;
        }
    }

    public static class EconomyProviderStatus {
        private final Status status;
        private final String providerClassName;
        private final String pluginName;
        private final String message;

        public EconomyProviderStatus(Status status, String providerClassName, String pluginName, String message) {
            this.status = status;
            this.providerClassName = providerClassName;
            this.pluginName = pluginName;
            this.message = message;
        }

        public Status getStatus() {
            return this.status;
        }

        public String getProviderClassName() {
            return this.providerClassName;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isEcoXpertActive() {
            return this.status == Status.ECOXPERT_ACTIVE;
        }

        public boolean hasConflict() {
            return this.status == Status.OTHER_PROVIDER_ACTIVE;
        }

        public static enum Status {
            NO_PROVIDER,
            ECOXPERT_ACTIVE,
            OTHER_PROVIDER_ACTIVE,
            DETECTION_ERROR;

        }
    }

    public static class InstalledEconomyPlugins {
        private final Map<String, Boolean> plugins;

        private InstalledEconomyPlugins(Map<String, Boolean> plugins) {
            this.plugins = new HashMap<String, Boolean>(plugins);
        }

        public boolean hasPlugin(String pluginName) {
            return this.plugins.getOrDefault(pluginName, false);
        }

        public Set<String> getInstalledPlugins() {
            return this.plugins.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        }

        public int getInstalledCount() {
            return (int)this.plugins.values().stream().filter(Boolean::booleanValue).count();
        }

        public boolean hasEssentials() {
            return this.hasPlugin("Essentials") || this.hasPlugin("EssentialsX");
        }

        public boolean hasCMI() {
            return this.hasPlugin("CMI");
        }

        public static class Builder {
            private final Map<String, Boolean> plugins = new HashMap<String, Boolean>();

            public Builder addPlugin(String name, boolean installed) {
                this.plugins.put(name, installed);
                return this;
            }

            public InstalledEconomyPlugins build() {
                return new InstalledEconomyPlugins(this.plugins);
            }
        }
    }
}

