/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.economy;

import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.economy.EconomyConflictDetector;
import me.koyere.ecoxpert.economy.VaultEconomyProvider;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyModeManager {
    private final EcoXpertPlugin plugin;
    private final EconomyConflictDetector conflictDetector;
    private final VaultEconomyProvider vaultProvider;
    private EconomyMode currentMode;
    private Economy fallbackEconomy;
    private boolean initialized = false;

    public EconomyModeManager(EcoXpertPlugin plugin, VaultEconomyProvider vaultProvider) {
        this.plugin = plugin;
        this.vaultProvider = vaultProvider;
        this.conflictDetector = new EconomyConflictDetector(plugin);
        this.currentMode = EconomyMode.SAFE_MODE;
    }

    public boolean initialize() {
        if (this.initialized) {
            this.plugin.getLogger().warning("EconomyModeManager already initialized");
            return true;
        }
        try {
            this.plugin.getLogger().info("Initializing Economy Mode Manager...");
            EconomyConflictDetector.EconomyProviderStatus status = this.conflictDetector.detectEconomyProvider();
            EconomyConflictDetector.InstalledEconomyPlugins installedPlugins = this.conflictDetector.detectInstalledEconomyPlugins();
            this.logDetectionResults(status, installedPlugins);
            EconomyMode determinedMode = this.determineOperationMode(status, installedPlugins);
            boolean success = this.initializeMode(determinedMode);
            if (success) {
                this.currentMode = determinedMode;
                this.initialized = true;
                this.plugin.getLogger().info("Economy Mode Manager initialized successfully in " + String.valueOf((Object)this.currentMode) + " mode");
                return true;
            }
            this.plugin.getLogger().warning("Failed to initialize economy mode, falling back to SAFE_MODE");
            this.currentMode = EconomyMode.SAFE_MODE;
            this.initialized = true;
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Critical error during economy mode initialization: " + e.getMessage());
            this.currentMode = EconomyMode.SAFE_MODE;
            this.initialized = true;
            return false;
        }
    }

    private EconomyMode determineOperationMode(EconomyConflictDetector.EconomyProviderStatus status, EconomyConflictDetector.InstalledEconomyPlugins installedPlugins) {
        switch (status.getStatus()) {
            case NO_PROVIDER: {
                return EconomyMode.TAKEOVER_MODE;
            }
            case ECOXPERT_ACTIVE: {
                return EconomyMode.TAKEOVER_MODE;
            }
            case OTHER_PROVIDER_ACTIVE: {
                this.plugin.getLogger().info("Detected active economy provider: " + status.getPluginName());
                this.plugin.getLogger().info("Operating in compatibility mode alongside " + status.getPluginName());
                return EconomyMode.COMPATIBILITY_MODE;
            }
        }
        this.plugin.getLogger().warning("Economy provider detection failed, using safe mode");
        return EconomyMode.SAFE_MODE;
    }

    private boolean initializeMode(EconomyMode mode) {
        try {
            switch (mode) {
                case TAKEOVER_MODE: {
                    return this.initializeTakeoverMode();
                }
                case COMPATIBILITY_MODE: {
                    return this.initializeCompatibilityMode();
                }
                case STANDALONE_MODE: {
                    return this.initializeStandaloneMode();
                }
            }
            return this.initializeSafeMode();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error initializing economy mode " + String.valueOf((Object)mode) + ": " + e.getMessage());
            return false;
        }
    }

    private boolean initializeTakeoverMode() {
        if (!this.conflictDetector.canSafelyRegister()) {
            this.plugin.getLogger().warning("Cannot safely register as economy provider, falling back");
            return false;
        }
        try {
            boolean registered = this.vaultProvider.register();
            if (registered) {
                this.plugin.getLogger().info("Successfully registered as primary economy provider");
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::verifyTakeoverSuccess, 20L);
                return true;
            }
            this.plugin.getLogger().warning("Failed to register as economy provider");
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during takeover mode initialization: " + e.getMessage());
            return false;
        }
    }

    private boolean initializeCompatibilityMode() {
        try {
            RegisteredServiceProvider registration = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (registration != null) {
                this.fallbackEconomy = (Economy)registration.getProvider();
                this.plugin.getLogger().info("Operating in compatibility mode with " + registration.getPlugin().getName());
                return true;
            }
            this.plugin.getLogger().warning("No economy provider found for compatibility mode");
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during compatibility mode initialization: " + e.getMessage());
            return false;
        }
    }

    private boolean initializeStandaloneMode() {
        try {
            boolean registered = this.vaultProvider.register();
            this.plugin.getLogger().info("Initialized in standalone mode, registered: " + registered);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during standalone mode initialization: " + e.getMessage());
            return false;
        }
    }

    private boolean initializeSafeMode() {
        this.plugin.getLogger().info("Operating in safe mode - providing minimal economy features");
        return true;
    }

    private void verifyTakeoverSuccess() {
        EconomyConflictDetector.EconomyProviderStatus status = this.conflictDetector.detectEconomyProvider();
        if (!status.isEcoXpertActive()) {
            this.plugin.getLogger().warning("\u26a0\ufe0f  TAKEOVER VERIFICATION FAILED!");
            this.plugin.getLogger().warning("Expected EcoXpert as provider, but found: " + status.getPluginName());
            this.plugin.getLogger().warning("Switching to compatibility mode...");
            this.currentMode = EconomyMode.COMPATIBILITY_MODE;
            this.initializeCompatibilityMode();
        } else {
            this.plugin.getLogger().info("\u2713 Takeover successful - EcoXpert is active economy provider");
        }
    }

    private void logDetectionResults(EconomyConflictDetector.EconomyProviderStatus status, EconomyConflictDetector.InstalledEconomyPlugins installedPlugins) {
        this.plugin.getLogger().info("=== Economy Detection Results ===");
        this.plugin.getLogger().info("Provider Status: " + String.valueOf((Object)status.getStatus()));
        this.plugin.getLogger().info("Active Provider: " + status.getPluginName());
        this.plugin.getLogger().info("Provider Class: " + status.getProviderClassName());
        this.plugin.getLogger().info("Message: " + status.getMessage());
        this.plugin.getLogger().info("Installed Economy Plugins:");
        for (String pluginName : installedPlugins.getInstalledPlugins()) {
            this.plugin.getLogger().info("  - " + pluginName);
        }
        if (installedPlugins.getInstalledCount() == 0) {
            this.plugin.getLogger().info("  - None detected");
        }
        this.plugin.getLogger().info("=== End Detection Results ===");
    }

    public EconomyMode getCurrentMode() {
        return this.currentMode;
    }

    public Economy getFallbackEconomy() {
        return this.fallbackEconomy;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isTakeoverMode() {
        return this.currentMode == EconomyMode.TAKEOVER_MODE;
    }

    public boolean isCompatibilityMode() {
        return this.currentMode == EconomyMode.COMPATIBILITY_MODE;
    }

    public boolean canUseAdvancedFeatures() {
        return this.currentMode != EconomyMode.SAFE_MODE;
    }

    public static enum EconomyMode {
        TAKEOVER_MODE,
        COMPATIBILITY_MODE,
        STANDALONE_MODE,
        SAFE_MODE;

    }
}

