/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.education;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.modules.events.EconomicEvent;
import me.koyere.ecoxpert.modules.inflation.EconomicIntelligenceEngine;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class EducationNotifier {
    private static volatile long lastCycleBroadcastAt = 0L;
    private static volatile long lastEventBroadcastAt = 0L;
    private static final ConcurrentMap<UUID, Long> lastPolicyNotifyAt = new ConcurrentHashMap<UUID, Long>();

    private EducationNotifier() {
    }

    public static void broadcastCycle(EcoXpertPlugin plugin, TranslationManager tm, EconomicIntelligenceEngine.EconomicCycle cycle) {
        try {
            ConfigManager cfg = plugin.getServiceRegistry().getInstance(ConfigManager.class);
            if (!cfg.getConfig().getBoolean("education.enabled", true)) {
                return;
            }
            if (!cfg.getConfig().getBoolean("education.broadcasts.cycle", true)) {
                return;
            }
            int cdMin = Math.max(0, cfg.getConfig().getInt("education.cooldowns.cycle_minutes", 30));
            long now = System.currentTimeMillis();
            if (cdMin > 0 && now - lastCycleBroadcastAt < (long)cdMin * 60000L) {
                return;
            }
            String key = "education.cycle." + cycle.name();
            Bukkit.broadcastMessage((String)(tm.getMessage("prefix", new Object[0]) + tm.getMessage(key, new Object[0])));
            lastCycleBroadcastAt = now;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void broadcastEvent(EcoXpertPlugin plugin, TranslationManager tm, EconomicEvent event) {
        try {
            String msg;
            ConfigManager cfg = plugin.getServiceRegistry().getInstance(ConfigManager.class);
            if (!cfg.getConfig().getBoolean("education.enabled", true)) {
                return;
            }
            if (!cfg.getConfig().getBoolean("education.broadcasts.events", true)) {
                return;
            }
            int cdMin = Math.max(0, cfg.getConfig().getInt("education.cooldowns.events_minutes", 10));
            long now = System.currentTimeMillis();
            if (cdMin > 0 && now - lastEventBroadcastAt < (long)cdMin * 60000L) {
                return;
            }
            String baseKey = "education.events." + event.getType().name();
            Map<String, Object> p = event.getParameters();
            Double bd = EducationNotifier.getDouble(p.get("metrics.buy_delta"));
            Double sd = EducationNotifier.getDouble(p.get("metrics.sell_delta"));
            String cat = EducationNotifier.getString(p.get("metrics.category"));
            try {
                msg = bd != null && sd != null && cat != null ? tm.getMessage(baseKey, EducationNotifier.percent(bd), EducationNotifier.percent(sd), cat) : (bd != null && sd != null ? tm.getMessage(baseKey, EducationNotifier.percent(bd), EducationNotifier.percent(sd)) : tm.getMessage(baseKey, new Object[0]));
            }
            catch (Exception ex) {
                msg = bd != null && sd != null ? tm.getMessage("education.events.generic", event.getType().name(), EducationNotifier.percent(bd), EducationNotifier.percent(sd)) : tm.getMessage("education.events.generic_simple", event.getType().name(), new Object[0]);
            }
            Bukkit.broadcastMessage((String)(tm.getMessage("prefix", new Object[0]) + msg));
            lastEventBroadcastAt = now;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void notifyWealthTaxApplied(EcoXpertPlugin plugin, TranslationManager tm, UUID playerId, BigDecimal threshold) {
        try {
            ConfigManager cfg = plugin.getServiceRegistry().getInstance(ConfigManager.class);
            if (!cfg.getConfig().getBoolean("education.enabled", true)) {
                return;
            }
            if (!cfg.getConfig().getBoolean("education.broadcasts.policy", true)) {
                return;
            }
            int cdMin = Math.max(0, cfg.getConfig().getInt("education.cooldowns.policy_player_minutes", 60));
            Player p = Bukkit.getPlayer((UUID)playerId);
            if (p == null) {
                return;
            }
            if (cdMin > 0) {
                long now = System.currentTimeMillis();
                Long last = (Long)lastPolicyNotifyAt.get(playerId);
                if (last != null && now - last < (long)cdMin * 60000L) {
                    return;
                }
                lastPolicyNotifyAt.put(playerId, now);
            }
            p.sendMessage(tm.getMessage("prefix", new Object[0]) + tm.getMessage("education.policy.wealth_tax_applied", threshold != null ? threshold.toPlainString() : "", new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String percent(double fraction) {
        return String.format(Locale.US, "%.0f%%", Math.abs(fraction) * 100.0);
    }

    private static Double getDouble(Object o) {
        try {
            return o instanceof Number ? Double.valueOf(((Number)o).doubleValue()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getString(Object o) {
        return o != null ? o.toString() : null;
    }
}

