/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.gui;

import me.koyere.ecoxpert.EcoXpertPlugin;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public abstract class BaseGUI
implements Listener {
    protected final EcoXpertPlugin plugin;
    protected Inventory inventory;

    protected BaseGUI(EcoXpertPlugin plugin) {
        this.plugin = plugin;
    }

    public void open(Player player) {
        if (this.inventory == null) {
            this.inventory = this.create(player);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        player.openInventory(this.inventory);
    }

    protected abstract Inventory create(Player var1);

    protected abstract void onClick(InventoryClickEvent var1);

    @EventHandler
    public void handleClick(InventoryClickEvent e) {
        if (e.getInventory() == null || this.inventory == null) {
            return;
        }
        if (!e.getInventory().equals(this.inventory)) {
            return;
        }
        e.setCancelled(true);
        this.onClick(e);
    }

    @EventHandler
    public void handleClose(InventoryCloseEvent e) {
        if (this.inventory != null && e.getInventory().equals(this.inventory)) {
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
        }
    }
}

