/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.safety;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.safety.SafeModeManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class SafeModeManagerImpl
implements SafeModeManager {
    private final EcoXpertPlugin plugin;
    private final DataManager dataManager;
    private final ConfigManager configManager;
    private boolean active = false;
    private long latencyThresholdMs = 500L;
    private int errorsPerMinuteThreshold = 3;
    private final Deque<Long> latencies = new ArrayDeque<Long>();
    private final Deque<Long> errorTimestamps = new ArrayDeque<Long>();
    private int taskId = -1;

    public SafeModeManagerImpl(EcoXpertPlugin plugin, DataManager dataManager, ConfigManager configManager) {
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.configManager = configManager;
    }

    @Override
    public void initialize() {
        try {
            FileConfiguration cfg = this.configManager.getModuleConfig("inflation");
            boolean enabled = cfg.getBoolean("safe_mode.enabled", true);
            this.latencyThresholdMs = cfg.getInt("safe_mode.latency_ms_threshold", 500);
            this.errorsPerMinuteThreshold = cfg.getInt("safe_mode.errors_per_minute_threshold", 3);
            if (!enabled) {
                return;
            }
            this.taskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::sampleLatency, 600L, 600L).getTaskId();
            this.plugin.getLogger().info("Safe Mode monitor initialized");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to initialize Safe Mode: " + e.getMessage());
        }
    }

    @Override
    public void shutdown() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
            this.taskId = -1;
        }
        this.active = false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordCriticalError() {
        long now = System.currentTimeMillis();
        Deque<Long> deque = this.errorTimestamps;
        synchronized (deque) {
            this.errorTimestamps.addLast(now);
            while (!this.errorTimestamps.isEmpty() && now - this.errorTimestamps.peekFirst() > 60000L) {
                this.errorTimestamps.pollFirst();
            }
            if (this.errorTimestamps.size() >= this.errorsPerMinuteThreshold) {
                this.setActive(true, "Critical error rate threshold reached");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sampleLatency() {
        long start = System.currentTimeMillis();
        try {
            this.dataManager.executeQuery("SELECT 1", new Object[0]).join().close();
        }
        catch (Exception e) {
            this.recordCriticalError();
        }
        finally {
            long latency = System.currentTimeMillis() - start;
            Deque<Long> deque = this.latencies;
            synchronized (deque) {
                long median;
                this.latencies.addLast(latency);
                if (this.latencies.size() > 20) {
                    this.latencies.pollFirst();
                }
                if ((median = this.computeMedian(this.latencies)) > this.latencyThresholdMs) {
                    this.setActive(true, "DB latency median " + median + "ms > " + this.latencyThresholdMs + "ms");
                } else if (!this.errorSpike()) {
                    this.setActive(false, "DB latency back to normal");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean errorSpike() {
        long now = System.currentTimeMillis();
        Deque<Long> deque = this.errorTimestamps;
        synchronized (deque) {
            while (!this.errorTimestamps.isEmpty() && now - this.errorTimestamps.peekFirst() > 60000L) {
                this.errorTimestamps.pollFirst();
            }
            return this.errorTimestamps.size() >= this.errorsPerMinuteThreshold;
        }
    }

    private long computeMedian(Deque<Long> values) {
        int n = values.size();
        if (n == 0) {
            return 0L;
        }
        long[] arr = new long[n];
        int i = 0;
        for (Long v : values) {
            arr[i++] = v;
        }
        Arrays.sort(arr);
        return arr[n / 2];
    }

    private void setActive(boolean flag, String reason) {
        if (this.active == flag) {
            return;
        }
        this.active = flag;
        if (flag) {
            this.plugin.getLogger().warning("SAFE MODE ACTIVATED: " + reason);
        } else {
            this.plugin.getLogger().info("Safe Mode deactivated: " + reason);
        }
    }
}

