/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.update;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.core.update.UpdateChecker;
import org.bukkit.plugin.Plugin;

@Singleton
public class UpdateCheckerImpl
implements UpdateChecker {
    private final EcoXpertPlugin plugin;
    private final TranslationManager translationManager;
    private String currentVersion;
    private String latestVersion;
    private boolean updateAvailable = false;

    @Inject
    public UpdateCheckerImpl(EcoXpertPlugin plugin, TranslationManager translationManager) {
        this.plugin = plugin;
        this.translationManager = translationManager;
        this.currentVersion = plugin.getDescription().getVersion();
    }

    @Override
    public void checkForUpdates() {
        if (!this.plugin.getConfig().getBoolean("plugin.updates.check-enabled", true)) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.plugin.getLogger().info("Checking for updates...");
                String endpoint = this.resolveEndpoint();
                if (endpoint == null || endpoint.isBlank()) {
                    this.plugin.getLogger().info("Update check skipped: no endpoint configured");
                    return;
                }
                String latest = this.fetchLatestVersion(endpoint);
                if (latest != null && !latest.isBlank()) {
                    this.latestVersion = latest.trim();
                    this.updateAvailable = this.isNewer(this.latestVersion, this.currentVersion);
                    if (this.updateAvailable) {
                        this.plugin.getLogger().info("Update available: " + this.latestVersion);
                    } else {
                        this.plugin.getLogger().info("You are running the latest version");
                    }
                } else {
                    this.plugin.getLogger().info("Update check returned empty response");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Update check failed: " + e.getMessage());
            }
        });
    }

    @Override
    public String getCurrentVersion() {
        return this.currentVersion;
    }

    @Override
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    @Override
    public String getDownloadUrl() {
        String configured = this.plugin.getConfig().getString("plugin.updates.download-url", "");
        if (configured != null && !configured.isBlank()) {
            return configured;
        }
        return this.plugin.getDescription().getWebsite();
    }

    @Override
    public void notifyAdmins() {
        if (this.isUpdateAvailable()) {
            this.plugin.getServer().getOnlinePlayers().stream().filter(p -> p.hasPermission("ecoxpert.admin")).forEach(p -> p.sendMessage(this.translationManager.getMessage("updates.available", this.latestVersion, new Object[0])));
            this.plugin.getLogger().info("Update available: " + this.latestVersion);
        }
    }

    private String resolveEndpoint() {
        int resourceId = this.plugin.getConfig().getInt("plugin.updates.resource-id", 0);
        if (resourceId > 0) {
            return "https://api.spigotmc.org/legacy/update.php?resource=" + resourceId;
        }
        String custom = this.plugin.getConfig().getString("plugin.updates.check-url", "");
        if (custom != null && !custom.isBlank()) {
            return custom;
        }
        return null;
    }

    private String fetchLatestVersion(String endpoint) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)new URL(endpoint).openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("User-Agent", "EcoXpertUpdateChecker/1.0");
        try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
    }

    private boolean isNewer(String latest, String current) {
        try {
            String[] l = latest.split("\\.");
            String[] c = current.split("\\.");
            int n = Math.max(l.length, c.length);
            for (int i = 0; i < n; ++i) {
                int ci;
                int li = i < l.length ? Integer.parseInt(l[i].replaceAll("[^0-9]", "")) : 0;
                int n2 = ci = i < c.length ? Integer.parseInt(c[i].replaceAll("[^0-9]", "")) : 0;
                if (li > ci) {
                    return true;
                }
                if (li >= ci) continue;
                return false;
            }
            return false;
        }
        catch (Exception e) {
            return !latest.equalsIgnoreCase(current);
        }
    }
}

