/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.economy;

import java.math.BigDecimal;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public interface EconomyManager {
    public void initialize();

    public void shutdown();

    public CompletableFuture<Boolean> hasAccount(UUID var1);

    public CompletableFuture<Void> createAccount(UUID var1, BigDecimal var2);

    public CompletableFuture<BigDecimal> getBalance(UUID var1);

    public CompletableFuture<Void> setBalance(UUID var1, BigDecimal var2, String var3);

    public CompletableFuture<Void> addMoney(UUID var1, BigDecimal var2, String var3);

    public CompletableFuture<Boolean> removeMoney(UUID var1, BigDecimal var2, String var3);

    public CompletableFuture<Boolean> transferMoney(UUID var1, UUID var2, BigDecimal var3, String var4);

    public CompletableFuture<Boolean> hasSufficientFunds(UUID var1, BigDecimal var2);

    public BigDecimal getStartingBalance();

    public BigDecimal getMaximumBalance();

    public String formatMoney(BigDecimal var1);

    public String getCurrencyNameSingular();

    public String getCurrencyNamePlural();

    public String getCurrencySymbol();

    public CompletableFuture<Integer> applyWealthTax(BigDecimal var1, BigDecimal var2, String var3);
}

