/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.bank;

import java.math.BigDecimal;
import me.koyere.ecoxpert.modules.bank.BankOperationError;
import me.koyere.ecoxpert.modules.bank.BankTransaction;
import me.koyere.ecoxpert.modules.bank.BankTransactionType;

public class BankOperationResult {
    private final boolean success;
    private final String message;
    private final BankOperationError errorType;
    private final BigDecimal amount;
    private final BigDecimal newBalance;
    private final BankTransaction transaction;
    private final String errorDetails;

    private BankOperationResult(boolean success, String message, BankOperationError errorType, BigDecimal amount, BigDecimal newBalance, BankTransaction transaction, String errorDetails) {
        this.success = success;
        this.message = message;
        this.errorType = errorType;
        this.amount = amount;
        this.newBalance = newBalance;
        this.transaction = transaction;
        this.errorDetails = errorDetails;
    }

    public static BankOperationResult success(String message, BigDecimal amount, BigDecimal newBalance, BankTransaction transaction) {
        return new BankOperationResult(true, message, null, amount, newBalance, transaction, null);
    }

    public static BankOperationResult success(String message, BankTransaction transaction) {
        return new BankOperationResult(true, message, null, transaction.getAmount(), transaction.getBalanceAfter(), transaction, null);
    }

    public static BankOperationResult success(String message) {
        return new BankOperationResult(true, message, null, null, null, null, null);
    }

    public static BankOperationResult failure(String message, BankOperationError errorType) {
        return new BankOperationResult(false, message, errorType, null, null, null, null);
    }

    public static BankOperationResult failure(String message, BankOperationError errorType, String errorDetails) {
        return new BankOperationResult(false, message, errorType, null, null, null, errorDetails);
    }

    public static BankOperationResult failure(String message, BankOperationError errorType, BigDecimal amount) {
        return new BankOperationResult(false, message, errorType, amount, null, null, null);
    }

    public static BankOperationResult insufficientFunds(BigDecimal available, BigDecimal requested) {
        String message = String.format("Insufficient funds: have %s, need %s", available, requested);
        return BankOperationResult.failure(message, BankOperationError.INSUFFICIENT_FUNDS);
    }

    public static BankOperationResult dailyLimitExceeded(BankTransactionType type, BigDecimal limit, BigDecimal requested) {
        String message = String.format("Daily %s limit exceeded: limit %s, requested %s", type.getDisplayName().toLowerCase(), limit, requested);
        return BankOperationResult.failure(message, BankOperationError.DAILY_LIMIT_EXCEEDED);
    }

    public static BankOperationResult accountFrozen(String reason) {
        String message = "Account is frozen" + (String)(reason != null ? ": " + reason : "");
        return BankOperationResult.failure(message, BankOperationError.ACCOUNT_FROZEN, reason);
    }

    public static BankOperationResult accountNotFound() {
        return BankOperationResult.failure("Bank account not found", BankOperationError.ACCOUNT_NOT_FOUND);
    }

    public static BankOperationResult invalidAmount() {
        return BankOperationResult.failure("Invalid amount specified", BankOperationError.INVALID_AMOUNT);
    }

    public static BankOperationResult systemError(String details) {
        return BankOperationResult.failure("Banking system error", BankOperationError.SYSTEM_ERROR, details);
    }

    public static BankOperationResult permissionDenied() {
        return BankOperationResult.failure("Permission denied for this operation", BankOperationError.PERMISSION_DENIED);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailure() {
        return !this.success;
    }

    public String getFormattedMessage() {
        if (this.success) {
            return "\u00a7a" + this.message;
        }
        return "\u00a7c" + this.message;
    }

    public boolean isRecoverableError() {
        if (this.success || this.errorType == null) {
            return false;
        }
        return switch (this.errorType) {
            default -> throw new IncompatibleClassChangeError();
            case BankOperationError.INSUFFICIENT_FUNDS, BankOperationError.DAILY_LIMIT_EXCEEDED, BankOperationError.INVALID_AMOUNT, BankOperationError.TIER_REQUIREMENTS_NOT_MET, BankOperationError.MINIMUM_BALANCE_VIOLATION -> true;
            case BankOperationError.ACCOUNT_FROZEN, BankOperationError.ACCOUNT_NOT_FOUND, BankOperationError.PERMISSION_DENIED, BankOperationError.SYSTEM_ERROR, BankOperationError.DATABASE_ERROR, BankOperationError.SECURITY_VIOLATION, BankOperationError.CONCURRENT_MODIFICATION -> false;
        };
    }

    public String getMessage() {
        return this.message;
    }

    public BankOperationError getErrorType() {
        return this.errorType;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getNewBalance() {
        return this.newBalance;
    }

    public BankTransaction getTransaction() {
        return this.transaction;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        if (this.success) {
            return String.format("BankOperationResult{SUCCESS: %s}", this.message);
        }
        return String.format("BankOperationResult{FAILURE: %s, error=%s}", new Object[]{this.message, this.errorType});
    }
}

