/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.bank;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.List;
import java.util.UUID;
import me.koyere.ecoxpert.modules.bank.BankAccountTier;
import me.koyere.ecoxpert.modules.bank.BankTransaction;

public class BankStatement {
    private final UUID accountId;
    private final int year;
    private final Month month;
    private final String accountNumber;
    private final BankAccountTier accountTier;
    private final BigDecimal openingBalance;
    private final BigDecimal closingBalance;
    private final BigDecimal averageBalance;
    private final BigDecimal minimumBalance;
    private final BigDecimal maximumBalance;
    private final int totalTransactions;
    private final BigDecimal totalDeposits;
    private final BigDecimal totalWithdrawals;
    private final BigDecimal totalTransfersIn;
    private final BigDecimal totalTransfersOut;
    private final BigDecimal totalInterest;
    private final BigDecimal totalFees;
    private final BigDecimal netChange;
    private final int depositCount;
    private final int withdrawalCount;
    private final int transferInCount;
    private final int transferOutCount;
    private final int interestPayments;
    private final int feeCharges;
    private final BigDecimal interestRate;
    private final BigDecimal effectiveYield;
    private final int daysActive;
    private final LocalDateTime generatedAt;
    private final List<BankTransaction> transactions;

    private BankStatement(Builder builder) {
        this.accountId = builder.accountId;
        this.year = builder.year;
        this.month = builder.month;
        this.accountNumber = builder.accountNumber;
        this.accountTier = builder.accountTier;
        this.openingBalance = builder.openingBalance;
        this.closingBalance = builder.closingBalance;
        this.averageBalance = builder.averageBalance;
        this.minimumBalance = builder.minimumBalance;
        this.maximumBalance = builder.maximumBalance;
        this.totalTransactions = builder.totalTransactions;
        this.totalDeposits = builder.totalDeposits;
        this.totalWithdrawals = builder.totalWithdrawals;
        this.totalTransfersIn = builder.totalTransfersIn;
        this.totalTransfersOut = builder.totalTransfersOut;
        this.totalInterest = builder.totalInterest;
        this.totalFees = builder.totalFees;
        this.netChange = this.calculateNetChange();
        this.depositCount = builder.depositCount;
        this.withdrawalCount = builder.withdrawalCount;
        this.transferInCount = builder.transferInCount;
        this.transferOutCount = builder.transferOutCount;
        this.interestPayments = builder.interestPayments;
        this.feeCharges = builder.feeCharges;
        this.interestRate = builder.interestRate;
        this.effectiveYield = this.calculateEffectiveYield();
        this.daysActive = builder.daysActive;
        this.generatedAt = LocalDateTime.now();
        this.transactions = List.copyOf(builder.transactions);
    }

    private BigDecimal calculateNetChange() {
        return this.closingBalance.subtract(this.openingBalance);
    }

    private BigDecimal calculateEffectiveYield() {
        if (this.averageBalance.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal yield = this.totalInterest.divide(this.averageBalance, 6, 4);
        return yield.multiply(new BigDecimal("100"));
    }

    public String getStatementPeriod() {
        return this.month.name() + " " + this.year;
    }

    public boolean isPositivePerformance() {
        return this.netChange.compareTo(BigDecimal.ZERO) > 0;
    }

    public ActivityLevel getActivityLevel() {
        if (this.totalTransactions == 0) {
            return ActivityLevel.INACTIVE;
        }
        if (this.totalTransactions <= 5) {
            return ActivityLevel.LOW;
        }
        if (this.totalTransactions <= 20) {
            return ActivityLevel.MODERATE;
        }
        if (this.totalTransactions <= 50) {
            return ActivityLevel.HIGH;
        }
        return ActivityLevel.VERY_HIGH;
    }

    public BigDecimal getAverageTransactionAmount() {
        if (this.totalTransactions == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalVolume = this.totalDeposits.add(this.totalWithdrawals).add(this.totalTransfersIn).add(this.totalTransfersOut);
        return totalVolume.divide(new BigDecimal(this.totalTransactions), 2, 4);
    }

    public String getSummary() {
        StringBuilder summary = new StringBuilder();
        summary.append("Statement for ").append(this.getStatementPeriod()).append("\n");
        summary.append("Opening Balance: $").append(this.openingBalance).append("\n");
        summary.append("Closing Balance: $").append(this.closingBalance).append("\n");
        summary.append("Net Change: $").append(this.netChange).append("\n");
        summary.append("Interest Earned: $").append(this.totalInterest).append("\n");
        summary.append("Total Transactions: ").append(this.totalTransactions).append("\n");
        summary.append("Activity Level: ").append(this.getActivityLevel().getDisplayName());
        return summary.toString();
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public int getYear() {
        return this.year;
    }

    public Month getMonth() {
        return this.month;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public BankAccountTier getAccountTier() {
        return this.accountTier;
    }

    public BigDecimal getOpeningBalance() {
        return this.openingBalance;
    }

    public BigDecimal getClosingBalance() {
        return this.closingBalance;
    }

    public BigDecimal getAverageBalance() {
        return this.averageBalance;
    }

    public BigDecimal getMinimumBalance() {
        return this.minimumBalance;
    }

    public BigDecimal getMaximumBalance() {
        return this.maximumBalance;
    }

    public int getTotalTransactions() {
        return this.totalTransactions;
    }

    public BigDecimal getTotalDeposits() {
        return this.totalDeposits;
    }

    public BigDecimal getTotalWithdrawals() {
        return this.totalWithdrawals;
    }

    public BigDecimal getTotalTransfersIn() {
        return this.totalTransfersIn;
    }

    public BigDecimal getTotalTransfersOut() {
        return this.totalTransfersOut;
    }

    public BigDecimal getTotalInterest() {
        return this.totalInterest;
    }

    public BigDecimal getTotalFees() {
        return this.totalFees;
    }

    public BigDecimal getNetChange() {
        return this.netChange;
    }

    public int getDepositCount() {
        return this.depositCount;
    }

    public int getWithdrawalCount() {
        return this.withdrawalCount;
    }

    public int getTransferInCount() {
        return this.transferInCount;
    }

    public int getTransferOutCount() {
        return this.transferOutCount;
    }

    public int getInterestPayments() {
        return this.interestPayments;
    }

    public int getFeeCharges() {
        return this.feeCharges;
    }

    public BigDecimal getInterestRate() {
        return this.interestRate;
    }

    public BigDecimal getEffectiveYield() {
        return this.effectiveYield;
    }

    public int getDaysActive() {
        return this.daysActive;
    }

    public LocalDateTime getGeneratedAt() {
        return this.generatedAt;
    }

    public List<BankTransaction> getTransactions() {
        return this.transactions;
    }

    public static class Builder {
        private UUID accountId;
        private int year;
        private Month month;
        private String accountNumber;
        private BankAccountTier accountTier;
        private BigDecimal openingBalance = BigDecimal.ZERO;
        private BigDecimal closingBalance = BigDecimal.ZERO;
        private BigDecimal averageBalance = BigDecimal.ZERO;
        private BigDecimal minimumBalance = BigDecimal.ZERO;
        private BigDecimal maximumBalance = BigDecimal.ZERO;
        private int totalTransactions = 0;
        private BigDecimal totalDeposits = BigDecimal.ZERO;
        private BigDecimal totalWithdrawals = BigDecimal.ZERO;
        private BigDecimal totalTransfersIn = BigDecimal.ZERO;
        private BigDecimal totalTransfersOut = BigDecimal.ZERO;
        private BigDecimal totalInterest = BigDecimal.ZERO;
        private BigDecimal totalFees = BigDecimal.ZERO;
        private int depositCount = 0;
        private int withdrawalCount = 0;
        private int transferInCount = 0;
        private int transferOutCount = 0;
        private int interestPayments = 0;
        private int feeCharges = 0;
        private BigDecimal interestRate = BigDecimal.ZERO;
        private int daysActive = 0;
        private List<BankTransaction> transactions = List.of();

        public Builder setAccountId(UUID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder setYear(int year) {
            this.year = year;
            return this;
        }

        public Builder setMonth(Month month) {
            this.month = month;
            return this;
        }

        public Builder setAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public Builder setAccountTier(BankAccountTier accountTier) {
            this.accountTier = accountTier;
            return this;
        }

        public Builder setOpeningBalance(BigDecimal openingBalance) {
            this.openingBalance = openingBalance;
            return this;
        }

        public Builder setClosingBalance(BigDecimal closingBalance) {
            this.closingBalance = closingBalance;
            return this;
        }

        public Builder setAverageBalance(BigDecimal averageBalance) {
            this.averageBalance = averageBalance;
            return this;
        }

        public Builder setMinimumBalance(BigDecimal minimumBalance) {
            this.minimumBalance = minimumBalance;
            return this;
        }

        public Builder setMaximumBalance(BigDecimal maximumBalance) {
            this.maximumBalance = maximumBalance;
            return this;
        }

        public Builder setTotalTransactions(int totalTransactions) {
            this.totalTransactions = totalTransactions;
            return this;
        }

        public Builder setTotalDeposits(BigDecimal totalDeposits) {
            this.totalDeposits = totalDeposits;
            return this;
        }

        public Builder setTotalWithdrawals(BigDecimal totalWithdrawals) {
            this.totalWithdrawals = totalWithdrawals;
            return this;
        }

        public Builder setTotalTransfersIn(BigDecimal totalTransfersIn) {
            this.totalTransfersIn = totalTransfersIn;
            return this;
        }

        public Builder setTotalTransfersOut(BigDecimal totalTransfersOut) {
            this.totalTransfersOut = totalTransfersOut;
            return this;
        }

        public Builder setTotalInterest(BigDecimal totalInterest) {
            this.totalInterest = totalInterest;
            return this;
        }

        public Builder setTotalFees(BigDecimal totalFees) {
            this.totalFees = totalFees;
            return this;
        }

        public Builder setDepositCount(int depositCount) {
            this.depositCount = depositCount;
            return this;
        }

        public Builder setWithdrawalCount(int withdrawalCount) {
            this.withdrawalCount = withdrawalCount;
            return this;
        }

        public Builder setTransferInCount(int transferInCount) {
            this.transferInCount = transferInCount;
            return this;
        }

        public Builder setTransferOutCount(int transferOutCount) {
            this.transferOutCount = transferOutCount;
            return this;
        }

        public Builder setInterestPayments(int interestPayments) {
            this.interestPayments = interestPayments;
            return this;
        }

        public Builder setFeeCharges(int feeCharges) {
            this.feeCharges = feeCharges;
            return this;
        }

        public Builder setInterestRate(BigDecimal interestRate) {
            this.interestRate = interestRate;
            return this;
        }

        public Builder setDaysActive(int daysActive) {
            this.daysActive = daysActive;
            return this;
        }

        public Builder setTransactions(List<BankTransaction> transactions) {
            this.transactions = transactions;
            return this;
        }

        public BankStatement build() {
            if (this.accountId == null) {
                throw new IllegalArgumentException("Account ID is required");
            }
            if (this.accountNumber == null) {
                throw new IllegalArgumentException("Account number is required");
            }
            if (this.accountTier == null) {
                throw new IllegalArgumentException("Account tier is required");
            }
            return new BankStatement(this);
        }
    }

    public static enum ActivityLevel {
        INACTIVE("Inactive"),
        LOW("Low Activity"),
        MODERATE("Moderate Activity"),
        HIGH("High Activity"),
        VERY_HIGH("Very High Activity");

        private final String displayName;

        private ActivityLevel(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

