/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.bank;

import java.math.BigDecimal;
import java.time.LocalDateTime;

public class BankStatistics {
    private final int totalAccounts;
    private final int activeAccounts;
    private final int frozenAccounts;
    private final BigDecimal totalDeposits;
    private final BigDecimal totalBalance;
    private final BigDecimal totalInterestPaid;
    private final int dailyTransactions;
    private final BigDecimal dailyVolume;
    private final LocalDateTime generatedAt;
    private final int basicAccounts;
    private final int silverAccounts;
    private final int goldAccounts;
    private final int platinumAccounts;
    private final BigDecimal averageBalance;
    private final BigDecimal largestBalance;
    private final BigDecimal smallestBalance;
    private final double averageInterestRate;

    public BankStatistics(int totalAccounts, int activeAccounts, int frozenAccounts, BigDecimal totalDeposits, BigDecimal totalBalance, BigDecimal totalInterestPaid, int dailyTransactions, BigDecimal dailyVolume, int basicAccounts, int silverAccounts, int goldAccounts, int platinumAccounts, BigDecimal averageBalance, BigDecimal largestBalance, BigDecimal smallestBalance, double averageInterestRate) {
        this.totalAccounts = totalAccounts;
        this.activeAccounts = activeAccounts;
        this.frozenAccounts = frozenAccounts;
        this.totalDeposits = totalDeposits;
        this.totalBalance = totalBalance;
        this.totalInterestPaid = totalInterestPaid;
        this.dailyTransactions = dailyTransactions;
        this.dailyVolume = dailyVolume;
        this.basicAccounts = basicAccounts;
        this.silverAccounts = silverAccounts;
        this.goldAccounts = goldAccounts;
        this.platinumAccounts = platinumAccounts;
        this.averageBalance = averageBalance;
        this.largestBalance = largestBalance;
        this.smallestBalance = smallestBalance;
        this.averageInterestRate = averageInterestRate;
        this.generatedAt = LocalDateTime.now();
    }

    public double getActivityPercentage() {
        if (this.totalAccounts == 0) {
            return 0.0;
        }
        return (double)this.activeAccounts / (double)this.totalAccounts * 100.0;
    }

    public double getFrozenPercentage() {
        if (this.totalAccounts == 0) {
            return 0.0;
        }
        return (double)this.frozenAccounts / (double)this.totalAccounts * 100.0;
    }

    public TierDistribution getTierDistribution() {
        if (this.totalAccounts == 0) {
            return new TierDistribution(0.0, 0.0, 0.0, 0.0);
        }
        double basicPct = (double)this.basicAccounts / (double)this.totalAccounts * 100.0;
        double silverPct = (double)this.silverAccounts / (double)this.totalAccounts * 100.0;
        double goldPct = (double)this.goldAccounts / (double)this.totalAccounts * 100.0;
        double platinumPct = (double)this.platinumAccounts / (double)this.totalAccounts * 100.0;
        return new TierDistribution(basicPct, silverPct, goldPct, platinumPct);
    }

    public int getSystemHealthScore() {
        BigDecimal concentration;
        int score = 100;
        if (this.getFrozenPercentage() > 5.0) {
            score -= (int)(this.getFrozenPercentage() - 5.0) * 2;
        }
        if (this.getActivityPercentage() < 50.0) {
            score -= (int)(50.0 - this.getActivityPercentage());
        }
        if (this.totalBalance.compareTo(BigDecimal.ZERO) > 0 && (concentration = this.largestBalance.divide(this.totalBalance, 4, 4)).doubleValue() > 0.5) {
            score -= 20;
        }
        return Math.max(0, Math.min(100, score));
    }

    public int getTotalAccounts() {
        return this.totalAccounts;
    }

    public int getActiveAccounts() {
        return this.activeAccounts;
    }

    public int getFrozenAccounts() {
        return this.frozenAccounts;
    }

    public BigDecimal getTotalDeposits() {
        return this.totalDeposits;
    }

    public BigDecimal getTotalBalance() {
        return this.totalBalance;
    }

    public BigDecimal getTotalInterestPaid() {
        return this.totalInterestPaid;
    }

    public int getDailyTransactions() {
        return this.dailyTransactions;
    }

    public BigDecimal getDailyVolume() {
        return this.dailyVolume;
    }

    public LocalDateTime getGeneratedAt() {
        return this.generatedAt;
    }

    public int getBasicAccounts() {
        return this.basicAccounts;
    }

    public int getSilverAccounts() {
        return this.silverAccounts;
    }

    public int getGoldAccounts() {
        return this.goldAccounts;
    }

    public int getPlatinumAccounts() {
        return this.platinumAccounts;
    }

    public BigDecimal getAverageBalance() {
        return this.averageBalance;
    }

    public BigDecimal getLargestBalance() {
        return this.largestBalance;
    }

    public BigDecimal getSmallestBalance() {
        return this.smallestBalance;
    }

    public double getAverageInterestRate() {
        return this.averageInterestRate;
    }

    public static class TierDistribution {
        private final double basicPercentage;
        private final double silverPercentage;
        private final double goldPercentage;
        private final double platinumPercentage;

        public TierDistribution(double basicPercentage, double silverPercentage, double goldPercentage, double platinumPercentage) {
            this.basicPercentage = basicPercentage;
            this.silverPercentage = silverPercentage;
            this.goldPercentage = goldPercentage;
            this.platinumPercentage = platinumPercentage;
        }

        public double getBasicPercentage() {
            return this.basicPercentage;
        }

        public double getSilverPercentage() {
            return this.silverPercentage;
        }

        public double getGoldPercentage() {
            return this.goldPercentage;
        }

        public double getPlatinumPercentage() {
            return this.platinumPercentage;
        }
    }
}

