/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.inflation;

import java.time.LocalDateTime;
import me.koyere.ecoxpert.modules.inflation.EconomicIntelligenceEngine;

public class EconomicSnapshot {
    private final LocalDateTime timestamp;
    private final double totalMoney;
    private final double averageBalance;
    private final int activeUsers;
    private final double transactionVolume;
    private final double marketActivity;
    private final EconomicIntelligenceEngine.EconomicCycle cycle;
    private final double economicHealth;
    private final double inflationRate;
    private final double velocityOfMoney;
    private final double giniCoefficient;
    private final double economicMomentum;
    private final double marketVolatility;

    public EconomicSnapshot(LocalDateTime timestamp, double totalMoney, double averageBalance, int activeUsers, double transactionVolume, double marketActivity, EconomicIntelligenceEngine.EconomicCycle cycle, double economicHealth, double inflationRate, double velocityOfMoney) {
        this.timestamp = timestamp;
        this.totalMoney = totalMoney;
        this.averageBalance = averageBalance;
        this.activeUsers = activeUsers;
        this.transactionVolume = transactionVolume;
        this.marketActivity = marketActivity;
        this.cycle = cycle;
        this.economicHealth = economicHealth;
        this.inflationRate = inflationRate;
        this.velocityOfMoney = velocityOfMoney;
        this.giniCoefficient = this.calculateGiniCoefficient();
        this.economicMomentum = this.calculateEconomicMomentum();
        this.marketVolatility = this.calculateMarketVolatility();
    }

    private double calculateGiniCoefficient() {
        if (this.averageBalance <= 0.0) {
            return 0.5;
        }
        double inequality = Math.min(1.0, this.totalMoney / ((double)this.activeUsers * this.averageBalance * 2.0));
        return Math.max(0.0, Math.min(1.0, inequality));
    }

    private double calculateEconomicMomentum() {
        return this.transactionVolume / 100000.0 * this.marketActivity;
    }

    private double calculateMarketVolatility() {
        return Math.abs(this.marketActivity - 0.5) * 2.0;
    }

    public double getEconomicStress() {
        double healthStress = 1.0 - this.economicHealth;
        double inequalityStress = this.giniCoefficient;
        double volatilityStress = this.marketVolatility;
        return healthStress * 0.5 + inequalityStress * 0.3 + volatilityStress * 0.2;
    }

    public double getEconomicOpportunityIndex() {
        double healthOpportunity = this.economicHealth;
        double activityOpportunity = this.marketActivity;
        double momentumOpportunity = Math.min(1.0, this.economicMomentum);
        return healthOpportunity * 0.4 + activityOpportunity * 0.4 + momentumOpportunity * 0.2;
    }

    public boolean requiresIntervention() {
        return this.economicHealth < 0.4 || this.inflationRate > 0.1 || this.inflationRate < -0.05;
    }

    public InterventionType getRecommendedIntervention() {
        if (this.economicHealth < 0.3) {
            return InterventionType.EMERGENCY_STIMULUS;
        }
        if (this.inflationRate > 0.08) {
            return InterventionType.MONETARY_TIGHTENING;
        }
        if (this.inflationRate < -0.03) {
            return InterventionType.MONETARY_EASING;
        }
        if (this.marketActivity < 0.2) {
            return InterventionType.MARKET_STIMULATION;
        }
        if (this.giniCoefficient > 0.8) {
            return InterventionType.WEALTH_REDISTRIBUTION;
        }
        return InterventionType.NONE;
    }

    public String generateReport() {
        StringBuilder report = new StringBuilder();
        report.append("=== Economic Snapshot Report ===\n");
        report.append("Timestamp: ").append(this.timestamp).append("\n");
        report.append("Economic Cycle: ").append((Object)this.cycle).append("\n");
        report.append("Economic Health: ").append(String.format("%.1f%%", this.economicHealth * 100.0)).append("\n");
        report.append("Inflation Rate: ").append(String.format("%.2f%%", this.inflationRate * 100.0)).append("\n");
        report.append("Total Money Supply: $").append(String.format("%.2f", this.totalMoney)).append("\n");
        report.append("Average Balance: $").append(String.format("%.2f", this.averageBalance)).append("\n");
        report.append("Active Users: ").append(this.activeUsers).append("\n");
        report.append("Transaction Volume: $").append(String.format("%.2f", this.transactionVolume)).append("\n");
        report.append("Market Activity: ").append(String.format("%.1f%%", this.marketActivity * 100.0)).append("\n");
        report.append("Velocity of Money: ").append(String.format("%.2f", this.velocityOfMoney)).append("\n");
        report.append("Wealth Inequality (Gini): ").append(String.format("%.3f", this.giniCoefficient)).append("\n");
        report.append("Economic Momentum: ").append(String.format("%.2f", this.economicMomentum)).append("\n");
        report.append("Market Volatility: ").append(String.format("%.2f", this.marketVolatility)).append("\n");
        report.append("Economic Stress: ").append(String.format("%.1f%%", this.getEconomicStress() * 100.0)).append("\n");
        report.append("Opportunity Index: ").append(String.format("%.1f%%", this.getEconomicOpportunityIndex() * 100.0)).append("\n");
        InterventionType intervention = this.getRecommendedIntervention();
        if (intervention != InterventionType.NONE) {
            report.append("\u26a0\ufe0f Intervention Needed: ").append((Object)intervention).append("\n");
        } else {
            report.append("\u2705 Economic conditions stable\n");
        }
        report.append("=== End Report ===");
        return report.toString();
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public double getTotalMoney() {
        return this.totalMoney;
    }

    public double getAverageBalance() {
        return this.averageBalance;
    }

    public int getActiveUsers() {
        return this.activeUsers;
    }

    public double getTransactionVolume() {
        return this.transactionVolume;
    }

    public double getMarketActivity() {
        return this.marketActivity;
    }

    public EconomicIntelligenceEngine.EconomicCycle getCycle() {
        return this.cycle;
    }

    public double getEconomicHealth() {
        return this.economicHealth;
    }

    public double getInflationRate() {
        return this.inflationRate;
    }

    public double getVelocityOfMoney() {
        return this.velocityOfMoney;
    }

    public double getGiniCoefficient() {
        return this.giniCoefficient;
    }

    public double getEconomicMomentum() {
        return this.economicMomentum;
    }

    public double getMarketVolatility() {
        return this.marketVolatility;
    }

    public static enum InterventionType {
        NONE,
        MONETARY_EASING,
        MONETARY_TIGHTENING,
        MARKET_STIMULATION,
        EMERGENCY_STIMULUS,
        WEALTH_REDISTRIBUTION;

    }
}

