/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.inflation;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.modules.inflation.EconomicIntelligenceEngine;
import me.koyere.ecoxpert.modules.inflation.EconomicMemory;
import me.koyere.ecoxpert.modules.inflation.EconomicSnapshot;
import me.koyere.ecoxpert.modules.inflation.PlayerEconomicProfile;

public interface InflationManager {
    public CompletableFuture<Void> initialize();

    public void shutdown();

    public EconomicIntelligenceEngine.EconomicCycle getCurrentCycle();

    public double getEconomicHealth();

    public double getInflationRate();

    public double getVelocityOfMoney();

    public CompletableFuture<EconomicSnapshot> getCurrentSnapshot();

    public PlayerEconomicProfile getPlayerProfile(UUID var1);

    public EconomicMemory.EconomicForecast getEconomicForecast();

    public List<EconomicMemory.EconomicAnomaly> detectAnomalies();

    public CompletableFuture<Void> forceIntervention(EconomicSnapshot.InterventionType var1, double var2);

    public double getInterventionEffectiveness(EconomicSnapshot.InterventionType var1);

    public void recordPlayerTransaction(UUID var1, double var2, String var4);

    public String getEconomicStatistics();

    public String runDiagnostics();

    public boolean isActive();

    public InflationSystemStatus getSystemStatus();

    public String getPolicyInfo();

    public boolean setPolicyParam(String var1, double var2);

    public double[] getMarketFactors();

    public void reloadPolicy();

    public static class InflationSystemStatus {
        private final boolean active;
        private final EconomicIntelligenceEngine.EconomicCycle currentCycle;
        private final double economicHealth;
        private final double inflationRate;
        private final int trackedPlayers;
        private final long dataPoints;
        private final String lastIntervention;

        public InflationSystemStatus(boolean active, EconomicIntelligenceEngine.EconomicCycle currentCycle, double economicHealth, double inflationRate, int trackedPlayers, long dataPoints, String lastIntervention) {
            this.active = active;
            this.currentCycle = currentCycle;
            this.economicHealth = economicHealth;
            this.inflationRate = inflationRate;
            this.trackedPlayers = trackedPlayers;
            this.dataPoints = dataPoints;
            this.lastIntervention = lastIntervention;
        }

        public boolean isActive() {
            return this.active;
        }

        public EconomicIntelligenceEngine.EconomicCycle getCurrentCycle() {
            return this.currentCycle;
        }

        public double getEconomicHealth() {
            return this.economicHealth;
        }

        public double getInflationRate() {
            return this.inflationRate;
        }

        public int getTrackedPlayers() {
            return this.trackedPlayers;
        }

        public long getDataPoints() {
            return this.dataPoints;
        }

        public String getLastIntervention() {
            return this.lastIntervention;
        }

        public String toString() {
            return String.format("InflationSystem{active=%s, cycle=%s, health=%.1f%%, inflation=%.2f%%, players=%d, data=%d}", new Object[]{this.active, this.currentCycle, this.economicHealth * 100.0, this.inflationRate * 100.0, this.trackedPlayers, this.dataPoints});
        }
    }
}

