/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.integrations;

import java.lang.reflect.Method;
import java.util.ArrayList;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.modules.integrations.IntegrationsManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class IntegrationsManagerImpl
implements IntegrationsManager {
    private final EcoXpertPlugin plugin;
    private final boolean enabled;
    private final boolean detectJobs;
    private final boolean detectTowny;
    private final boolean detectLands;
    private final boolean detectSlimefun;
    private final boolean detectMcMMO;

    public IntegrationsManagerImpl(EcoXpertPlugin plugin) {
        this.plugin = plugin;
        boolean en = true;
        boolean dj = true;
        boolean dt = true;
        boolean dl = true;
        boolean ds = true;
        boolean dm = true;
        try {
            ConfigManager cfg = plugin.getServiceRegistry().getInstance(ConfigManager.class);
            FileConfiguration c = cfg.getModuleConfig("integrations");
            en = c.getBoolean("enabled", true);
            ConfigurationSection section = c.getConfigurationSection("detect");
            dj = section == null || section.getBoolean("jobs", true);
            dt = section == null || section.getBoolean("towny", true);
            dl = section == null || section.getBoolean("lands", true);
            ds = section == null || section.getBoolean("slimefun", true);
            dm = section == null || section.getBoolean("mcmmo", true);
        }
        catch (Throwable cfg) {
            // empty catch block
        }
        this.enabled = en;
        this.detectJobs = dj;
        this.detectTowny = dt;
        this.detectLands = dl;
        this.detectSlimefun = ds;
        this.detectMcMMO = dm;
        try {
            boolean wg = this.hasWorldGuard();
            boolean lands = this.hasLands();
            boolean jobs = this.hasJobs();
            boolean towny = this.hasTowny();
            boolean slimefun = this.hasSlimefun();
            boolean mcmmo = this.hasMcMMO();
            plugin.getLogger().info(String.format("Integrations detected \u2192 WorldGuard=%s, Lands=%s, Jobs=%s, Towny=%s, Slimefun=%s, McMMO=%s", wg ? "yes" : "no", lands ? "yes" : "no", jobs ? "yes" : "no", towny ? "yes" : "no", slimefun ? "yes" : "no", mcmmo ? "yes" : "no"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean hasWorldGuard() {
        if (!this.enabled) {
            return false;
        }
        return Bukkit.getPluginManager().getPlugin("WorldGuard") != null;
    }

    @Override
    public boolean hasLands() {
        if (!this.enabled || !this.detectLands) {
            return false;
        }
        return Bukkit.getPluginManager().getPlugin("Lands") != null;
    }

    @Override
    public boolean hasJobs() {
        if (!this.enabled || !this.detectJobs) {
            return false;
        }
        return Bukkit.getPluginManager().getPlugin("Jobs") != null || Bukkit.getPluginManager().getPlugin("JobsReborn") != null;
    }

    @Override
    public boolean hasTowny() {
        if (!this.enabled || !this.detectTowny) {
            return false;
        }
        return Bukkit.getPluginManager().getPlugin("Towny") != null;
    }

    @Override
    public boolean hasSlimefun() {
        if (!this.enabled || !this.detectSlimefun) {
            return false;
        }
        return Bukkit.getPluginManager().getPlugin("Slimefun") != null || Bukkit.getPluginManager().getPlugin("Slimefun4") != null;
    }

    @Override
    public boolean hasMcMMO() {
        if (!this.enabled || !this.detectMcMMO) {
            return false;
        }
        return Bukkit.getPluginManager().getPlugin("mcMMO") != null || Bukkit.getPluginManager().getPlugin("McMMO") != null;
    }

    @Override
    public String getWorldGuardRegions(Player player) {
        if (!this.hasWorldGuard()) {
            return "";
        }
        try {
            Location loc = player.getLocation();
            Class<?> wgClass = Class.forName("com.sk89q.worldguard.WorldGuard");
            Method getInstance = wgClass.getMethod("getInstance", new Class[0]);
            Object wg = getInstance.invoke(null, new Object[0]);
            Object platform = wgClass.getMethod("getPlatform", new Class[0]).invoke(wg, new Object[0]);
            Object regionContainer = platform.getClass().getMethod("getRegionContainer", new Class[0]).invoke(platform, new Object[0]);
            Class<?> bukkitAdapter = Class.forName("com.sk89q.worldedit.bukkit.BukkitAdapter");
            Object weWorld = bukkitAdapter.getMethod("adapt", World.class).invoke(null, loc.getWorld());
            Object weLoc = bukkitAdapter.getMethod("adapt", Location.class).invoke(null, loc);
            Object query = regionContainer.getClass().getMethod("createQuery", new Class[0]).invoke(regionContainer, new Object[0]);
            Object applicable = query.getClass().getMethod("getApplicableRegions", Class.forName("com.sk89q.worldedit.util.Location")).invoke(query, weLoc);
            Iterable it = (Iterable)applicable;
            ArrayList<String> ids = new ArrayList<String>();
            for (Object region : it) {
                String id = (String)region.getClass().getMethod("getId", new Class[0]).invoke(region, new Object[0]);
                if (id == null || id.isEmpty()) continue;
                ids.add(id);
            }
            return String.join((CharSequence)",", ids);
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    @Override
    public String getLandsLand(Player player) {
        if (!this.hasLands()) {
            return "";
        }
        try {
            Location loc = player.getLocation();
            Class<?> landsApiClass = Class.forName("me.angeschossen.lands.api.LandsAPI");
            Object api = landsApiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Object land = landsApiClass.getMethod("getLandByLocation", Location.class).invoke(api, loc);
            if (land == null) {
                return "";
            }
            String name = (String)land.getClass().getMethod("getName", new Class[0]).invoke(land, new Object[0]);
            return name != null ? name : "";
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    @Override
    public String getTownyTown(Player player) {
        block13: {
            if (!this.hasTowny()) {
                return "";
            }
            try {
                Class<?> apiClass = Class.forName("com.palmergames.bukkit.towny.TownyAPI");
                Object api = apiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                try {
                    Object town = apiClass.getMethod("getTown", Player.class).invoke(api, player);
                    if (town != null) {
                        String name = (String)town.getClass().getMethod("getName", new Class[0]).invoke(town, new Object[0]);
                        return name != null ? name : "";
                    }
                }
                catch (NoSuchMethodException town) {
                    // empty catch block
                }
                try {
                    Object resident = apiClass.getMethod("getResident", Player.class).invoke(api, player);
                    if (resident == null) break block13;
                    Object town = null;
                    try {
                        town = resident.getClass().getMethod("getTownOrNull", new Class[0]).invoke(resident, new Object[0]);
                    }
                    catch (NoSuchMethodException ns1) {
                        try {
                            town = resident.getClass().getMethod("getTown", new Class[0]).invoke(resident, new Object[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (town != null) {
                        String name = (String)town.getClass().getMethod("getName", new Class[0]).invoke(town, new Object[0]);
                        return name != null ? name : "";
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "";
    }
}

