/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.loans;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.data.QueryResult;
import me.koyere.ecoxpert.core.safety.SafeModeManager;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LoanDelinquencyScheduler {
    private final EcoXpertPlugin plugin;
    private final DataManager dataManager;
    private final EconomyManager economyManager;
    private final ConcurrentHashMap<UUID, Long> lastNotify = new ConcurrentHashMap();
    private final AtomicBoolean running = new AtomicBoolean(false);

    public LoanDelinquencyScheduler(EcoXpertPlugin plugin, DataManager dataManager, EconomyManager economyManager) {
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.economyManager = economyManager;
    }

    public void start() {
        try {
            FileConfiguration cfg = this.plugin.getServiceRegistry().getInstance(ConfigManager.class).getModuleConfig("loans");
            boolean enabled = cfg.getBoolean("enabled", true);
            if (!enabled) {
                return;
            }
            int intervalMinutes = cfg.getInt("scheduler.interval_minutes", 60);
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::runOnce, 200L, 1200L * (long)intervalMinutes);
            this.plugin.getLogger().info("Loan delinquency scheduler started (" + intervalMinutes + " min)");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to start loan scheduler: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnce() {
        block22: {
            if (!this.running.compareAndSet(false, true)) {
                this.plugin.getLogger().fine("Loan scheduler: previous run still active, skipping iteration");
                return;
            }
            try {
                FileConfiguration cfg = this.plugin.getServiceRegistry().getInstance(ConfigManager.class).getModuleConfig("loans");
                double penalty = cfg.getDouble("policy.late.penalty_rate", 0.01);
                boolean notify = cfg.getBoolean("policy.late.notify", true);
                double capFraction = cfg.getDouble("policy.late.penalty_cap_fraction", 0.5);
                int notifyCooldownMin = cfg.getInt("policy.late.notify_cooldown_minutes", 120);
                try {
                    SafeModeManager safe = this.plugin.getServiceRegistry().getInstance(SafeModeManager.class);
                    if (safe != null && safe.isActive()) {
                        this.plugin.getLogger().fine("Loan scheduler: Safe Mode active, skipping");
                        return;
                    }
                }
                catch (Exception safe) {
                    // empty catch block
                }
                HashSet<Long> penalizedLoans = new HashSet<Long>();
                QueryResult qr = this.dataManager.executeQuery("SELECT s.id as sid, s.loan_id as lid, l.player_uuid as pu, l.outstanding as out, l.principal as principal, s.amount_due, s.paid_amount FROM ecoxpert_loan_schedules s JOIN ecoxpert_loans l ON l.id = s.loan_id WHERE s.status = 'PENDING' AND s.due_date < date('now')", new Object[0]).join();
                block15: while (true) {
                    while (qr.next()) {
                        long schedId = qr.getLong("sid");
                        long loanId = qr.getLong("lid");
                        String pu = qr.getString("pu");
                        BigDecimal outstanding = qr.getBigDecimal("out");
                        BigDecimal principal = qr.getBigDecimal("principal");
                        this.dataManager.executeUpdate("UPDATE ecoxpert_loan_schedules SET status='LATE' WHERE id = ?", schedId).join();
                        if (outstanding != null && penalty > 0.0 && !penalizedLoans.contains(loanId)) {
                            BigDecimal cap;
                            BigDecimal newOut = outstanding.multiply(BigDecimal.valueOf(1.0 + penalty));
                            if (principal != null && capFraction > 0.0 && newOut.compareTo(cap = principal.add(principal.multiply(BigDecimal.valueOf(capFraction)))) > 0) {
                                newOut = cap;
                            }
                            this.dataManager.executeUpdate("UPDATE ecoxpert_loans SET outstanding = ? WHERE id = ?", newOut, loanId).join();
                            penalizedLoans.add(loanId);
                        }
                        if (!notify || pu == null) continue;
                        try {
                            Player p;
                            long last;
                            UUID uuid = UUID.fromString(pu);
                            long now = System.currentTimeMillis();
                            if (now - (last = this.lastNotify.getOrDefault(uuid, 0L).longValue()) < (long)notifyCooldownMin * 60000L || (p = Bukkit.getPlayer((UUID)uuid)) == null || !p.isOnline()) continue block15;
                            TranslationManager tm = this.plugin.getServiceRegistry().getInstance(TranslationManager.class);
                            p.sendMessage(tm.getMessage("prefix", new Object[0]) + tm.getPlayerMessage(p, "loans.overdue-summary", 1));
                            this.lastNotify.put(uuid, now);
                            continue block15;
                        }
                        catch (Exception exception) {
                        }
                    }
                    break block22;
                    {
                        continue block15;
                        break;
                    }
                    break;
                }
                finally {
                    if (qr != null) {
                        qr.close();
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Loan scheduler error: " + e.getMessage());
            }
            finally {
                this.running.set(false);
            }
        }
    }
}

