/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.loans;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.data.QueryResult;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.loans.Loan;
import me.koyere.ecoxpert.modules.loans.LoanManager;
import me.koyere.ecoxpert.modules.loans.LoanOffer;
import me.koyere.ecoxpert.modules.loans.LoanPayment;
import me.koyere.ecoxpert.modules.loans.LoanScoringPolicy;

public class LoanManagerImpl
implements LoanManager {
    private final EcoXpertPlugin plugin;
    private final DataManager dataManager;
    private final EconomyManager economyManager;

    public LoanManagerImpl(EcoXpertPlugin plugin, DataManager dataManager, EconomyManager economyManager) {
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.economyManager = economyManager;
    }

    @Override
    public CompletableFuture<Boolean> requestLoan(UUID playerUuid, BigDecimal amount, BigDecimal interestRate) {
        if (amount == null || amount.signum() <= 0) {
            return CompletableFuture.completedFuture(false);
        }
        return this.getActiveLoan(playerUuid).thenCompose(active -> {
            if (active.isPresent()) {
                return CompletableFuture.completedFuture(false);
            }
            String sql = "INSERT INTO ecoxpert_loans (player_uuid, principal, outstanding, interest_rate, status, created_at) VALUES (?, ?, ?, ?, 'ACTIVE', CURRENT_TIMESTAMP)";
            return this.dataManager.executeUpdate(sql, playerUuid.toString(), amount, amount, interestRate).thenCompose(updated -> {
                if (updated <= 0) {
                    return CompletableFuture.completedFuture(false);
                }
                return this.economyManager.addMoney(playerUuid, amount, "Loan disbursement").thenApply(v -> true);
            });
        });
    }

    @Override
    public CompletableFuture<LoanOffer> getOffer(UUID playerUuid, BigDecimal amount) {
        return CompletableFuture.supplyAsync(() -> new LoanScoringPolicy(this.plugin, this.dataManager).computeOffer(playerUuid, amount));
    }

    @Override
    public CompletableFuture<Boolean> requestLoanSmart(UUID playerUuid, BigDecimal amount) {
        return this.getOffer(playerUuid, amount).thenCompose(offer -> {
            if (!offer.approved()) {
                return CompletableFuture.completedFuture(false);
            }
            BigDecimal rate = offer.interestRate();
            return this.getActiveLoan(playerUuid).thenCompose(active -> {
                if (active.isPresent()) {
                    return CompletableFuture.completedFuture(false);
                }
                String sql = "INSERT INTO ecoxpert_loans (player_uuid, principal, outstanding, interest_rate, status, created_at) VALUES (?, ?, ?, ?, 'ACTIVE', CURRENT_TIMESTAMP)";
                return this.dataManager.executeUpdate(sql, playerUuid.toString(), amount, amount, rate).thenCompose(updated -> {
                    if (updated <= 0) {
                        return CompletableFuture.completedFuture(false);
                    }
                    return this.economyManager.addMoney(playerUuid, amount, "Loan disbursement").thenCompose(v -> new LoanScoringPolicy(this.plugin, this.dataManager).createScheduleFor(playerUuid, amount, rate, offer.termDays()).thenApply(ok -> true));
                });
            });
        });
    }

    @Override
    public CompletableFuture<List<LoanPayment>> getSchedule(UUID playerUuid) {
        return CompletableFuture.supplyAsync(() -> new LoanScoringPolicy(this.plugin, this.dataManager).getSchedule(playerUuid));
    }

    @Override
    public CompletableFuture<Boolean> payLoan(UUID playerUuid, BigDecimal amount) {
        if (amount == null || amount.signum() <= 0) {
            return CompletableFuture.completedFuture(false);
        }
        return this.getActiveLoan(playerUuid).thenCompose(active -> {
            if (active.isEmpty()) {
                return CompletableFuture.completedFuture(false);
            }
            Loan loan = (Loan)active.get();
            BigDecimal computedOutstanding = loan.getOutstanding().subtract(amount);
            BigDecimal newOutstanding = computedOutstanding.signum() < 0 ? BigDecimal.ZERO : computedOutstanding;
            return this.economyManager.removeMoney(playerUuid, amount, "Loan payment").thenCompose(success -> {
                if (!success.booleanValue()) {
                    return CompletableFuture.completedFuture(false);
                }
                String sql = "UPDATE ecoxpert_loans SET outstanding = ?, last_payment_at = CURRENT_TIMESTAMP, status = CASE WHEN ? <= 0 THEN 'PAID' ELSE 'ACTIVE' END WHERE id = ?";
                return this.dataManager.executeUpdate(sql, newOutstanding, newOutstanding, loan.getId()).thenCompose(rows -> this.applyPaymentToSchedule(loan.getId(), amount).thenApply(v -> rows > 0));
            });
        });
    }

    private CompletableFuture<Void> applyPaymentToSchedule(long loanId, BigDecimal amount) {
        return CompletableFuture.runAsync(() -> {
            BigDecimal remaining = amount;
            try {
                while (remaining.signum() > 0) {
                    QueryResult qr = this.dataManager.executeQuery("SELECT id, amount_due, paid_amount FROM ecoxpert_loan_schedules WHERE loan_id = ? AND status != 'PAID' ORDER BY installment_no LIMIT 1", loanId).join();
                    try {
                        BigDecimal toPay;
                        BigDecimal payNow;
                        if (!qr.next()) {
                            return;
                        }
                        long schedId = qr.getLong("id");
                        BigDecimal due = qr.getBigDecimal("amount_due");
                        BigDecimal paid = qr.getBigDecimal("paid_amount");
                        BigDecimal newPaid = paid.add(payNow = remaining.min(toPay = due.subtract(paid)));
                        String newStatus = newPaid.compareTo(due) >= 0 ? "PAID" : "PENDING";
                        this.dataManager.executeUpdate("UPDATE ecoxpert_loan_schedules SET paid_amount = ?, status = ?, paid_at = CASE WHEN ? >= amount_due THEN CURRENT_TIMESTAMP ELSE paid_at END WHERE id = ?", newPaid, newStatus, newPaid, schedId).join();
                        remaining = remaining.subtract(payNow);
                    }
                    finally {
                        if (qr == null) continue;
                        qr.close();
                    }
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Override
    public CompletableFuture<Optional<Loan>> getActiveLoan(UUID playerUuid) {
        String sql = "SELECT id, player_uuid, principal, outstanding, interest_rate, created_at, status FROM ecoxpert_loans WHERE player_uuid = ? AND status = 'ACTIVE' ORDER BY id DESC LIMIT 1";
        return this.dataManager.executeQuery(sql, playerUuid.toString()).thenApply(this::mapSingleLoan);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Loan> mapSingleLoan(QueryResult result) {
        try (QueryResult queryResult = result;){
            if (!result.next()) {
                Optional<Loan> optional = Optional.empty();
                return optional;
            }
            long id = result.getLong("id");
            UUID uuid = UUID.fromString(result.getString("player_uuid"));
            BigDecimal principal = result.getBigDecimal("principal");
            BigDecimal outstanding = result.getBigDecimal("outstanding");
            BigDecimal rate = result.getBigDecimal("interest_rate");
            LocalDateTime created = result.getTimestamp("created_at").toLocalDateTime();
            String status = result.getString("status");
            Optional<Loan> optional = Optional.of(new Loan(id, uuid, principal, outstanding, rate, created, status));
            return optional;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to map loan row: " + e.getMessage());
            return Optional.empty();
        }
    }
}

