/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.market;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.ServiceRegistry;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.modules.events.EconomicEvent;
import me.koyere.ecoxpert.modules.events.EconomicEventEngine;
import me.koyere.ecoxpert.modules.market.MarketItem;
import me.koyere.ecoxpert.modules.market.MarketManager;
import me.koyere.ecoxpert.modules.market.MarketTrend;
import me.koyere.ecoxpert.modules.market.orders.MarketOrderService;
import me.koyere.ecoxpert.modules.professions.ProfessionRole;
import me.koyere.ecoxpert.modules.professions.ProfessionsManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class MarketGUI
implements Listener {
    private final MarketManager marketManager;
    private final MarketOrderService orderService;
    private final TranslationManager translationManager;
    private final ConfigManager configManager;
    private final Logger logger;
    private final Map<UUID, MarketInventory> openGUIs = new ConcurrentHashMap<UUID, MarketInventory>();
    private static final int ITEMS_PER_PAGE = 45;
    private static final int INVENTORY_SIZE = 54;
    private static final String GUI_TITLE = "Market";
    private static final int PREV_PAGE_SLOT = 45;
    private static final int NEXT_PAGE_SLOT = 53;
    private static final int INFO_SLOT = 49;
    private static final int CLOSE_SLOT = 50;
    private static final int CATEGORY_SLOT = 46;
    private static final int LETTER_SLOT = 47;
    private static final int SELL_HAND_SLOT = 51;
    private static final int ORDERS_SLOT = 52;
    private static final int CLEAR_FILTERS_SLOT = 48;
    private final List<String> categoryOrder = new ArrayList<String>();
    private final Map<String, Set<Material>> categories = new HashMap<String, Set<Material>>();
    private final Map<UUID, ListState> listing = new ConcurrentHashMap<UUID, ListState>();

    public MarketGUI(MarketManager marketManager, TranslationManager translationManager, Logger logger) {
        this.marketManager = marketManager;
        this.translationManager = translationManager;
        this.logger = logger;
        this.configManager = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(ConfigManager.class);
        this.orderService = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(MarketOrderService.class);
        this.loadCategories();
    }

    private void loadCategories() {
        try {
            FileConfiguration marketCfg = this.configManager.getModuleConfig("market");
            ConfigurationSection section = marketCfg.getConfigurationSection("categories");
            this.categoryOrder.clear();
            this.categories.clear();
            this.categoryOrder.add("ALL");
            if (section != null) {
                for (String key : section.getKeys(false)) {
                    List mats = marketCfg.getStringList("categories." + key + ".materials");
                    HashSet<Material> set = new HashSet<Material>();
                    for (String m : mats) {
                        try {
                            set.add(Material.valueOf((String)m.toUpperCase()));
                        }
                        catch (Exception exception) {}
                    }
                    this.categories.put(key.toUpperCase(), set);
                    this.categoryOrder.add(key.toUpperCase());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openMarketGUI(Player player) {
        try {
            this.marketManager.getAllItems().whenComplete((items, throwable) -> {
                if (throwable != null) {
                    this.logger.log(Level.SEVERE, "Error loading market items for GUI", (Throwable)throwable);
                    player.sendMessage(this.translationManager.getMessage("market.system-error", new Object[0]));
                    return;
                }
                List<MarketItem> activeItems = items.stream().filter(MarketItem::isActivelyTraded).sorted(Comparator.comparing(item -> item.getMaterial().name())).toList();
                Bukkit.getScheduler().runTask(player.getServer().getPluginManager().getPlugin("EcoXpert"), () -> {
                    MarketInventory marketInv = new MarketInventory(player, activeItems, 0);
                    this.openGUIs.put(player.getUniqueId(), marketInv);
                    Inventory gui = this.createMarketPage(marketInv);
                    player.openInventory(gui);
                });
            });
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error opening market GUI", e);
            player.sendMessage(this.translationManager.getMessage("market.system-error", new Object[0]));
        }
    }

    private Inventory createMarketPage(MarketInventory marketInv) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)this.translationManager.getMessage("market.gui.title", new Object[0]));
        List<MarketItem> items = marketInv.getItems();
        int page = marketInv.getCurrentPage();
        List<MarketItem> filtered = this.applyFilters(items, marketInv);
        int startIndex = page * 45;
        int endIndex = Math.min(startIndex + 45, filtered.size());
        for (int i = startIndex; i < endIndex; ++i) {
            MarketItem item = filtered.get(i);
            ItemStack displayItem = this.createMarketItemStack(item);
            gui.setItem(i - startIndex, displayItem);
        }
        this.addNavigationItems(gui, page, filtered.size(), marketInv);
        return gui;
    }

    private List<MarketItem> applyFilters(List<MarketItem> items, MarketInventory inv) {
        String cat = inv.getSelectedCategory();
        Character letter = inv.getFilterLetter();
        Stream<MarketItem> stream = items.stream().filter(mi -> {
            Set set;
            if (cat != null && !"ALL".equals(cat) && !(set = this.categories.getOrDefault(cat, Collections.emptySet())).contains(mi.getMaterial())) {
                return false;
            }
            if (letter != null) {
                return mi.getMaterial().name().startsWith(String.valueOf(letter));
            }
            return true;
        });
        ArrayList<MarketItem> list = new ArrayList<MarketItem>(stream.toList());
        list.sort(switch (inv.getSortMode()) {
            default -> throw new IncompatibleClassChangeError();
            case SortMode.NAME -> Comparator.comparing(mi -> mi.getMaterial().name());
            case SortMode.BUY_ASC -> Comparator.comparing(MarketItem::getCurrentBuyPrice, Comparator.nullsLast(Comparator.naturalOrder()));
            case SortMode.SELL_ASC -> Comparator.comparing(MarketItem::getCurrentSellPrice, Comparator.nullsLast(Comparator.naturalOrder()));
            case SortMode.SELL_DESC -> Comparator.comparing(MarketItem::getCurrentSellPrice, Comparator.nullsLast(Comparator.naturalOrder())).reversed();
            case SortMode.VOLUME_ASC -> Comparator.comparing(MarketItem::getTotalVolume, Comparator.nullsLast(Comparator.naturalOrder()));
            case SortMode.VOLUME_DESC -> Comparator.comparing(MarketItem::getTotalVolume, Comparator.nullsLast(Comparator.naturalOrder())).reversed();
        });
        return list;
    }

    private ItemStack createMarketItemStack(MarketItem item) {
        ItemStack stack = new ItemStack(item.getMaterial());
        ItemMeta meta = stack.getItemMeta();
        if (meta != null) {
            BigDecimal eff;
            double f2;
            String itemName = item.getMaterial().name().toLowerCase().replace('_', ' ');
            itemName = this.capitalizeWords(itemName);
            meta.setDisplayName("\u00a7e" + itemName);
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77" + this.translationManager.getMessage("market.gui.item.header", new Object[0]));
            lore.add("");
            if (item.isBuyable()) {
                lore.add("\u00a7a" + this.translationManager.getMessage("market.gui.item.buy-price", this.formatPrice(item.getCurrentBuyPrice()), new Object[0]));
                try {
                    f2 = this.computeEffectiveFactorForItem(this.getCurrentViewer(), item.getMaterial(), true);
                    if (Math.abs(f2 - 1.0) > 1.0E-6) {
                        eff = item.getCurrentBuyPrice().multiply(BigDecimal.valueOf(f2)).setScale(2, RoundingMode.HALF_UP);
                        lore.add("\u00a77" + this.translationManager.getMessage("market.gui.item.effective-buy", this.formatPrice(eff), new Object[0]));
                    }
                }
                catch (Exception f2) {}
            } else {
                lore.add("\u00a7c" + this.translationManager.getMessage("market.gui.item.not-buyable", new Object[0]));
            }
            if (item.isSellable()) {
                lore.add("\u00a7c" + this.translationManager.getMessage("market.gui.item.sell-price", this.formatPrice(item.getCurrentSellPrice()), new Object[0]));
                try {
                    f2 = this.computeEffectiveFactorForItem(this.getCurrentViewer(), item.getMaterial(), false);
                    if (Math.abs(f2 - 1.0) > 1.0E-6) {
                        eff = item.getCurrentSellPrice().multiply(BigDecimal.valueOf(f2)).setScale(2, RoundingMode.HALF_UP);
                        lore.add("\u00a77" + this.translationManager.getMessage("market.gui.item.effective-sell", this.formatPrice(eff), new Object[0]));
                    }
                }
                catch (Exception f3) {
                    // empty catch block
                }
                try {
                    FileConfiguration cfg = this.configManager.getModuleConfig("market");
                    double minFrac = cfg.getDouble("orders.listing.price_bounds_min_base_fraction", 0.1);
                    double maxFrac = cfg.getDouble("orders.listing.price_bounds_max_base_fraction", 10.0);
                    BigDecimal min = item.getCurrentSellPrice().multiply(new BigDecimal(String.valueOf(minFrac))).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal max = item.getCurrentSellPrice().multiply(new BigDecimal(String.valueOf(maxFrac))).setScale(2, RoundingMode.HALF_UP);
                    lore.add("\u00a77" + this.translationManager.getMessage("market.gui.info.range", this.formatPrice(min), this.formatPrice(max)));
                    lore.add("\u00a77" + this.translationManager.getMessage("market.gui.item.list-hint", new Object[0]));
                }
                catch (Exception cfg) {}
            } else {
                lore.add("\u00a77" + this.translationManager.getMessage("market.gui.item.not-sellable", new Object[0]));
            }
            lore.add("");
            lore.add("\u00a77" + this.translationManager.getMessage("market.gui.item.volume", item.getTotalVolume()));
            try {
                MarketTrend trend;
                CompletableFuture<MarketTrend> trendFuture = this.marketManager.getItemTrend(item.getMaterial());
                if (trendFuture.isDone() && (trend = (MarketTrend)trendFuture.getNow(null)) != null) {
                    String trendColor = this.getTrendColor(trend.getDirection());
                    lore.add("\u00a77" + this.translationManager.getMessage("market.gui.item.trend", trendColor + trend.getDirection().getDisplayName(), new Object[0]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            lore.add("");
            lore.add("\u00a7e" + this.translationManager.getMessage("market.gui.item.click-buy", new Object[0]));
            lore.add("\u00a7e" + this.translationManager.getMessage("market.gui.item.shift-click-sell", new Object[0]));
            meta.setLore(lore);
            stack.setItemMeta(meta);
        }
        return stack;
    }

    private Player getCurrentViewer() {
        UUID any;
        Player p;
        if (!this.openGUIs.isEmpty() && (p = Bukkit.getPlayer((UUID)(any = this.openGUIs.keySet().iterator().next()))) != null) {
            return p;
        }
        return null;
    }

    private double computeEffectiveFactorForItem(Player player, Material material, boolean isBuy) {
        if (player == null) {
            return 1.0;
        }
        try {
            ServiceRegistry sr = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry();
            ProfessionsManager pm = sr.getInstance(ProfessionsManager.class);
            Optional<ProfessionRole> roleOpt = pm.getRole(player.getUniqueId()).join();
            if (roleOpt.isEmpty()) {
                return 1.0;
            }
            String role = roleOpt.get().name().toLowerCase();
            FileConfiguration profCfg = sr.getInstance(ConfigManager.class).getModuleConfig("professions");
            int level = pm.getLevel(player.getUniqueId()).join();
            int maxLevel = profCfg.getInt("max_level", 5);
            level = Math.max(1, Math.min(level, maxLevel));
            double base = profCfg.getDouble("roles." + role + "." + (isBuy ? "buy_factor" : "sell_factor"), 1.0);
            double per = profCfg.getDouble("roles." + role + "." + (isBuy ? "buy_bonus_per_level" : "sell_bonus_per_level"), 0.0);
            double v = isBuy ? base * (1.0 - per * (double)(level - 1)) : base * (1.0 + per * (double)(level - 1));
            for (Map.Entry<String, Set<Material>> e : this.categories.entrySet()) {
                if (!e.getValue().contains(material)) continue;
                String ck = "roles." + role + ".category_bonuses." + e.getKey().toLowerCase() + "." + (isBuy ? "buy_factor" : "sell_factor");
                v *= profCfg.getDouble(ck, 1.0);
            }
            EconomicEventEngine events = sr.getInstance(EconomicEventEngine.class);
            if (events != null) {
                for (EconomicEvent ev : events.getActiveEvents().values()) {
                    String ek = "roles." + role + ".event_bonuses." + ev.getType().name() + "." + (isBuy ? "buy_factor" : "sell_factor");
                    v *= profCfg.getDouble(ek, 1.0);
                }
            }
            if (v < 0.5) {
                v = 0.5;
            }
            if (v > 1.5) {
                v = 1.5;
            }
            return v;
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    private void addNavigationItems(Inventory gui, int currentPage, int totalItems, MarketInventory inv) {
        ItemStack info;
        ItemMeta infoMeta;
        ItemMeta meta;
        int totalPages = (int)Math.ceil((double)totalItems / 45.0);
        if (currentPage > 0) {
            ItemStack prevPage = new ItemStack(Material.ARROW);
            meta = prevPage.getItemMeta();
            if (meta != null) {
                meta.setDisplayName("\u00a7a" + this.translationManager.getMessage("market.gui.prev-page", new Object[0]));
                meta.setLore(Arrays.asList("\u00a77" + this.translationManager.getMessage("market.gui.current-page", currentPage + 1, totalPages)));
                prevPage.setItemMeta(meta);
            }
            gui.setItem(45, prevPage);
        }
        if (currentPage < totalPages - 1) {
            ItemStack nextPage = new ItemStack(Material.ARROW);
            meta = nextPage.getItemMeta();
            if (meta != null) {
                meta.setDisplayName("\u00a7a" + this.translationManager.getMessage("market.gui.next-page", new Object[0]));
                meta.setLore(Arrays.asList("\u00a77" + this.translationManager.getMessage("market.gui.current-page", currentPage + 1, totalPages)));
                nextPage.setItemMeta(meta);
            }
            gui.setItem(53, nextPage);
        }
        if ((infoMeta = (info = new ItemStack(Material.BOOK)).getItemMeta()) != null) {
            infoMeta.setDisplayName("\u00a76" + this.translationManager.getMessage("market.gui.info.title", new Object[0]));
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77" + this.translationManager.getMessage("market.gui.info.items", totalItems));
            lore.add("\u00a77" + this.translationManager.getMessage("market.gui.info.page", currentPage + 1, totalPages));
            try {
                Player player = inv.getPlayer();
                CtxFactors ctx = this.computeContextualBonuses(player, inv.getSelectedCategory());
                lore.add("");
                lore.add("\u00a7b" + this.translationManager.getMessage("market.gui.info.role-bonus", this.formatPercent(ctx.roleBuy), this.formatPercent(ctx.roleSell)));
                if (inv.getSelectedCategory() != null && !"ALL".equals(inv.getSelectedCategory())) {
                    lore.add("\u00a79" + this.translationManager.getMessage("market.gui.info.category-bonus", inv.getSelectedCategory(), this.formatPercent(ctx.catBuy), this.formatPercent(ctx.catSell)));
                }
                if (ctx.eventBuy != 1.0 || ctx.eventSell != 1.0) {
                    lore.add("\u00a7d" + this.translationManager.getMessage("market.gui.info.event-bonus", this.formatPercent(ctx.eventBuy), this.formatPercent(ctx.eventSell)));
                }
            }
            catch (Exception player) {
                // empty catch block
            }
            lore.add("");
            lore.add("\u00a77" + this.translationManager.getMessage("market.gui.info.sort-label", inv.getSortMode().display(this.translationManager), new Object[0]));
            lore.add("\u00a77" + this.translationManager.getMessage("market.gui.info.sort-help", new Object[0]));
            lore.add("");
            lore.add("\u00a7e" + this.translationManager.getMessage("market.gui.info.help1", new Object[0]));
            lore.add("\u00a7e" + this.translationManager.getMessage("market.gui.info.help2", new Object[0]));
            lore.add("\u00a7e" + this.translationManager.getMessage("market.gui.info.help3", new Object[0]));
            infoMeta.setLore(lore);
            info.setItemMeta(infoMeta);
        }
        gui.setItem(49, info);
        ItemStack close = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = close.getItemMeta();
        if (closeMeta != null) {
            closeMeta.setDisplayName("\u00a7c" + this.translationManager.getMessage("market.gui.close", new Object[0]));
            close.setItemMeta(closeMeta);
        }
        gui.setItem(50, close);
        ItemStack catBtn = new ItemStack(Material.CHEST);
        ItemMeta catMeta = catBtn.getItemMeta();
        if (catMeta != null) {
            String cat = inv.getSelectedCategory();
            if (cat == null) {
                cat = "ALL";
            }
            catMeta.setDisplayName("\u00a7b" + this.translationManager.getMessage("market.gui.info.category-label", cat, new Object[0]));
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)("\u00a77" + this.translationManager.getMessage("market.gui.info.category-help", new Object[0]))));
            catMeta.setLore(lore);
            catBtn.setItemMeta(catMeta);
        }
        gui.setItem(46, catBtn);
        ItemStack letterBtn = new ItemStack(Material.NAME_TAG);
        ItemMeta letterMeta = letterBtn.getItemMeta();
        if (letterMeta != null) {
            String label = inv.getFilterLetter() == null ? "ALL" : inv.getFilterLetter().toString();
            letterMeta.setDisplayName("\u00a7b" + this.translationManager.getMessage("market.gui.info.letter-label", label, new Object[0]));
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)("\u00a77" + this.translationManager.getMessage("market.gui.info.letter-help", new Object[0]))));
            letterMeta.setLore(lore);
            letterBtn.setItemMeta(letterMeta);
        }
        gui.setItem(47, letterBtn);
        ItemStack clearFilters = new ItemStack(Material.BARRIER);
        ItemMeta clearMeta = clearFilters.getItemMeta();
        if (clearMeta != null) {
            clearMeta.setDisplayName("\u00a7c" + this.translationManager.getMessage("market.gui.info.clear-filters-label", new Object[0]));
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)("\u00a77" + this.translationManager.getMessage("market.gui.info.clear-filters-help", new Object[0]))));
            clearMeta.setLore(lore);
            clearFilters.setItemMeta(clearMeta);
        }
        gui.setItem(48, clearFilters);
        ItemStack sellHand = new ItemStack(Material.GOLD_INGOT);
        ItemMeta sellMeta = sellHand.getItemMeta();
        if (sellMeta != null) {
            sellMeta.setDisplayName("\u00a76" + this.translationManager.getMessage("market.gui.info.sell-hand-label", new Object[0]));
            sellMeta.setLore(Arrays.asList("\u00a77" + this.translationManager.getMessage("market.gui.info.sell-hand.help1", new Object[0]), "\u00a77" + this.translationManager.getMessage("market.gui.info.sell-hand.help2", new Object[0])));
            sellHand.setItemMeta(sellMeta);
        }
        gui.setItem(51, sellHand);
        ItemStack ordersBtn = new ItemStack(Material.PAPER);
        ItemMeta ordersMeta = ordersBtn.getItemMeta();
        if (ordersMeta != null) {
            ordersMeta.setDisplayName("\u00a76" + this.translationManager.getMessage("market.gui.info.orders-button", new Object[0]));
            ordersMeta.setLore(Arrays.asList("\u00a77" + this.translationManager.getMessage("market.gui.info.orders-button-help", new Object[0])));
            ordersBtn.setItemMeta(ordersMeta);
        }
        gui.setItem(52, ordersBtn);
    }

    private CtxFactors computeContextualBonuses(Player player, String selectedCategory) {
        CtxFactors f = new CtxFactors();
        try {
            EconomicEventEngine events;
            ServiceRegistry sr = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry();
            ProfessionsManager pm = sr.getInstance(ProfessionsManager.class);
            Optional<ProfessionRole> roleOpt = pm.getRole(player.getUniqueId()).join();
            if (roleOpt.isEmpty()) {
                return f;
            }
            String role = roleOpt.get().name().toLowerCase();
            int level = pm.getLevel(player.getUniqueId()).join();
            FileConfiguration profCfg = this.configManager.getModuleConfig("professions");
            int maxLevel = profCfg.getInt("max_level", 5);
            level = Math.max(1, Math.min(level, maxLevel));
            double baseBuy = profCfg.getDouble("roles." + role + ".buy_factor", 1.0);
            double baseSell = profCfg.getDouble("roles." + role + ".sell_factor", 1.0);
            double perBuy = profCfg.getDouble("roles." + role + ".buy_bonus_per_level", 0.0);
            double perSell = profCfg.getDouble("roles." + role + ".sell_bonus_per_level", 0.0);
            f.roleBuy = this.clamp(baseBuy * (1.0 - perBuy * (double)(level - 1)));
            f.roleSell = this.clamp(baseSell * (1.0 + perSell * (double)(level - 1)));
            if (selectedCategory != null && !"ALL".equals(selectedCategory)) {
                f.catBuy = profCfg.getDouble("roles." + role + ".category_bonuses." + selectedCategory.toLowerCase() + ".buy_factor", 1.0);
                f.catSell = profCfg.getDouble("roles." + role + ".category_bonuses." + selectedCategory.toLowerCase() + ".sell_factor", 1.0);
            }
            if ((events = sr.getInstance(EconomicEventEngine.class)) != null) {
                double eb = 1.0;
                double es = 1.0;
                for (EconomicEvent ev : events.getActiveEvents().values()) {
                    eb *= profCfg.getDouble("roles." + role + ".event_bonuses." + ev.getType().name() + ".buy_factor", 1.0);
                    es *= profCfg.getDouble("roles." + role + ".event_bonuses." + ev.getType().name() + ".sell_factor", 1.0);
                }
                f.eventBuy = this.clamp(eb);
                f.eventSell = this.clamp(es);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    private String formatPercent(double factor) {
        double pct = (factor - 1.0) * 100.0;
        String sign = pct > 0.0 ? "+" : "";
        return String.format(Locale.US, "%s%.1f%%", sign, pct);
    }

    private double clamp(double v) {
        if (v < 0.5) {
            return 0.5;
        }
        if (v > 1.5) {
            return 1.5;
        }
        return v;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int itemIndex;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String listTitle = this.translationManager.getMessage("market.gui.list.title", new Object[0]);
        if (event.getView().getTitle().equals(listTitle)) {
            event.setCancelled(true);
            ListState st = this.listing.get(player.getUniqueId());
            if (st == null) {
                return;
            }
            int slot = event.getRawSlot();
            if (slot == 22) {
                this.listing.remove(player.getUniqueId());
                player.closeInventory();
                return;
            }
            if (slot == 16) {
                int have = this.marketManager.countItems(player, st.material);
                int qty = Math.max(1, Math.min(st.qty, have));
                this.orderService.createListing(player, st.material, qty, st.unitPrice, st.hours).thenAccept(msg -> player.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + msg));
                this.listing.remove(player.getUniqueId());
                player.closeInventory();
                return;
            }
            if (st.priceSlots.containsKey(slot)) {
                Integer pctVal = st.priceSlots.get(slot);
                if (pctVal != null && pctVal == Integer.MIN_VALUE) {
                    st.unitPrice = st.basePrice;
                } else {
                    int pct = pctVal != null ? pctVal : 0;
                    BigDecimal factor = BigDecimal.valueOf(1.0 + (double)pct / 100.0);
                    BigDecimal newPrice = st.unitPrice.multiply(factor).setScale(2, RoundingMode.HALF_UP);
                    double minFrac = 0.1;
                    double maxFrac = 10.0;
                    try {
                        FileConfiguration cfg = this.configManager.getModuleConfig("market");
                        minFrac = cfg.getDouble("orders.listing.price_bounds_min_base_fraction", 0.1);
                        maxFrac = cfg.getDouble("orders.listing.price_bounds_max_base_fraction", 10.0);
                    }
                    catch (Exception cfg) {
                        // empty catch block
                    }
                    BigDecimal min = st.basePrice.multiply(new BigDecimal(String.valueOf(minFrac))).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal max = st.basePrice.multiply(new BigDecimal(String.valueOf(maxFrac))).setScale(2, RoundingMode.HALF_UP);
                    if (newPrice.compareTo(new BigDecimal("0.01")) < 0) {
                        newPrice = new BigDecimal("0.01");
                    }
                    if (newPrice.compareTo(min) < 0) {
                        newPrice = min;
                    }
                    if (newPrice.compareTo(max) > 0) {
                        newPrice = max;
                    }
                    st.unitPrice = newPrice;
                }
                event.getView().getTopInventory().setContents(this.buildListInventory(player, st).getContents());
                return;
            }
            if (st.absSlots.containsKey(slot)) {
                BigDecimal delta = st.absSlots.get(slot);
                BigDecimal newPrice = st.unitPrice.add(delta).setScale(2, RoundingMode.HALF_UP);
                double minFrac = 0.1;
                double maxFrac = 10.0;
                try {
                    FileConfiguration cfg = this.configManager.getModuleConfig("market");
                    minFrac = cfg.getDouble("orders.listing.price_bounds_min_base_fraction", 0.1);
                    maxFrac = cfg.getDouble("orders.listing.price_bounds_max_base_fraction", 10.0);
                }
                catch (Exception cfg) {
                    // empty catch block
                }
                BigDecimal min = st.basePrice.multiply(new BigDecimal(String.valueOf(minFrac))).setScale(2, RoundingMode.HALF_UP);
                BigDecimal max = st.basePrice.multiply(new BigDecimal(String.valueOf(maxFrac))).setScale(2, RoundingMode.HALF_UP);
                if (newPrice.compareTo(new BigDecimal("0.01")) < 0) {
                    newPrice = new BigDecimal("0.01");
                }
                if (newPrice.compareTo(min) < 0) {
                    newPrice = min;
                }
                if (newPrice.compareTo(max) > 0) {
                    newPrice = max;
                }
                st.unitPrice = newPrice;
                event.getView().getTopInventory().setContents(this.buildListInventory(player, st).getContents());
                return;
            }
            if (slot >= 10 && slot <= 14) {
                int chosen;
                switch (slot) {
                    case 10: {
                        int n = 1;
                        break;
                    }
                    case 11: {
                        int n = 8;
                        break;
                    }
                    case 12: {
                        int n = 16;
                        break;
                    }
                    case 13: {
                        int n = 32;
                        break;
                    }
                    case 14: {
                        int n = 64;
                        break;
                    }
                    default: {
                        int n = chosen = -1;
                    }
                }
                if (chosen > 0) {
                    st.qty = chosen;
                }
                event.getView().getTopInventory().setContents(this.buildListInventory(player, st).getContents());
                return;
            }
            if (st.durationSlots.containsKey(slot)) {
                st.hours = st.durationSlots.get(slot);
                event.getView().getTopInventory().setContents(this.buildListInventory(player, st).getContents());
                return;
            }
            return;
        }
        MarketInventory marketInv = this.openGUIs.get(player.getUniqueId());
        if (marketInv == null) {
            return;
        }
        String sellTitle = this.translationManager.getMessage("market.gui.sell-hand.title", new Object[0]);
        if (event.getView().getTitle().equals(sellTitle)) {
            int idx;
            event.setCancelled(true);
            int slot = event.getSlot();
            switch (slot) {
                case 10: {
                    int n = 0;
                    break;
                }
                case 11: {
                    int n = 1;
                    break;
                }
                case 12: {
                    int n = 2;
                    break;
                }
                case 13: {
                    int n = 3;
                    break;
                }
                default: {
                    int n = idx = -1;
                }
            }
            if (idx == -1) {
                return;
            }
            List<BigDecimal> amounts = Arrays.asList(new BigDecimal("100"), new BigDecimal("500"), new BigDecimal("1000"), new BigDecimal("5000"));
            BigDecimal target = amounts.get(idx);
            ItemStack inHand = player.getInventory().getItemInMainHand();
            Material mat = inHand.getType();
            this.marketManager.getItem(mat).whenComplete((opt, thr) -> {
                if (thr != null || opt.isEmpty() || !((MarketItem)opt.get()).isSellable()) {
                    player.sendMessage(this.translationManager.getMessage("market.item-not-sellable", new Object[0]));
                    return;
                }
                this.marketManager.getSellPrice(mat).whenComplete((price, t2) -> {
                    int inHandCount;
                    if (t2 != null || price == null || price.signum() <= 0) {
                        player.sendMessage(this.translationManager.getMessage("market.system-error", new Object[0]));
                        return;
                    }
                    int qty = target.divide((BigDecimal)price, 0, RoundingMode.DOWN).intValue();
                    if (qty < 1) {
                        qty = 1;
                    }
                    if ((qty = Math.min(qty, inHandCount = inHand.getAmount())) <= 0) {
                        player.sendMessage(this.translationManager.getMessage("market.no-items-to-sell", mat.name().toLowerCase(), new Object[0]));
                        return;
                    }
                    int sellQty = qty;
                    this.marketManager.sellItem(player, mat, sellQty).whenComplete((result, t3) -> {
                        if (t3 != null) {
                            this.logger.log(Level.SEVERE, "Error in GUI sell-hand transaction", (Throwable)t3);
                            player.sendMessage(this.translationManager.getMessage("market.system-error", new Object[0]));
                            return;
                        }
                        player.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + result.getMessage());
                        Bukkit.getScheduler().runTask(player.getServer().getPluginManager().getPlugin("EcoXpert"), () -> ((Player)player).closeInventory());
                    });
                });
            });
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        if (slot == 45 && marketInv.getCurrentPage() > 0) {
            marketInv.setCurrentPage(marketInv.getCurrentPage() - 1);
            this.updateGUI(player, marketInv);
            return;
        }
        if (slot == 53) {
            int totalPages = (int)Math.ceil((double)marketInv.getItems().size() / 45.0);
            if (marketInv.getCurrentPage() < totalPages - 1) {
                marketInv.setCurrentPage(marketInv.getCurrentPage() + 1);
                this.updateGUI(player, marketInv);
            }
            return;
        }
        if (slot == 50) {
            player.closeInventory();
            return;
        }
        if (slot == 46) {
            String current = marketInv.getSelectedCategory();
            int idx = this.categoryOrder.indexOf(current == null ? "ALL" : current);
            idx = (idx + 1) % this.categoryOrder.size();
            marketInv.setSelectedCategory(this.categoryOrder.get(idx));
            marketInv.setCurrentPage(0);
            this.updateGUI(player, marketInv);
            return;
        }
        if (slot == 47) {
            Character c = marketInv.getFilterLetter();
            if (c == null) {
                marketInv.setFilterLetter(Character.valueOf('A'));
            } else if (c.charValue() == 'Z') {
                marketInv.setFilterLetter(null);
            } else {
                marketInv.setFilterLetter(Character.valueOf((char)(c.charValue() + '\u0001')));
            }
            marketInv.setCurrentPage(0);
            this.updateGUI(player, marketInv);
            return;
        }
        if (slot == 51) {
            this.openSellHandGUI(player);
            return;
        }
        if (slot == 52) {
            player.performCommand("market orders");
            return;
        }
        if (slot == 48) {
            marketInv.setSelectedCategory("ALL");
            marketInv.setFilterLetter(null);
            marketInv.setCurrentPage(0);
            this.updateGUI(player, marketInv);
            return;
        }
        if (slot < 45 && (itemIndex = marketInv.getCurrentPage() * 45 + slot) < marketInv.getItems().size()) {
            MarketItem item = marketInv.getItems().get(itemIndex);
            if (event.isRightClick()) {
                if (!player.hasPermission("ecoxpert.market.list")) {
                    player.sendMessage(this.translationManager.getMessage("no-permission", new Object[0]));
                    return;
                }
                this.openListGUI(player, item);
            } else {
                this.handleItemClick(player, item, event.isShiftClick());
            }
        }
        if (slot == 49) {
            marketInv.cycleSort();
            this.updateGUI(player, marketInv);
            return;
        }
    }

    private void handleItemClick(Player player, MarketItem item, boolean isShiftClick) {
        if (isShiftClick) {
            if (!item.isSellable()) {
                player.sendMessage(this.translationManager.getMessage("market.item-not-sellable", new Object[0]));
                return;
            }
            int quantity = this.marketManager.countItems(player, item.getMaterial());
            if (quantity <= 0) {
                player.sendMessage(this.translationManager.getMessage("market.no-items-to-sell", item.getMaterial().name().toLowerCase().replace('_', ' '), new Object[0]));
                return;
            }
            this.marketManager.sellItem(player, item.getMaterial(), quantity).whenComplete((result, throwable) -> {
                if (throwable != null) {
                    this.logger.log(Level.SEVERE, "Error in GUI sell transaction", (Throwable)throwable);
                    player.sendMessage(this.translationManager.getMessage("market.system-error", new Object[0]));
                    return;
                }
                player.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + result.getMessage());
            });
        } else {
            if (!item.isBuyable()) {
                player.sendMessage(this.translationManager.getMessage("market.item-not-buyable", new Object[0]));
                return;
            }
            this.marketManager.buyItem(player, item.getMaterial(), 1).whenComplete((result, throwable) -> {
                if (throwable != null) {
                    this.logger.log(Level.SEVERE, "Error in GUI buy transaction", (Throwable)throwable);
                    player.sendMessage(this.translationManager.getMessage("market.system-error", new Object[0]));
                    return;
                }
                player.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + result.getMessage());
            });
        }
        player.closeInventory();
    }

    private void openListGUI(Player player, MarketItem item) {
        int have = this.marketManager.countItems(player, item.getMaterial());
        if (have <= 0) {
            player.sendMessage(this.translationManager.getMessage("market.no-items-to-sell", item.getMaterial().name().toLowerCase(), new Object[0]));
            return;
        }
        BigDecimal base = item.getCurrentSellPrice();
        ListState st = new ListState(item.getMaterial(), Math.min(16, have), 24, base);
        this.listing.put(player.getUniqueId(), st);
        player.openInventory(this.buildListInventory(player, st));
    }

    private Inventory buildListInventory(Player player, ListState st) {
        ItemStack head;
        ItemMeta hm;
        int have = this.marketManager.countItems(player, st.material);
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)this.translationManager.getMessage("market.gui.list.title", new Object[0]));
        st.priceSlots.clear();
        List presets = List.of(Integer.valueOf(-10), Integer.valueOf(-5), Integer.valueOf(-1), Integer.valueOf(1), Integer.valueOf(5), Integer.valueOf(10));
        try {
            FileConfiguration cfg = this.configManager.getModuleConfig("market");
            List conf = cfg.getIntegerList("orders.listing.price_adjust_presets_percent");
            if (conf != null && !conf.isEmpty()) {
                presets = conf;
            }
        }
        catch (Exception cfg) {
            // empty catch block
        }
        int[] presetSlots = new int[]{1, 2, 3, 5, 6, 7};
        for (int i = 0; i < Math.min(presets.size(), presetSlots.length); ++i) {
            int pct = (Integer)presets.get(i);
            int slot = presetSlots[i];
            gui.setItem(slot, this.priceButton(pct > 0, Math.abs(pct)));
            st.priceSlots.put(slot, pct);
        }
        gui.setItem(8, this.resetPriceButton());
        st.priceSlots.put(8, Integer.MIN_VALUE);
        try {
            FileConfiguration cfg = this.configManager.getModuleConfig("market");
            List absList = cfg.getIntegerList("orders.listing.price_adjust_presets_absolute");
            if (absList != null && !absList.isEmpty()) {
                int[] absSlots = new int[]{0, 9, 15, 17};
                int k = Math.min(absList.size(), absSlots.length);
                for (int i = 0; i < k; ++i) {
                    int val = (Integer)absList.get(i);
                    BigDecimal delta = new BigDecimal(val);
                    int slot = absSlots[i];
                    gui.setItem(slot, this.absButton(val >= 0, delta));
                    st.absSlots.put(slot, delta);
                }
            }
        }
        catch (Exception cfg) {
            // empty catch block
        }
        if ((hm = (head = new ItemStack(st.material)).getItemMeta()) != null) {
            hm.setDisplayName("\u00a7e" + this.translationManager.getMessage("market.gui.list.header", st.material.name(), new Object[0]));
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)("\u00a77" + this.translationManager.getMessage("market.gui.list.unit_price", this.formatPrice(st.unitPrice), new Object[0]))));
            try {
                FileConfiguration cfg = this.configManager.getModuleConfig("market");
                double minFrac = cfg.getDouble("orders.listing.price_bounds_min_base_fraction", 0.1);
                double maxFrac = cfg.getDouble("orders.listing.price_bounds_max_base_fraction", 10.0);
                BigDecimal min = st.basePrice.multiply(new BigDecimal(String.valueOf(minFrac))).setScale(2, RoundingMode.HALF_UP);
                BigDecimal max = st.basePrice.multiply(new BigDecimal(String.valueOf(maxFrac))).setScale(2, RoundingMode.HALF_UP);
                lore.add((CallSite)((Object)("\u00a77" + this.translationManager.getMessage("market.gui.info.range", this.formatPrice(min), this.formatPrice(max)))));
            }
            catch (Exception cfg) {
                // empty catch block
            }
            hm.setLore(lore);
            head.setItemMeta(hm);
        }
        gui.setItem(4, head);
        gui.setItem(10, this.listQtyItem(1));
        gui.setItem(11, this.listQtyItem(8));
        gui.setItem(12, this.listQtyItem(16));
        gui.setItem(13, this.listQtyItem(32));
        gui.setItem(14, this.listQtyItem(Math.min(64, have)));
        st.durationSlots.clear();
        List hours = List.of(Integer.valueOf(12), Integer.valueOf(24), Integer.valueOf(48));
        try {
            FileConfiguration cfg = this.configManager.getModuleConfig("market");
            List conf = cfg.getIntegerList("orders.listing.duration_hours_options");
            if (conf != null && !conf.isEmpty()) {
                hours = conf;
            }
        }
        catch (Exception cfg) {
            // empty catch block
        }
        int startSlot = 19;
        for (int i = 0; i < Math.min(hours.size(), 5); ++i) {
            int h = hours.get(i);
            int slot = startSlot + i;
            gui.setItem(slot, this.durationItem(h));
            st.durationSlots.put(slot, h);
        }
        ItemStack confirm = new ItemStack(Material.LIME_DYE);
        ItemMeta cm = confirm.getItemMeta();
        if (cm != null) {
            cm.setDisplayName("\u00a7a" + this.translationManager.getMessage("market.gui.list.confirm", new Object[0]));
            confirm.setItemMeta(cm);
        }
        gui.setItem(16, confirm);
        ItemStack cancel = new ItemStack(Material.BARRIER);
        ItemMeta ccm = cancel.getItemMeta();
        if (ccm != null) {
            ccm.setDisplayName("\u00a7c" + this.translationManager.getMessage("market.gui.list.cancel", new Object[0]));
            cancel.setItemMeta(ccm);
        }
        gui.setItem(22, cancel);
        return gui;
    }

    private ItemStack priceButton(boolean plus, int pct) {
        ItemStack it = new ItemStack(plus ? Material.EMERALD : Material.REDSTONE);
        ItemMeta im = it.getItemMeta();
        if (im != null) {
            String key = plus ? "market.gui.list.price.plus" : "market.gui.list.price.minus";
            im.setDisplayName((plus ? "\u00a7a" : "\u00a7c") + this.translationManager.getMessage(key, pct));
            it.setItemMeta(im);
        }
        return it;
    }

    private ItemStack absButton(boolean plus, BigDecimal amount) {
        ItemStack it = new ItemStack(plus ? Material.LIME_DYE : Material.RED_DYE);
        ItemMeta im = it.getItemMeta();
        if (im != null) {
            String key = plus ? "market.gui.list.price.plus_abs" : "market.gui.list.price.minus_abs";
            im.setDisplayName((plus ? "\u00a7a" : "\u00a7c") + this.translationManager.getMessage(key, this.formatPrice(amount), new Object[0]));
            it.setItemMeta(im);
        }
        return it;
    }

    private ItemStack resetPriceButton() {
        ItemStack it = new ItemStack(Material.SUNFLOWER);
        ItemMeta im = it.getItemMeta();
        if (im != null) {
            im.setDisplayName("\u00a7e" + this.translationManager.getMessage("market.gui.list.price.reset", new Object[0]));
            it.setItemMeta(im);
        }
        return it;
    }

    private ItemStack listQtyItem(int qty) {
        ItemStack it = new ItemStack(Material.CHEST, Math.max(1, Math.min(64, qty)));
        ItemMeta im = it.getItemMeta();
        if (im != null) {
            im.setDisplayName("\u00a76" + this.translationManager.getMessage("market.gui.list.qty.select", qty));
            it.setItemMeta(im);
        }
        return it;
    }

    private ItemStack durationItem(int h) {
        ItemStack it = new ItemStack(Material.CLOCK);
        ItemMeta im = it.getItemMeta();
        if (im != null) {
            im.setDisplayName("\u00a7b" + this.translationManager.getMessage("market.gui.list.duration", h));
            it.setItemMeta(im);
        }
        return it;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            this.openGUIs.remove(player.getUniqueId());
        }
    }

    private void updateGUI(Player player, MarketInventory marketInv) {
        Inventory newGui = this.createMarketPage(marketInv);
        player.getOpenInventory().getTopInventory().setContents(newGui.getContents());
    }

    private void openSellHandGUI(Player player) {
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            player.sendMessage(this.translationManager.getMessage("market.no-items-to-sell", "hand", new Object[0]));
            return;
        }
        String title = this.translationManager.getMessage("market.gui.sell-hand.title", new Object[0]);
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)title);
        List<BigDecimal> amounts = Arrays.asList(new BigDecimal("100"), new BigDecimal("500"), new BigDecimal("1000"), new BigDecimal("5000"));
        int[] slots = new int[]{10, 11, 12, 13};
        for (int i = 0; i < amounts.size(); ++i) {
            ItemStack it = new ItemStack(Material.GOLD_NUGGET);
            ItemMeta meta = it.getItemMeta();
            if (meta != null) {
                meta.setDisplayName("\u00a76" + this.translationManager.getMessage("market.gui.sell-hand.amount", this.formatPrice(amounts.get(i)), new Object[0]));
                meta.setLore(Arrays.asList("\u00a77" + this.translationManager.getMessage("market.gui.sell-hand.lore1", new Object[0]), "\u00a77" + this.translationManager.getMessage("market.gui.sell-hand.lore2", new Object[0])));
                it.setItemMeta(meta);
            }
            gui.setItem(slots[i], it);
        }
        ItemStack close = new ItemStack(Material.BARRIER);
        ItemMeta cmeta = close.getItemMeta();
        if (cmeta != null) {
            cmeta.setDisplayName("\u00a7c" + this.translationManager.getMessage("market.gui.close", new Object[0]));
            close.setItemMeta(cmeta);
        }
        gui.setItem(22, close);
        player.openInventory(gui);
    }

    private String getTrendColor(MarketTrend.TrendDirection direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case MarketTrend.TrendDirection.STRONG_UPWARD, MarketTrend.TrendDirection.UPWARD -> "\u00a7a";
            case MarketTrend.TrendDirection.STRONG_DOWNWARD, MarketTrend.TrendDirection.DOWNWARD -> "\u00a7c";
            case MarketTrend.TrendDirection.VOLATILE -> "\u00a76";
            case MarketTrend.TrendDirection.STABLE -> "\u00a77";
        };
    }

    private String formatPrice(BigDecimal price) {
        return "$" + price.setScale(2, 4).toString();
    }

    private String capitalizeWords(String str) {
        String[] words = str.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return result.toString().trim();
    }

    public void closeAllGUIs() {
        for (UUID playerId : this.openGUIs.keySet()) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null) continue;
            player.closeInventory();
        }
        this.openGUIs.clear();
    }

    private static class MarketInventory {
        private final Player player;
        private final List<MarketItem> items;
        private int currentPage;
        private String selectedCategory = "ALL";
        private Character filterLetter = null;
        private SortMode sortMode = SortMode.NAME;

        public MarketInventory(Player player, List<MarketItem> items, int currentPage) {
            this.player = player;
            this.items = items;
            this.currentPage = currentPage;
        }

        public Player getPlayer() {
            return this.player;
        }

        public List<MarketItem> getItems() {
            return this.items;
        }

        public int getCurrentPage() {
            return this.currentPage;
        }

        public void setCurrentPage(int page) {
            this.currentPage = page;
        }

        public String getSelectedCategory() {
            return this.selectedCategory;
        }

        public void setSelectedCategory(String cat) {
            this.selectedCategory = cat;
        }

        public Character getFilterLetter() {
            return this.filterLetter;
        }

        public void setFilterLetter(Character c) {
            this.filterLetter = c;
        }

        public SortMode getSortMode() {
            return this.sortMode;
        }

        public void cycleSort() {
            this.sortMode = this.sortMode.next();
        }
    }

    private static enum SortMode {
        NAME,
        BUY_ASC,
        SELL_ASC,
        SELL_DESC,
        VOLUME_ASC,
        VOLUME_DESC;


        public SortMode next() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NAME -> BUY_ASC;
                case BUY_ASC -> SELL_ASC;
                case SELL_ASC -> SELL_DESC;
                case SELL_DESC -> VOLUME_ASC;
                case VOLUME_ASC -> VOLUME_DESC;
                case VOLUME_DESC -> NAME;
            };
        }

        public String display(TranslationManager tm) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NAME -> tm.getMessage("market.gui.info.sort-mode.name", new Object[0]);
                case BUY_ASC -> tm.getMessage("market.gui.info.sort-mode.buy-asc", new Object[0]);
                case SELL_ASC -> tm.getMessage("market.gui.info.sort-mode.sell-asc", new Object[0]);
                case SELL_DESC -> tm.getMessage("market.gui.info.sort-mode.sell-desc", new Object[0]);
                case VOLUME_ASC -> tm.getMessage("market.gui.info.sort-mode.volume-asc", new Object[0]);
                case VOLUME_DESC -> tm.getMessage("market.gui.info.sort-mode.volume-desc", new Object[0]);
            };
        }
    }

    private static class CtxFactors {
        double roleBuy = 1.0;
        double roleSell = 1.0;
        double catBuy = 1.0;
        double catSell = 1.0;
        double eventBuy = 1.0;
        double eventSell = 1.0;

        private CtxFactors() {
        }
    }

    private static class ListState {
        final Material material;
        int qty;
        int hours;
        BigDecimal unitPrice;
        BigDecimal basePrice;
        final Map<Integer, Integer> priceSlots = new HashMap<Integer, Integer>();
        final Map<Integer, Integer> durationSlots = new HashMap<Integer, Integer>();
        final Map<Integer, BigDecimal> absSlots = new HashMap<Integer, BigDecimal>();

        ListState(Material m, int q, int h, BigDecimal p) {
            this.material = m;
            this.qty = q;
            this.hours = h;
            this.unitPrice = p;
            this.basePrice = p;
        }
    }
}

