/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.market;

import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.api.events.MarketPriceChangeEvent;
import me.koyere.ecoxpert.core.ServiceRegistry;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.data.QueryResult;
import me.koyere.ecoxpert.core.safety.SafeModeManager;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.events.EconomicEvent;
import me.koyere.ecoxpert.modules.events.EconomicEventEngine;
import me.koyere.ecoxpert.modules.integrations.IntegrationsManager;
import me.koyere.ecoxpert.modules.market.MarketItem;
import me.koyere.ecoxpert.modules.market.MarketItemStats;
import me.koyere.ecoxpert.modules.market.MarketManager;
import me.koyere.ecoxpert.modules.market.MarketPriceHistory;
import me.koyere.ecoxpert.modules.market.MarketStatistics;
import me.koyere.ecoxpert.modules.market.MarketTransaction;
import me.koyere.ecoxpert.modules.market.MarketTransactionResult;
import me.koyere.ecoxpert.modules.market.MarketTrend;
import me.koyere.ecoxpert.modules.market.PriceCalculator;
import me.koyere.ecoxpert.modules.professions.ProfessionRole;
import me.koyere.ecoxpert.modules.professions.ProfessionsManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MarketManagerImpl
implements MarketManager {
    private final EcoXpertPlugin plugin;
    private final DataManager dataManager;
    private final EconomyManager economyManager;
    private final TranslationManager translationManager;
    private final ConfigManager configManager;
    private ProfessionsManager professionsManager;
    private final PriceCalculator priceCalculator;
    private volatile double buyPriceFactor = 1.0;
    private volatile double sellPriceFactor = 1.0;
    private final Map<Material, ItemFactor> itemFactors = new ConcurrentHashMap<Material, ItemFactor>();
    private final Map<Material, MarketItem> itemCache = new ConcurrentHashMap<Material, MarketItem>();
    private final ScheduledExecutorService priceUpdateScheduler;
    private boolean marketOpen = true;
    private volatile boolean initialized = false;
    private final ConcurrentHashMap<Material, AtomicInteger> sellWindowCounts = new ConcurrentHashMap();
    private final ConcurrentHashMap<Material, Long> slimeFlaggedUntil = new ConcurrentHashMap();
    private static final int PRICE_UPDATE_INTERVAL_MINUTES = 5;
    private static final int CACHE_REFRESH_INTERVAL_MINUTES = 10;
    private static final int MAX_TRANSACTION_HISTORY = 1000;
    private final Set<String> seenBuckets = Collections.newSetFromMap(new ConcurrentHashMap());

    public MarketManagerImpl(EcoXpertPlugin plugin, DataManager dataManager, EconomyManager economyManager, TranslationManager translationManager, ConfigManager configManager) {
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.economyManager = economyManager;
        this.translationManager = translationManager;
        this.configManager = configManager;
        this.priceCalculator = new PriceCalculator();
        this.priceUpdateScheduler = Executors.newScheduledThreadPool(2, r -> {
            Thread thread = new Thread(r, "EcoXpert-Market-" + Thread.currentThread().getId());
            thread.setDaemon(true);
            return thread;
        });
    }

    @Override
    public void initialize() {
        this.plugin.getLogger().info("Initializing Market System...");
        try {
            this.loadPricingConfig();
            this.loadItemsIntoCache();
            try {
                boolean seedOnEmpty = this.configManager.getConfig().getBoolean("modules.market.seed-on-empty", true);
                if (seedOnEmpty && this.itemCache.isEmpty()) {
                    this.seedDefaultMarketItems();
                    this.loadItemsIntoCache();
                }
            }
            catch (Exception seedOnEmpty) {
                // empty catch block
            }
            this.schedulePriceUpdates();
            this.scheduleCacheRefresh();
            this.initialized = true;
            this.plugin.getLogger().info("Market System initialized successfully");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize Market System", e);
            throw new RuntimeException("Market System initialization failed", e);
        }
    }

    @Override
    public void shutdown() {
        if (this.initialized) {
            this.plugin.getLogger().info("Shutting down Market System...");
            try {
                this.priceUpdateScheduler.shutdown();
                if (!this.priceUpdateScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.priceUpdateScheduler.shutdownNow();
                }
                this.itemCache.clear();
                this.initialized = false;
                this.plugin.getLogger().info("Market System shutdown complete");
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error during Market System shutdown", e);
            }
        }
    }

    @Override
    public boolean isMarketOpen() {
        return this.marketOpen && this.initialized;
    }

    @Override
    public void setMarketOpen(boolean open) {
        this.marketOpen = open;
        this.plugin.getLogger().info("Market is now " + (open ? "open" : "closed"));
    }

    @Override
    public void setGlobalPriceFactors(double buyFactor, double sellFactor) {
        this.buyPriceFactor = Math.max(0.5, Math.min(1.5, buyFactor));
        this.sellPriceFactor = Math.max(0.5, Math.min(1.5, sellFactor));
        this.plugin.getLogger().info("Market global price factors set: buy=" + this.buyPriceFactor + ", sell=" + this.sellPriceFactor);
    }

    @Override
    public double[] getGlobalPriceFactors() {
        return new double[]{this.buyPriceFactor, this.sellPriceFactor};
    }

    @Override
    public void applyTemporaryItemFactors(Map<Material, double[]> factors, int minutes) {
        long expires = System.currentTimeMillis() + (long)minutes * 60000L;
        for (Map.Entry<Material, double[]> e : factors.entrySet()) {
            double[] f = e.getValue();
            double buy = Math.max(0.5, Math.min(1.5, f[0]));
            double sell = Math.max(0.5, Math.min(1.5, f[1]));
            this.itemFactors.put(e.getKey(), new ItemFactor(buy, sell, expires));
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.itemFactors.entrySet().removeIf(en -> ((ItemFactor)en.getValue()).expired()), 1200L * (long)Math.max(1, minutes));
    }

    @Override
    public CompletableFuture<List<MarketItem>> getAllItems() {
        return CompletableFuture.supplyAsync(() -> {
            if (!this.itemCache.isEmpty()) {
                return new ArrayList<MarketItem>(this.itemCache.values());
            }
            return this.loadItemsFromDatabase();
        });
    }

    @Override
    public CompletableFuture<Optional<MarketItem>> getItem(Material material) {
        return CompletableFuture.supplyAsync(() -> {
            MarketItem cachedItem = this.itemCache.get(material);
            if (cachedItem != null) {
                return Optional.of(cachedItem);
            }
            return this.loadItemFromDatabase(material);
        });
    }

    @Override
    public CompletableFuture<Void> addItem(Material material, BigDecimal basePrice, boolean buyable, boolean sellable) {
        return CompletableFuture.runAsync(() -> {
            try {
                String sql = "INSERT OR REPLACE INTO ecoxpert_market_items\n(material, base_price, current_buy_price, current_sell_price, buyable, sellable, updated_at)\nVALUES (?, ?, ?, ?, ?, ?, ?)\n";
                BigDecimal sellPrice = basePrice.multiply(BigDecimal.valueOf(0.8));
                this.dataManager.executeUpdate(sql, material.name(), basePrice, basePrice, sellPrice, buyable, sellable, Timestamp.valueOf(LocalDateTime.now())).join();
                MarketItem newItem = MarketItem.builder(material, basePrice).currentBuyPrice(basePrice).currentSellPrice(sellPrice).buyable(buyable).sellable(sellable).build();
                this.itemCache.put(material, newItem);
                this.plugin.getLogger().info("Added market item: " + material.name());
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to add market item: " + material.name(), e);
                throw new RuntimeException("Failed to add market item", e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> removeItem(Material material) {
        return CompletableFuture.runAsync(() -> {
            try {
                String sql = "DELETE FROM ecoxpert_market_items WHERE material = ?";
                this.dataManager.executeUpdate(sql, material.name()).join();
                this.itemCache.remove(material);
                this.plugin.getLogger().info("Removed market item: " + material.name());
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to remove market item: " + material.name(), e);
                throw new RuntimeException("Failed to remove market item", e);
            }
        });
    }

    @Override
    public CompletableFuture<BigDecimal> getBuyPrice(Material material) {
        return this.getItem(material).thenApply(item -> item.map(MarketItem::getCurrentBuyPrice).orElse(BigDecimal.ZERO));
    }

    @Override
    public CompletableFuture<BigDecimal> getSellPrice(Material material) {
        return this.getItem(material).thenApply(item -> item.map(MarketItem::getCurrentSellPrice).orElse(BigDecimal.ZERO));
    }

    @Override
    public CompletableFuture<List<MarketPriceHistory>> getPriceHistory(Material material, int days) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT * FROM ecoxpert_market_price_history\nWHERE material = ? AND snapshot_time >= datetime('now', '-' || ? || ' days')\nORDER BY snapshot_time DESC\n";
            QueryResult result = this.dataManager.executeQuery(sql, material.name(), days).join();
            try {
                ArrayList<MarketPriceHistory> history = new ArrayList<MarketPriceHistory>();
                while (result.next()) {
                    history.add(new MarketPriceHistory(material, result.getBigDecimal("buy_price"), result.getBigDecimal("sell_price"), result.getTimestamp("snapshot_time").toLocalDateTime(), result.getInt("transaction_count"), result.getBigDecimal("volume")));
                }
                ArrayList<MarketPriceHistory> arrayList = history;
                if (result != null) {
                    result.close();
                }
                return arrayList;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to get price history for: " + material.name(), e);
                    return Collections.emptyList();
                }
            }
        });
    }

    @Override
    public CompletableFuture<Void> updatePrices() {
        return CompletableFuture.runAsync(() -> {
            try {
                SafeModeManager safe = this.plugin.getServiceRegistry().getInstance(SafeModeManager.class);
                if (safe != null && safe.isActive()) {
                    this.plugin.getLogger().info("Safe Mode active: skipping market price updates");
                    return;
                }
                this.loadPricingConfig();
                List<MarketTransaction> recentTransactions = this.getRecentTransactionsSync(100);
                for (MarketItem item : this.itemCache.values()) {
                    this.updateItemPrice(item, recentTransactions);
                }
                this.plugin.getLogger().info("Price update completed for " + this.itemCache.size() + " items");
            }
            catch (Exception e) {
                SafeModeManager safe = this.plugin.getServiceRegistry().getInstance(SafeModeManager.class);
                if (safe != null) {
                    safe.recordCriticalError();
                }
                this.plugin.getLogger().log(Level.SEVERE, "Failed to update market prices", e);
            }
        });
    }

    private void loadPricingConfig() {
        try {
            int trendHours;
            double damping;
            double maxChange;
            if (this.configManager.isSimpleMode()) {
                FileConfiguration root = this.configManager.getConfig();
                maxChange = root.getDouble("simple.market.max_price_change", 0.15);
                damping = root.getDouble("simple.market.volatility_damping", 0.9);
                trendHours = root.getInt("simple.market.trend_analysis_hours", 24);
            } else {
                FileConfiguration marketCfg = this.configManager.getModuleConfig("market");
                maxChange = marketCfg.getDouble("pricing.max_price_change", 0.2);
                damping = marketCfg.getDouble("pricing.volatility_damping", 0.85);
                trendHours = marketCfg.getInt("pricing.trend_analysis_hours", 24);
            }
            this.priceCalculator.configure(maxChange, damping, trendHours);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public CompletableFuture<MarketTransactionResult> buyItem(Player player, Material material, int quantity) {
        return CompletableFuture.supplyAsync(() -> {
            if (!this.isMarketOpen()) {
                return MarketTransactionResult.failure(MarketTransactionResult.TransactionError.MARKET_CLOSED, this.translationManager.getMessage("market.market-closed", new Object[0]));
            }
            try {
                Optional<MarketItem> itemOpt = this.getItem(material).join();
                if (itemOpt.isEmpty() || !itemOpt.get().isBuyable()) {
                    return MarketTransactionResult.failure(MarketTransactionResult.TransactionError.ITEM_NOT_BUYABLE, this.translationManager.getMessage("market.item-not-buyable", new Object[0]));
                }
                MarketItem item = itemOpt.get();
                BigDecimal unitPrice = item.getCurrentBuyPrice();
                BigDecimal totalCost = unitPrice.multiply(BigDecimal.valueOf(quantity));
                double profF = this.getProfessionFactor(player.getUniqueId(), material, true);
                double integF = this.getIntegrationsFactor(material, true);
                double terrF = this.getTerritoryFactor(player, material, true);
                double slimeF = this.getInflationaryMaterialFactor(material, true);
                if (!this.canAfford(player, totalCost = totalCost.multiply(BigDecimal.valueOf(profF)).multiply(BigDecimal.valueOf(integF)).multiply(BigDecimal.valueOf(terrF)).multiply(BigDecimal.valueOf(slimeF)).setScale(2, 4))) {
                    return MarketTransactionResult.failure(MarketTransactionResult.TransactionError.INSUFFICIENT_FUNDS, this.translationManager.getMessage("market.insufficient-funds", this.economyManager.formatMoney(totalCost), this.economyManager.formatMoney(this.economyManager.getBalance(player.getUniqueId()).join())));
                }
                ItemStack itemStack = new ItemStack(material, quantity);
                if (!this.addItemsToInventory(player, itemStack)) {
                    return MarketTransactionResult.failure(MarketTransactionResult.TransactionError.INVENTORY_FULL, this.translationManager.getMessage("market.inventory-full", new Object[0]));
                }
                return this.processTransaction(player, item, MarketTransaction.TransactionType.BUY, quantity, unitPrice, totalCost);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to process buy transaction", e);
                return MarketTransactionResult.failure("System error occurred");
            }
        });
    }

    @Override
    public CompletableFuture<MarketTransactionResult> sellItem(Player player, Material material, int quantity) {
        return CompletableFuture.supplyAsync(() -> {
            if (!this.isMarketOpen()) {
                return MarketTransactionResult.failure(MarketTransactionResult.TransactionError.MARKET_CLOSED, this.translationManager.getMessage("market.market-closed", new Object[0]));
            }
            try {
                Optional<MarketItem> itemOpt = this.getItem(material).join();
                if (itemOpt.isEmpty() || !itemOpt.get().isSellable()) {
                    return MarketTransactionResult.failure(MarketTransactionResult.TransactionError.ITEM_NOT_SELLABLE, this.translationManager.getMessage("market.item-not-sellable", new Object[0]));
                }
                MarketItem item = itemOpt.get();
                if (!this.hasItems(player, material, quantity)) {
                    return MarketTransactionResult.failure(MarketTransactionResult.TransactionError.INSUFFICIENT_ITEMS, this.translationManager.getMessage("market.not-enough-items", material.name(), new Object[0]));
                }
                BigDecimal unitPrice = item.getCurrentSellPrice();
                BigDecimal totalEarning = unitPrice.multiply(BigDecimal.valueOf(quantity));
                double profF = this.getProfessionFactor(player.getUniqueId(), material, false);
                double integF = this.getIntegrationsFactor(material, false);
                double terrF = this.getTerritoryFactor(player, material, false);
                double slimeF = this.getInflationaryMaterialFactor(material, false);
                totalEarning = totalEarning.multiply(BigDecimal.valueOf(profF)).multiply(BigDecimal.valueOf(integF)).multiply(BigDecimal.valueOf(terrF)).multiply(BigDecimal.valueOf(slimeF)).setScale(2, 4);
                if (!this.removeItemsFromInventory(player, material, quantity)) {
                    return MarketTransactionResult.failure(MarketTransactionResult.TransactionError.INSUFFICIENT_ITEMS, this.translationManager.getMessage("market.not-enough-items", material.name(), new Object[0]));
                }
                return this.processTransaction(player, item, MarketTransaction.TransactionType.SELL, quantity, unitPrice, totalEarning);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to process sell transaction", e);
                return MarketTransactionResult.failure("System error occurred");
            }
        });
    }

    @Override
    public CompletableFuture<List<MarketTransaction>> getPlayerTransactions(UUID playerUuid, int limit) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String sql = "SELECT * FROM ecoxpert_market_transactions\nWHERE player_uuid = ?\nORDER BY created_at DESC\nLIMIT ?\n";
                return this.loadTransactionsFromQuery(sql, playerUuid.toString(), limit);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to get player transactions", e);
                return Collections.emptyList();
            }
        });
    }

    @Override
    public CompletableFuture<List<MarketTransaction>> getRecentTransactions(int limit) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String sql = "SELECT * FROM ecoxpert_market_transactions\nORDER BY created_at DESC\nLIMIT ?\n";
                return this.loadTransactionsFromQuery(sql, limit);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to get recent transactions", e);
                return Collections.emptyList();
            }
        });
    }

    @Override
    public CompletableFuture<MarketStatistics> getMarketStatistics() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                int totalItems = this.itemCache.size();
                int activeItems = (int)this.itemCache.values().stream().filter(MarketItem::isActivelyTraded).count();
                String transactionSql = "SELECT\n    COUNT(*) as total_transactions,\n    COALESCE(SUM(total_amount), 0) as total_volume,\n    COALESCE(AVG(unit_price), 0) as avg_price,\n    COUNT(CASE WHEN created_at >= datetime('now', '-1 day') THEN 1 END) as daily_transactions,\n    COALESCE(SUM(CASE WHEN created_at >= datetime('now', '-1 day') THEN total_amount ELSE 0 END), 0) as daily_volume\nFROM ecoxpert_market_transactions\n";
                try (QueryResult result = this.dataManager.executeQuery(transactionSql, new Object[0]).join();){
                    if (!result.next()) return new MarketStatistics(totalItems, activeItems, 0L, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, LocalDateTime.now(), BigDecimal.ZERO, 0, 0.0);
                    long totalTransactions = result.getLong("total_transactions");
                    BigDecimal totalVolume = result.getBigDecimal("total_volume");
                    BigDecimal avgPrice = result.getBigDecimal("avg_price");
                    int dailyTransactions = result.getInt("daily_transactions");
                    BigDecimal dailyVolume = result.getBigDecimal("daily_volume");
                    double activity = Math.min(1.0, (double)dailyTransactions / 100.0);
                    BigDecimal marketCap = (totalVolume != null ? totalVolume : BigDecimal.ZERO).multiply(BigDecimal.valueOf(0.1));
                    MarketStatistics marketStatistics = new MarketStatistics(totalItems, activeItems, totalTransactions, totalVolume, avgPrice, marketCap, LocalDateTime.now(), dailyVolume, dailyTransactions, activity);
                    return marketStatistics;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to get market statistics", e);
                return new MarketStatistics(0, 0, 0L, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, LocalDateTime.now(), BigDecimal.ZERO, 0, 0.0);
            }
        });
    }

    @Override
    public CompletableFuture<List<MarketItemStats>> getTopTradedItems(int limit) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT\n    m.material,\n    m.total_sold,\n    m.total_bought,\n    COALESCE(SUM(CASE WHEN mt.transaction_type = 'sell' THEN mt.total_amount ELSE 0 END), 0) as sell_volume,\n    COALESCE(SUM(CASE WHEN mt.transaction_type = 'buy' THEN mt.total_amount ELSE 0 END), 0) as buy_volume,\n    COALESCE(AVG(CASE WHEN mt.transaction_type = 'sell' THEN mt.unit_price END), 0) as avg_sell_price,\n    COALESCE(AVG(CASE WHEN mt.transaction_type = 'buy' THEN mt.unit_price END), 0) as avg_buy_price\nFROM ecoxpert_market_items m\nLEFT JOIN ecoxpert_market_transactions mt ON m.material = mt.material\nGROUP BY m.material\nORDER BY (m.total_sold + m.total_bought) DESC\nLIMIT ?\n";
            QueryResult result = this.dataManager.executeQuery(sql, limit).join();
            try {
                ArrayList<MarketItemStats> stats = new ArrayList<MarketItemStats>();
                int rank = 1;
                while (result.next()) {
                    Material material = Material.valueOf((String)result.getString("material"));
                    stats.add(new MarketItemStats(material, result.getInt("total_sold"), result.getInt("total_bought"), result.getBigDecimal("sell_volume"), result.getBigDecimal("buy_volume"), result.getBigDecimal("avg_sell_price"), result.getBigDecimal("avg_buy_price"), rank++));
                }
                ArrayList<MarketItemStats> arrayList = stats;
                if (result != null) {
                    result.close();
                }
                return arrayList;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to get top traded items", e);
                    return Collections.emptyList();
                }
            }
        });
    }

    @Override
    public CompletableFuture<MarketTrend> getItemTrend(Material material) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Optional<MarketItem> itemOpt;
                List<MarketPriceHistory> history = this.getPriceHistory(material, 7).join();
                if (history.size() < 2 && (itemOpt = this.getItem(material).join()).isPresent()) {
                    MarketItem item = itemOpt.get();
                    return new MarketTrend(material, MarketTrend.TrendDirection.STABLE, item.getCurrentBuyPrice(), BigDecimal.ZERO, BigDecimal.ZERO, 0.1, 0.0, LocalDateTime.now(), "Insufficient data for trend analysis");
                }
                MarketPriceHistory latest = history.get(0);
                MarketPriceHistory previous = history.get(Math.min(1, history.size() - 1));
                BigDecimal currentPrice = latest.getBuyPrice();
                BigDecimal previousPrice = previous.getBuyPrice();
                BigDecimal priceChange = currentPrice.subtract(previousPrice);
                BigDecimal changePercentage = BigDecimal.ZERO;
                if (!previousPrice.equals(BigDecimal.ZERO)) {
                    changePercentage = priceChange.divide(previousPrice, 4, 4).multiply(BigDecimal.valueOf(100L));
                }
                double volatility = this.calculateVolatilityFromHistory(history);
                double changePercent = changePercentage.doubleValue();
                MarketTrend.TrendDirection direction = volatility > 0.3 ? MarketTrend.TrendDirection.VOLATILE : (changePercent > 5.0 ? MarketTrend.TrendDirection.STRONG_UPWARD : (changePercent > 1.0 ? MarketTrend.TrendDirection.UPWARD : (changePercent < -5.0 ? MarketTrend.TrendDirection.STRONG_DOWNWARD : (changePercent < -1.0 ? MarketTrend.TrendDirection.DOWNWARD : MarketTrend.TrendDirection.STABLE))));
                double momentum = Math.min(1.0, Math.max(-1.0, changePercent / 10.0));
                return new MarketTrend(material, direction, currentPrice, priceChange, changePercentage, volatility, momentum, LocalDateTime.now(), null);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to get item trend for: " + material.name(), e);
                return new MarketTrend(material, MarketTrend.TrendDirection.STABLE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0.0, 0.0, LocalDateTime.now(), "Error calculating trend");
            }
        });
    }

    @Override
    public boolean canAfford(Player player, BigDecimal amount) {
        try {
            BigDecimal balance = this.economyManager.getBalance(player.getUniqueId()).join();
            return balance.compareTo(amount) >= 0;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to check player balance", e);
            return false;
        }
    }

    @Override
    public boolean hasItems(Player player, Material material, int quantity) {
        return this.countItems(player, material) >= quantity;
    }

    @Override
    public int countItems(Player player, Material material) {
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material) continue;
            count += item.getAmount();
        }
        return count;
    }

    @Override
    public boolean addItemsToInventory(Player player, ItemStack itemStack) {
        if (player.getInventory().firstEmpty() == -1) {
            int maxStack;
            int canAdd;
            ItemStack existing;
            int remainingAmount = itemStack.getAmount();
            ItemStack[] itemStackArray = player.getInventory().getContents();
            int n = itemStackArray.length;
            for (int i = 0; !(i >= n || (existing = itemStackArray[i]) != null && existing.isSimilar(itemStack) && (canAdd = (maxStack = existing.getMaxStackSize()) - existing.getAmount()) > 0 && (remainingAmount -= Math.min(canAdd, remainingAmount)) <= 0); ++i) {
            }
            if (remainingAmount > 0) {
                return false;
            }
        }
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{itemStack});
        return leftover.isEmpty();
    }

    @Override
    public boolean removeItemsFromInventory(Player player, Material material, int quantity) {
        int remaining = quantity;
        ItemStack[] contents = player.getInventory().getContents();
        int available = this.countItems(player, material);
        if (available < quantity) {
            return false;
        }
        for (int i = 0; i < contents.length && remaining > 0; ++i) {
            ItemStack item = contents[i];
            if (item == null || item.getType() != material) continue;
            int removeAmount = Math.min(remaining, item.getAmount());
            item.setAmount(item.getAmount() - removeAmount);
            if (item.getAmount() <= 0) {
                contents[i] = null;
            }
            remaining -= removeAmount;
        }
        player.getInventory().setContents(contents);
        return remaining == 0;
    }

    private void loadItemsIntoCache() {
        List<MarketItem> items = this.loadItemsFromDatabase();
        this.itemCache.clear();
        for (MarketItem item : items) {
            this.itemCache.put(item.getMaterial(), item);
        }
        this.plugin.getLogger().info("Loaded " + items.size() + " market items into cache");
    }

    private double getProfessionFactor(UUID uuid, boolean isBuy) {
        try {
            Optional<ProfessionRole> roleOpt;
            if (this.professionsManager == null) {
                this.professionsManager = this.plugin.getServiceRegistry().getInstance(ProfessionsManager.class);
            }
            if ((roleOpt = this.professionsManager.getRole(uuid).join()).isEmpty()) {
                return 1.0;
            }
            String key = "roles." + roleOpt.get().name().toLowerCase() + "." + (isBuy ? "buy_factor" : "sell_factor");
            FileConfiguration profCfg = this.configManager.getModuleConfig("professions");
            double v = profCfg.getDouble(key, 1.0);
            int level = this.professionsManager.getLevel(uuid).join();
            int maxLevel = profCfg.getInt("max_level", 5);
            level = Math.max(1, Math.min(level, maxLevel));
            double perLevel = profCfg.getDouble("roles." + roleOpt.get().name().toLowerCase() + "." + (isBuy ? "buy_bonus_per_level" : "sell_bonus_per_level"), 0.0);
            v = isBuy ? (v *= 1.0 - perLevel * (double)(level - 1)) : (v *= 1.0 + perLevel * (double)(level - 1));
            if (v < 0.5) {
                v = 0.5;
            }
            if (v > 1.5) {
                v = 1.5;
            }
            return v;
        }
        catch (Exception ignored) {
            return 1.0;
        }
    }

    private double getProfessionFactor(UUID uuid, Material material, boolean isBuy) {
        double v = this.getProfessionFactor(uuid, isBuy);
        try {
            Optional<ProfessionRole> roleOpt;
            if (this.professionsManager == null) {
                this.professionsManager = this.plugin.getServiceRegistry().getInstance(ProfessionsManager.class);
            }
            if ((roleOpt = this.professionsManager.getRole(uuid).join()).isEmpty()) {
                return v;
            }
            String roleKey = "roles." + roleOpt.get().name().toLowerCase();
            FileConfiguration profCfg = this.configManager.getModuleConfig("professions");
            for (String cat : this.resolveCategories(material)) {
                String ckey = roleKey + ".category_bonuses." + cat.toLowerCase() + "." + (isBuy ? "buy_factor" : "sell_factor");
                double cf = profCfg.getDouble(ckey, 1.0);
                v *= cf;
            }
            EconomicEventEngine events = this.plugin.getServiceRegistry().getInstance(EconomicEventEngine.class);
            if (events != null) {
                for (EconomicEvent ev : events.getActiveEvents().values()) {
                    String ekey = roleKey + ".event_bonuses." + ev.getType().name() + "." + (isBuy ? "buy_factor" : "sell_factor");
                    double ef = profCfg.getDouble(ekey, 1.0);
                    v *= ef;
                }
            }
            if (v < 0.5) {
                v = 0.5;
            }
            if (v > 1.5) {
                v = 1.5;
            }
            return v;
        }
        catch (Exception ignored) {
            return v;
        }
    }

    private double getIntegrationsFactor(Material material, boolean isBuy) {
        try {
            ServiceRegistry sr = this.plugin.getServiceRegistry();
            IntegrationsManager integ = sr.getInstance(IntegrationsManager.class);
            FileConfiguration cfg = this.configManager.getModuleConfig("integrations");
            if (cfg == null || !cfg.getBoolean("adjustments.enabled", true)) {
                return 1.0;
            }
            double factor = 1.0;
            if (integ != null && integ.hasJobs()) {
                factor *= cfg.getDouble("adjustments.jobs." + (isBuy ? "buy_factor" : "sell_factor"), 1.0);
            }
            if (integ != null && integ.hasTowny()) {
                factor *= cfg.getDouble("adjustments.towny." + (isBuy ? "buy_factor" : "sell_factor"), 1.0);
            }
            if (integ != null && integ.hasLands()) {
                factor *= cfg.getDouble("adjustments.lands." + (isBuy ? "buy_factor" : "sell_factor"), 1.0);
            }
            if (integ != null && integ.hasSlimefun()) {
                factor *= cfg.getDouble("adjustments.slimefun." + (isBuy ? "buy_factor" : "sell_factor"), 1.0);
            }
            if (integ != null && integ.hasMcMMO()) {
                factor *= cfg.getDouble("adjustments.mcmmo." + (isBuy ? "buy_factor" : "sell_factor"), 1.0);
            }
            if (factor < 0.9) {
                factor = 0.9;
            }
            if (factor > 1.1) {
                factor = 1.1;
            }
            return factor;
        }
        catch (Exception ignored) {
            return 1.0;
        }
    }

    private double getInflationaryMaterialFactor(Material material, boolean isBuy) {
        try {
            FileConfiguration cfg = this.configManager.getModuleConfig("integrations");
            List list = cfg.getStringList("slimefun.inflationary.materials");
            if (list == null || list.isEmpty()) {
                return 1.0;
            }
            for (String m : list) {
                double f;
                if (!material.name().equalsIgnoreCase(m.trim())) continue;
                double bf = cfg.getDouble("slimefun.inflationary.buy_factor", 1.02);
                double sf = cfg.getDouble("slimefun.inflationary.sell_factor", 0.98);
                double d = f = isBuy ? bf : sf;
                if (f < 0.8) {
                    f = 0.8;
                }
                if (f > 1.2) {
                    f = 1.2;
                }
                return f;
            }
            return 1.0;
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    private double getTerritoryFactor(Player player, Material material, boolean isBuy) {
        try {
            ConfigurationSection towny;
            ConfigurationSection lands;
            IntegrationsManager integ = this.plugin.getServiceRegistry().getInstance(IntegrationsManager.class);
            FileConfiguration cfg = this.configManager.getModuleConfig("integrations");
            if (cfg == null || !cfg.getBoolean("territory.enabled", true)) {
                return 1.0;
            }
            String region = "";
            String land = "";
            String town = "";
            if (integ != null) {
                if (integ.hasWorldGuard()) {
                    region = integ.getWorldGuardRegions(player);
                }
                if (integ.hasLands()) {
                    land = integ.getLandsLand(player);
                }
                if (integ.hasTowny()) {
                    town = integ.getTownyTown(player);
                }
            }
            double factor = 1.0;
            ConfigurationSection rules = cfg.getConfigurationSection("territory.worldguard.rules");
            if (rules != null && region != null && !region.isEmpty()) {
                List<String> ids = Arrays.asList(region.split(","));
                Iterator iterator = rules.getKeys(false).iterator();
                while (iterator.hasNext()) {
                    String key;
                    String pattern = key = (String)iterator.next();
                    for (String id : ids) {
                        if (!this.globMatches(pattern, id)) continue;
                        double bf = rules.getDouble(key + ".buy_factor", 1.0);
                        double sf = rules.getDouble(key + ".sell_factor", 1.0);
                        factor *= isBuy ? bf : sf;
                    }
                }
            }
            if ((lands = cfg.getConfigurationSection("territory.lands")) != null && land != null && !land.isEmpty()) {
                for (String key : lands.getKeys(false)) {
                    if (!this.globMatches(key, land)) continue;
                    double bf = lands.getDouble(key + ".buy_factor", 1.0);
                    double sf = lands.getDouble(key + ".sell_factor", 1.0);
                    factor *= isBuy ? bf : sf;
                }
                if (lands.isConfigurationSection("default") && factor == 1.0) {
                    double bf = lands.getDouble("default.buy_factor", 1.0);
                    double sf = lands.getDouble("default.sell_factor", 1.0);
                    factor *= isBuy ? bf : sf;
                }
            }
            if ((towny = cfg.getConfigurationSection("territory.towny")) != null) {
                ConfigurationSection scaling;
                ConfigurationSection townRules = towny.getConfigurationSection("rules");
                if (townRules != null && town != null && !town.isEmpty()) {
                    for (String key : townRules.getKeys(false)) {
                        if (!this.globMatches(key, town)) continue;
                        double bf = townRules.getDouble(key + ".buy_factor", 1.0);
                        double sf = townRules.getDouble(key + ".sell_factor", 1.0);
                        factor *= isBuy ? bf : sf;
                    }
                }
                if (towny.isConfigurationSection("default")) {
                    double bf = towny.getDouble("default.buy_factor", 1.0);
                    double sf = towny.getDouble("default.sell_factor", 1.0);
                    factor *= isBuy ? bf : sf;
                }
                if ((scaling = towny.getConfigurationSection("scaling")) != null && scaling.getBoolean("enabled", false)) {
                    int residents = this.getTownyResidentsCountSafe(player, town);
                    List thresholds = scaling.getList("thresholds");
                    if (thresholds != null && !thresholds.isEmpty()) {
                        double chosen = 1.0;
                        for (Object o : thresholds) {
                            double fac;
                            Map m;
                            Object r;
                            int req;
                            if (!(o instanceof Map) || residents < (req = (r = (m = (Map)o).get("residents")) instanceof Number ? ((Number)r).intValue() : Integer.parseInt(String.valueOf(r)))) continue;
                            Object bf = m.get("buy_factor");
                            Object sf = m.get("sell_factor");
                            chosen = fac = isBuy ? (bf instanceof Number ? ((Number)bf).doubleValue() : Double.parseDouble(String.valueOf(bf))) : (sf instanceof Number ? ((Number)sf).doubleValue() : Double.parseDouble(String.valueOf(sf)));
                        }
                        factor *= chosen;
                    }
                }
            }
            if (factor < 0.8) {
                factor = 0.8;
            }
            if (factor > 1.2) {
                factor = 1.2;
            }
            return factor;
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    private int getTownyResidentsCountSafe(Player player, String townName) {
        try {
            Class<?> apiClass = Class.forName("com.palmergames.bukkit.towny.TownyAPI");
            Object api = apiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Object town = null;
            try {
                town = apiClass.getMethod("getTown", Player.class).invoke(api, player);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (town == null && townName != null && !townName.isEmpty()) {
                try {
                    town = apiClass.getMethod("getTown", String.class).invoke(api, townName);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (town == null) {
                return 0;
            }
            try {
                return (Integer)town.getClass().getMethod("getNumResidents", new Class[0]).invoke(town, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return (Integer)town.getClass().getMethod("getResidentsCount", new Class[0]).invoke(town, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    try {
                        Object coll = town.getClass().getMethod("getResidents", new Class[0]).invoke(town, new Object[0]);
                        if (coll instanceof Collection) {
                            return ((Collection)coll).size();
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {
                        // empty catch block
                    }
                    return 0;
                }
            }
        }
        catch (Throwable ignored) {
            return 0;
        }
    }

    private boolean globMatches(String glob, String text) {
        try {
            String regex = glob.replace("*", ".*").replace("?", ".");
            return text.matches("(?i)" + regex);
        }
        catch (Exception e) {
            return false;
        }
    }

    private List<String> resolveCategories(Material material) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            FileConfiguration marketCfg = this.configManager.getModuleConfig("market");
            ConfigurationSection section = marketCfg.getConfigurationSection("categories");
            if (section != null) {
                block2: for (String key : section.getKeys(false)) {
                    List mats = marketCfg.getStringList("categories." + key + ".materials");
                    for (String m : mats) {
                        if (!material.name().equalsIgnoreCase(m.trim())) continue;
                        list.add(key.toUpperCase());
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private void seedDefaultMarketItems() {
        this.plugin.getLogger().info("Seeding default market items (first run)\u2026");
        LinkedHashMap<Material, BigDecimal> defaults = new LinkedHashMap<Material, BigDecimal>();
        defaults.put(Material.WHEAT, new BigDecimal("2.00"));
        defaults.put(Material.BREAD, new BigDecimal("5.00"));
        defaults.put(Material.APPLE, new BigDecimal("3.00"));
        defaults.put(Material.COAL, new BigDecimal("8.00"));
        defaults.put(Material.IRON_INGOT, new BigDecimal("20.00"));
        defaults.put(Material.COPPER_INGOT, new BigDecimal("10.00"));
        defaults.put(Material.GOLD_INGOT, new BigDecimal("30.00"));
        defaults.put(Material.REDSTONE, new BigDecimal("6.00"));
        defaults.put(Material.LAPIS_LAZULI, new BigDecimal("12.00"));
        defaults.put(Material.DIAMOND, new BigDecimal("150.00"));
        defaults.put(Material.EMERALD, new BigDecimal("120.00"));
        defaults.put(Material.NETHERITE_INGOT, new BigDecimal("500.00"));
        int seeded = 0;
        for (Map.Entry e : defaults.entrySet()) {
            try {
                this.addItem((Material)e.getKey(), (BigDecimal)e.getValue(), true, true).join();
                ++seeded;
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to seed item " + String.valueOf(e.getKey()) + ": " + ex.getMessage());
            }
        }
        this.plugin.getLogger().info("Seeded " + seeded + " default market items");
    }

    private List<MarketItem> loadItemsFromDatabase() {
        String sql = "SELECT * FROM ecoxpert_market_items ORDER BY material";
        QueryResult result = this.dataManager.executeQuery(sql, new Object[0]).join();
        try {
            ArrayList<MarketItem> items = new ArrayList<MarketItem>();
            while (result.next()) {
                Material material = Material.valueOf((String)result.getString("material"));
                items.add(MarketItem.builder(material, result.getBigDecimal("base_price")).currentBuyPrice(result.getBigDecimal("current_buy_price")).currentSellPrice(result.getBigDecimal("current_sell_price")).buyable(result.getBoolean("buyable")).sellable(result.getBoolean("sellable")).totalSold(result.getInt("total_sold")).totalBought(result.getInt("total_bought")).priceVolatility(result.getBigDecimal("price_volatility")).lastPriceUpdate(result.getTimestamp("last_price_update").toLocalDateTime()).build());
            }
            ArrayList<MarketItem> arrayList = items;
            if (result != null) {
                result.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load market items from database", e);
                return Collections.emptyList();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<MarketItem> loadItemFromDatabase(Material material) {
        try {
            String sql = "SELECT * FROM ecoxpert_market_items WHERE material = ?";
            try (QueryResult result = this.dataManager.executeQuery(sql, material.name()).join();){
                if (result.next()) {
                    MarketItem item = MarketItem.builder(material, result.getBigDecimal("base_price")).currentBuyPrice(result.getBigDecimal("current_buy_price")).currentSellPrice(result.getBigDecimal("current_sell_price")).buyable(result.getBoolean("buyable")).sellable(result.getBoolean("sellable")).totalSold(result.getInt("total_sold")).totalBought(result.getInt("total_bought")).priceVolatility(result.getBigDecimal("price_volatility")).lastPriceUpdate(result.getTimestamp("last_price_update").toLocalDateTime()).build();
                    this.itemCache.put(material, item);
                    Optional<MarketItem> optional = Optional.of(item);
                    return optional;
                }
                Optional<MarketItem> optional = Optional.empty();
                return optional;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load market item: " + material.name(), e);
            return Optional.empty();
        }
    }

    private void schedulePriceUpdates() {
        this.priceUpdateScheduler.scheduleAtFixedRate(() -> {
            try {
                this.updatePrices().join();
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error during scheduled price update", e);
            }
        }, 5L, 5L, TimeUnit.MINUTES);
        this.plugin.getLogger().info("Scheduled price updates every 5 minutes");
    }

    private void scheduleCacheRefresh() {
        this.priceUpdateScheduler.scheduleAtFixedRate(() -> {
            try {
                this.loadItemsIntoCache();
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error during scheduled cache refresh", e);
            }
        }, 10L, 10L, TimeUnit.MINUTES);
        this.plugin.getLogger().info("Scheduled cache refresh every 10 minutes");
    }

    private void updateItemPrice(MarketItem item, List<MarketTransaction> recentTransactions) {
        try {
            PriceCalculator.MarketPriceUpdate priceUpdate = this.priceCalculator.calculatePriceUpdate(item, recentTransactions);
            BigDecimal adjustedBuy = priceUpdate.getNewBuyPrice().multiply(BigDecimal.valueOf(this.buyPriceFactor));
            BigDecimal adjustedSell = priceUpdate.getNewSellPrice().multiply(BigDecimal.valueOf(this.sellPriceFactor));
            ItemFactor f = this.itemFactors.get(item.getMaterial());
            if (f != null && !f.expired()) {
                adjustedBuy = adjustedBuy.multiply(BigDecimal.valueOf(f.buy));
                adjustedSell = adjustedSell.multiply(BigDecimal.valueOf(f.sell));
            } else if (f != null && f.expired()) {
                this.itemFactors.remove(item.getMaterial());
            }
            BigDecimal oldBuy = item.getCurrentBuyPrice();
            BigDecimal oldSell = item.getCurrentSellPrice();
            double buyDelta = this.safeRelativeChange(oldBuy, adjustedBuy);
            double sellDelta = this.safeRelativeChange(oldSell, adjustedSell);
            String sql = "UPDATE ecoxpert_market_items\nSET current_buy_price = ?, current_sell_price = ?,\n    price_volatility = ?, last_price_update = ?, updated_at = ?\nWHERE material = ?\n";
            this.dataManager.executeUpdate(sql, adjustedBuy, adjustedSell, BigDecimal.valueOf(priceUpdate.getVolatility()), Timestamp.valueOf(priceUpdate.getUpdateTime()), Timestamp.valueOf(LocalDateTime.now()), item.getMaterial().name()).join();
            MarketItem updatedItem = item.withPrices(adjustedBuy, adjustedSell);
            this.itemCache.put(item.getMaterial(), updatedItem);
            this.recordPriceHistory(priceUpdate);
            try {
                double threshold = 0.15;
                try {
                    FileConfiguration cfg = this.configManager.getModuleConfig("market");
                    threshold = cfg.getDouble("api.events.price_change_threshold_percent", 0.15);
                }
                catch (Exception cfg) {
                    // empty catch block
                }
                if (Math.max(Math.abs(buyDelta), Math.abs(sellDelta)) >= threshold) {
                    BigDecimal nb = adjustedBuy;
                    BigDecimal ns = adjustedSell;
                    Material mat = item.getMaterial();
                    Instant ts = Instant.now();
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new MarketPriceChangeEvent(mat, oldBuy, nb, oldSell, ns, priceUpdate.getVolatility(), ts)));
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to update price for " + item.getMaterial().name(), e);
        }
    }

    private void recordPriceHistory(PriceCalculator.MarketPriceUpdate priceUpdate) {
        try {
            String sql = "INSERT INTO ecoxpert_market_price_history\n(material, buy_price, sell_price, snapshot_time)\nVALUES (?, ?, ?, ?)\n";
            this.dataManager.executeUpdate(sql, priceUpdate.getMaterial().name(), priceUpdate.getNewBuyPrice(), priceUpdate.getNewSellPrice(), Timestamp.valueOf(priceUpdate.getUpdateTime()));
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to record price history for " + priceUpdate.getMaterial().name(), e);
        }
    }

    private double safeRelativeChange(BigDecimal oldVal, BigDecimal newVal) {
        try {
            if (oldVal == null || newVal == null) {
                return 0.0;
            }
            if (oldVal.compareTo(BigDecimal.ZERO) == 0) {
                return newVal.subtract(oldVal).doubleValue() / 0.01;
            }
            return newVal.subtract(oldVal).divide(oldVal.abs(), 6, RoundingMode.HALF_UP).doubleValue();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private void immediateAdjustAfterTrade(MarketItem item, MarketTransaction.TransactionType type, int quantity) {
        try {
            FileConfiguration cfg = this.configManager.getModuleConfig("market");
            double maxChange = cfg.getDouble("pricing.max_price_change", 0.2);
            double baseDelta = Math.min(maxChange / 2.0, Math.max(0.0, (double)quantity / 10.0 * 0.001));
            if (baseDelta <= 0.0) {
                return;
            }
            BigDecimal newBuy = item.getCurrentBuyPrice();
            BigDecimal newSell = item.getCurrentSellPrice();
            if (type == MarketTransaction.TransactionType.BUY) {
                newBuy = newBuy.multiply(BigDecimal.valueOf(1.0 + baseDelta)).setScale(2, RoundingMode.HALF_UP);
            } else {
                newSell = newSell.multiply(BigDecimal.valueOf(1.0 - baseDelta)).setScale(2, RoundingMode.HALF_UP);
            }
            String sql = "UPDATE ecoxpert_market_items SET current_buy_price = ?, current_sell_price = ?, updated_at = CURRENT_TIMESTAMP WHERE material = ?";
            this.dataManager.executeUpdate(sql, newBuy, newSell, item.getMaterial().name()).join();
            this.itemCache.put(item.getMaterial(), item.withPrices(newBuy, newSell));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    private MarketTransactionResult processTransaction(Player player, MarketItem item, MarketTransaction.TransactionType type, int quantity, BigDecimal unitPrice, BigDecimal totalAmount) {
        block32: {
            block31: {
                dbTransaction = this.dataManager.beginTransaction().join();
                playerId = player.getUniqueId().toString();
                starting = this.economyManager.getStartingBalance();
                currentBalance = BigDecimal.ZERO;
                result = dbTransaction.executeQuery("SELECT balance FROM ecoxpert_accounts WHERE player_uuid = ?", new Object[]{playerId}).join();
                try {
                    if (result.next()) {
                        b = result.getBigDecimal("balance");
                        currentBalance = b != null ? b : BigDecimal.ZERO;
                    } else {
                        dbTransaction.executeUpdate("INSERT OR IGNORE INTO ecoxpert_accounts (player_uuid, balance) VALUES (?, ?)", new Object[]{playerId, starting}).join();
                        currentBalance = starting;
                    }
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
                if (type != MarketTransaction.TransactionType.BUY) ** GOTO lbl36
                if (currentBalance.compareTo(totalAmount) >= 0) break block31;
                result = MarketTransactionResult.failure(MarketTransactionResult.TransactionError.INSUFFICIENT_FUNDS, this.translationManager.getMessage("market.insufficient-funds", this.economyManager.formatMoney(totalAmount), new Object[]{this.economyManager.formatMoney(currentBalance)}));
                if (dbTransaction != null) {
                    dbTransaction.close();
                }
                return result;
            }
            dbTransaction.executeUpdate("UPDATE ecoxpert_accounts SET balance = balance - ?, updated_at = CURRENT_TIMESTAMP WHERE player_uuid = ?", new Object[]{totalAmount, playerId}).join();
            dbTransaction.executeUpdate("INSERT INTO ecoxpert_transactions (from_uuid, to_uuid, amount, type, description) VALUES (?, ?, ?, ?, ?)", new Object[]{playerId, null, totalAmount, "WITHDRAWAL", "Market purchase"}).join();
            break block32;
lbl36:
            // 1 sources

            dbTransaction.executeUpdate("UPDATE ecoxpert_accounts SET balance = balance + ?, updated_at = CURRENT_TIMESTAMP WHERE player_uuid = ?", new Object[]{totalAmount, playerId}).join();
            dbTransaction.executeUpdate("INSERT INTO ecoxpert_transactions (from_uuid, to_uuid, amount, type, description) VALUES (?, ?, ?, ?, ?)", new Object[]{null, playerId, totalAmount, "DEPOSIT", "Market sale"}).join();
        }
        transaction = MarketTransaction.builder().player(player.getUniqueId(), player.getName()).material(item.getMaterial()).type(type).quantity(quantity).unitPrice(unitPrice).totalAmount(totalAmount).build();
        transactionSql = "INSERT INTO ecoxpert_market_transactions\n(player_uuid, player_name, material, transaction_type, quantity,\n unit_price, total_amount, description, created_at)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
        dbTransaction.executeUpdate(transactionSql, new Object[]{player.getUniqueId().toString(), player.getName(), item.getMaterial().name(), type.getDisplayName(), quantity, unitPrice, totalAmount, transaction.getDescription(), Timestamp.valueOf(transaction.getTimestamp())});
        updateItemSql = "UPDATE ecoxpert_market_items\nSET total_sold = total_sold + ?, total_bought = total_bought + ?, updated_at = ?\nWHERE material = ?\n";
        soldIncrement = type == MarketTransaction.TransactionType.SELL ? quantity : 0;
        boughtIncrement = type == MarketTransaction.TransactionType.BUY ? quantity : 0;
        dbTransaction.executeUpdate(updateItemSql, new Object[]{soldIncrement, boughtIncrement, Timestamp.valueOf(LocalDateTime.now()), item.getMaterial().name()});
        dbTransaction.commit().join();
        updatedItem = item.withUpdatedStats(soldIncrement, boughtIncrement);
        this.itemCache.put(item.getMaterial(), updatedItem);
        messageKey = type == MarketTransaction.TransactionType.BUY ? "market.item-bought" : "market.item-sold";
        message = this.translationManager.getMessage(messageKey, new Object[]{quantity, item.getMaterial().name().toLowerCase().replace('_', ' '), this.economyManager.formatMoney(totalAmount)});
        try {
            if (this.professionsManager == null) {
                this.professionsManager = this.plugin.getServiceRegistry().getInstance(ProfessionsManager.class);
            }
            profCfg = this.configManager.getModuleConfig("professions");
            perTx = type == MarketTransaction.TransactionType.BUY ? profCfg.getInt("xp.per_buy", 1) : profCfg.getInt("xp.per_sell", 2);
            per100 = type == MarketTransaction.TransactionType.BUY ? profCfg.getInt("xp.per_100_money_buy", 0) : profCfg.getInt("xp.per_100_money_sell", 1);
            blocks = BigDecimal.ZERO.compareTo(totalAmount) < 0 ? totalAmount.divide(new BigDecimal("100"), 0, RoundingMode.DOWN).intValue() : 0;
            xpDelta = Math.max(0, perTx + blocks * per100);
            if (xpDelta > 0) {
                prevLevel = this.professionsManager.getLevel(player.getUniqueId()).join();
                this.professionsManager.addXp(player.getUniqueId(), xpDelta).thenAccept((Consumer)(Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processTransaction$23(me.koyere.ecoxpert.modules.market.MarketTransaction$TransactionType org.bukkit.entity.Player int int java.lang.Integer ), (Ljava/lang/Integer;)V)((MarketManagerImpl)this, (MarketTransaction.TransactionType)type, (Player)player, (int)xpDelta, (int)prevLevel));
            }
        }
        catch (Exception var19_26) {
            // empty catch block
        }
        try {
            this.immediateAdjustAfterTrade(updatedItem, type, quantity);
        }
        catch (Exception var19_27) {
            // empty catch block
        }
        try {
            this.maybeFlagSlimefunAbundance(type, item.getMaterial(), quantity);
        }
        catch (Exception var19_28) {
            // empty catch block
        }
        var19_25 = MarketTransactionResult.success(transaction, message);
        if (dbTransaction != null) {
            dbTransaction.close();
        }
        return var19_25;
        {
            catch (Throwable var8_11) {
                try {
                    if (dbTransaction != null) {
                        try {
                            dbTransaction.close();
                        }
                        catch (Throwable var9_13) {
                            var8_11.addSuppressed(var9_13);
                        }
                    }
                    throw var8_11;
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to process market transaction", e);
                    return MarketTransactionResult.failure("Transaction processing failed");
                }
            }
        }
    }

    private void maybeFlagSlimefunAbundance(MarketTransaction.TransactionType type, Material material, int quantity) {
        try {
            boolean alreadyFlagged;
            if (type != MarketTransaction.TransactionType.SELL) {
                return;
            }
            IntegrationsManager integ = this.plugin.getServiceRegistry().getInstance(IntegrationsManager.class);
            if (integ == null || !integ.hasSlimefun()) {
                return;
            }
            FileConfiguration cfg = this.configManager.getModuleConfig("integrations");
            ConfigurationSection sec = cfg.getConfigurationSection("slimefun.auto_flagging");
            if (sec == null || !sec.getBoolean("enabled", false)) {
                return;
            }
            int windowMin = Math.max(1, sec.getInt("window_minutes", 10));
            int threshold = Math.max(1, sec.getInt("sell_threshold", 256));
            int flagMinutes = Math.max(1, sec.getInt("flag_minutes", 30));
            double flagBuy = sec.getDouble("flag_buy_factor", 1.02);
            double flagSell = sec.getDouble("flag_sell_factor", 0.98);
            long now = System.currentTimeMillis();
            AtomicInteger counter = this.sellWindowCounts.computeIfAbsent(material, m -> new AtomicInteger(0));
            long windowStart = this.slimeFlaggedUntil.getOrDefault(Material.AIR, 0L);
            long bucket = now / ((long)windowMin * 60000L);
            String key = material.name() + "#" + bucket;
            if (this.sellWindowCounts.putIfAbsent(material, counter) == null) {
                // empty if block
            }
            if (!this.bucketKeySeen(key)) {
                counter.set(0);
                this.markBucketSeen(key);
            }
            int newCount = counter.addAndGet(quantity);
            Long flaggedUntil = this.slimeFlaggedUntil.get(material);
            boolean bl = alreadyFlagged = flaggedUntil != null && flaggedUntil > now;
            if (!alreadyFlagged && newCount >= threshold) {
                HashMap<Material, double[]> factors = new HashMap<Material, double[]>();
                factors.put(material, new double[]{flagBuy, flagSell});
                this.applyTemporaryItemFactors(factors, flagMinutes);
                this.slimeFlaggedUntil.put(material, now + (long)flagMinutes * 60000L);
                if (this.configManager.isDebugEnabled()) {
                    this.plugin.getLogger().info("SLIMEFUN FLAG - Material " + material.name() + " flagged for " + flagMinutes + " min (sell threshold=" + threshold + ")");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean bucketKeySeen(String k) {
        return this.seenBuckets.contains(k);
    }

    private void markBucketSeen(String k) {
        this.seenBuckets.add(k);
    }

    private List<MarketTransaction> getRecentTransactionsSync(int limit) {
        try {
            String sql = "SELECT * FROM ecoxpert_market_transactions\nORDER BY created_at DESC\nLIMIT ?\n";
            return this.loadTransactionsFromQuery(sql, limit);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to get recent transactions", e);
            return Collections.emptyList();
        }
    }

    private List<MarketTransaction> loadTransactionsFromQuery(String sql, Object ... params) {
        QueryResult result = this.dataManager.executeQuery(sql, params).join();
        try {
            ArrayList<MarketTransaction> transactions = new ArrayList<MarketTransaction>();
            while (result.next()) {
                transactions.add(MarketTransaction.builder().transactionId(result.getLong("id")).player(UUID.fromString(result.getString("player_uuid")), result.getString("player_name")).material(Material.valueOf((String)result.getString("material"))).type(MarketTransaction.TransactionType.fromString(result.getString("transaction_type"))).quantity(result.getInt("quantity")).unitPrice(result.getBigDecimal("unit_price")).totalAmount(result.getBigDecimal("total_amount")).timestamp(result.getTimestamp("created_at").toLocalDateTime()).description(result.getString("description")).build());
            }
            ArrayList<MarketTransaction> arrayList = transactions;
            if (result != null) {
                result.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load transactions from query", e);
                return Collections.emptyList();
            }
        }
    }

    private double calculateVolatilityFromHistory(List<MarketPriceHistory> history) {
        if (history.size() < 2) {
            return 0.1;
        }
        List<BigDecimal> prices = history.stream().map(MarketPriceHistory::getAveragePrice).toList();
        BigDecimal average = prices.stream().reduce(BigDecimal.ZERO, BigDecimal::add).divide(BigDecimal.valueOf(prices.size()), 4, 4);
        BigDecimal variance = prices.stream().map(price -> price.subtract(average).pow(2)).reduce(BigDecimal.ZERO, BigDecimal::add).divide(BigDecimal.valueOf(prices.size()), 4, 4);
        double standardDeviation = Math.sqrt(variance.doubleValue());
        double volatility = standardDeviation / average.doubleValue();
        return Math.min(0.5, Math.max(0.01, volatility));
    }

    private /* synthetic */ void lambda$processTransaction$23(MarketTransaction.TransactionType type, Player player, int xpDelta, int prevLevel, Integer newLevel) {
        try {
            String xpKey = type == MarketTransaction.TransactionType.BUY ? "professions.xp.gained.buy" : "professions.xp.gained.sell";
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + this.translationManager.getMessage(xpKey, xpDelta)));
            if (newLevel > prevLevel) {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + this.translationManager.getMessage("professions.levelup", newLevel)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ItemFactor {
        final double buy;
        final double sell;
        final long expiresAt;

        ItemFactor(double buy, double sell, long expiresAt) {
            this.buy = buy;
            this.sell = sell;
            this.expiresAt = expiresAt;
        }

        boolean expired() {
            return System.currentTimeMillis() > this.expiresAt;
        }
    }
}

