/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.market;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

public final class MarketStatistics {
    private final int totalItems;
    private final int activeItems;
    private final long totalTransactions;
    private final BigDecimal totalVolume;
    private final BigDecimal averagePrice;
    private final BigDecimal marketCapitalization;
    private final LocalDateTime lastUpdate;
    private final BigDecimal dailyVolume;
    private final int dailyTransactions;
    private final double marketActivity;

    public MarketStatistics(int totalItems, int activeItems, long totalTransactions, BigDecimal totalVolume, BigDecimal averagePrice, BigDecimal marketCapitalization, LocalDateTime lastUpdate, BigDecimal dailyVolume, int dailyTransactions, double marketActivity) {
        this.totalItems = Math.max(0, totalItems);
        this.activeItems = Math.max(0, activeItems);
        this.totalTransactions = Math.max(0L, totalTransactions);
        this.totalVolume = Objects.requireNonNull(totalVolume, "Total volume cannot be null");
        this.averagePrice = Objects.requireNonNull(averagePrice, "Average price cannot be null");
        this.marketCapitalization = Objects.requireNonNull(marketCapitalization, "Market cap cannot be null");
        this.lastUpdate = Objects.requireNonNull(lastUpdate, "Last update cannot be null");
        this.dailyVolume = Objects.requireNonNull(dailyVolume, "Daily volume cannot be null");
        this.dailyTransactions = Math.max(0, dailyTransactions);
        this.marketActivity = Math.max(0.0, Math.min(1.0, marketActivity));
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public int getActiveItems() {
        return this.activeItems;
    }

    public long getTotalTransactions() {
        return this.totalTransactions;
    }

    public BigDecimal getTotalVolume() {
        return this.totalVolume;
    }

    public BigDecimal getAveragePrice() {
        return this.averagePrice;
    }

    public BigDecimal getMarketCapitalization() {
        return this.marketCapitalization;
    }

    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public BigDecimal getDailyVolume() {
        return this.dailyVolume;
    }

    public int getDailyTransactions() {
        return this.dailyTransactions;
    }

    public double getMarketActivity() {
        return this.marketActivity;
    }

    public BigDecimal getAverageTransactionValue() {
        if (this.totalTransactions == 0L) {
            return BigDecimal.ZERO;
        }
        return this.totalVolume.divide(BigDecimal.valueOf(this.totalTransactions), 2, 4);
    }

    public String getActivityLevel() {
        if (this.marketActivity >= 0.8) {
            return "Very High";
        }
        if (this.marketActivity >= 0.6) {
            return "High";
        }
        if (this.marketActivity >= 0.4) {
            return "Medium";
        }
        if (this.marketActivity >= 0.2) {
            return "Low";
        }
        return "Very Low";
    }

    public double getActiveItemsPercentage() {
        if (this.totalItems == 0) {
            return 0.0;
        }
        return (double)this.activeItems / (double)this.totalItems * 100.0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MarketStatistics that = (MarketStatistics)obj;
        return this.totalItems == that.totalItems && this.activeItems == that.activeItems && this.totalTransactions == that.totalTransactions && Objects.equals(this.totalVolume, that.totalVolume) && Objects.equals(this.lastUpdate, that.lastUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.totalItems, this.activeItems, this.totalTransactions, this.totalVolume, this.lastUpdate);
    }

    public String toString() {
        return String.format("MarketStatistics{items=%d/%d, transactions=%d, volume=%s, activity=%s}", this.activeItems, this.totalItems, this.totalTransactions, this.totalVolume, this.getActivityLevel());
    }
}

