/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.market;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Material;

public final class MarketTransaction {
    private final long transactionId;
    private final UUID playerUuid;
    private final String playerName;
    private final Material material;
    private final TransactionType type;
    private final int quantity;
    private final BigDecimal unitPrice;
    private final BigDecimal totalAmount;
    private final LocalDateTime timestamp;
    private final String description;

    public MarketTransaction(long transactionId, UUID playerUuid, String playerName, Material material, TransactionType type, int quantity, BigDecimal unitPrice, BigDecimal totalAmount, LocalDateTime timestamp, String description) {
        this.transactionId = transactionId;
        this.playerUuid = Objects.requireNonNull(playerUuid, "Player UUID cannot be null");
        this.playerName = Objects.requireNonNull(playerName, "Player name cannot be null");
        this.material = Objects.requireNonNull(material, "Material cannot be null");
        this.type = Objects.requireNonNull(type, "Transaction type cannot be null");
        this.quantity = Math.max(1, quantity);
        this.unitPrice = Objects.requireNonNull(unitPrice, "Unit price cannot be null");
        this.totalAmount = Objects.requireNonNull(totalAmount, "Total amount cannot be null");
        this.timestamp = Objects.requireNonNull(timestamp, "Timestamp cannot be null");
        this.description = description != null ? description : this.generateDefaultDescription();
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public Material getMaterial() {
        return this.material;
    }

    public TransactionType getType() {
        return this.type;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isBuyTransaction() {
        return this.type == TransactionType.BUY;
    }

    public boolean isSellTransaction() {
        return this.type == TransactionType.SELL;
    }

    private String generateDefaultDescription() {
        return String.format("%s %dx %s for %s each", this.type.getDisplayName().toUpperCase(), this.quantity, this.material.name().toLowerCase().replace('_', ' '), this.unitPrice);
    }

    public String getFormattedSummary() {
        return String.format("%s: %s %dx %s = %s", this.type.getDisplayName().toUpperCase(), this.playerName, this.quantity, this.material.name().toLowerCase().replace('_', ' '), this.totalAmount);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MarketTransaction that = (MarketTransaction)obj;
        return this.transactionId == that.transactionId;
    }

    public int hashCode() {
        return Objects.hash(this.transactionId);
    }

    public String toString() {
        return String.format("MarketTransaction{id=%d, player=%s, type=%s, material=%s, quantity=%d, total=%s}", new Object[]{this.transactionId, this.playerName, this.type, this.material, this.quantity, this.totalAmount});
    }

    public static enum TransactionType {
        BUY("buy"),
        SELL("sell");

        private final String displayName;

        private TransactionType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static TransactionType fromString(String type) {
            for (TransactionType t : TransactionType.values()) {
                if (!t.displayName.equalsIgnoreCase(type)) continue;
                return t;
            }
            throw new IllegalArgumentException("Unknown transaction type: " + type);
        }
    }

    public static class Builder {
        private long transactionId;
        private UUID playerUuid;
        private String playerName;
        private Material material;
        private TransactionType type;
        private int quantity;
        private BigDecimal unitPrice;
        private BigDecimal totalAmount;
        private LocalDateTime timestamp = LocalDateTime.now();
        private String description;

        public Builder transactionId(long transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder player(UUID uuid, String name) {
            this.playerUuid = uuid;
            this.playerName = name;
            return this;
        }

        public Builder material(Material material) {
            this.material = material;
            return this;
        }

        public Builder type(TransactionType type) {
            this.type = type;
            return this;
        }

        public Builder quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder unitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
            this.totalAmount = unitPrice.multiply(BigDecimal.valueOf(this.quantity));
            return this;
        }

        public Builder totalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder timestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public MarketTransaction build() {
            return new MarketTransaction(this.transactionId, this.playerUuid, this.playerName, this.material, this.type, this.quantity, this.unitPrice, this.totalAmount, this.timestamp, this.description);
        }
    }
}

