/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.market;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import me.koyere.ecoxpert.modules.market.MarketTransaction;

public final class MarketTransactionResult {
    private final boolean success;
    private final String message;
    private final MarketTransaction transaction;
    private final TransactionError error;

    private MarketTransactionResult(boolean success, String message, MarketTransaction transaction, TransactionError error) {
        this.success = success;
        this.message = message;
        this.transaction = transaction;
        this.error = error;
    }

    public static MarketTransactionResult success(MarketTransaction transaction, String message) {
        return new MarketTransactionResult(true, message, transaction, null);
    }

    public static MarketTransactionResult failure(TransactionError error, String message) {
        return new MarketTransactionResult(false, message, null, error);
    }

    public static MarketTransactionResult failure(String message) {
        return new MarketTransactionResult(false, message, null, TransactionError.SYSTEM_ERROR);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailure() {
        return !this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public Optional<MarketTransaction> getTransaction() {
        return Optional.ofNullable(this.transaction);
    }

    public Optional<TransactionError> getError() {
        return Optional.ofNullable(this.error);
    }

    public Optional<BigDecimal> getTransactionAmount() {
        return this.getTransaction().map(MarketTransaction::getTotalAmount);
    }

    public Optional<Integer> getTransactionQuantity() {
        return this.getTransaction().map(MarketTransaction::getQuantity);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MarketTransactionResult that = (MarketTransactionResult)obj;
        return this.success == that.success && Objects.equals(this.message, that.message) && Objects.equals(this.transaction, that.transaction) && this.error == that.error;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.success, this.message, this.transaction, this.error});
    }

    public String toString() {
        return String.format("MarketTransactionResult{success=%s, message='%s', error=%s}", new Object[]{this.success, this.message, this.error});
    }

    public static enum TransactionError {
        INSUFFICIENT_FUNDS("market.error.insufficient-funds"),
        INSUFFICIENT_ITEMS("market.error.insufficient-items"),
        MARKET_CLOSED("market.error.market-closed"),
        ITEM_NOT_AVAILABLE("market.error.item-not-available"),
        ITEM_NOT_BUYABLE("market.error.item-not-buyable"),
        ITEM_NOT_SELLABLE("market.error.item-not-sellable"),
        INVENTORY_FULL("market.error.inventory-full"),
        INVALID_QUANTITY("market.error.invalid-quantity"),
        PRICE_CHANGED("market.error.price-changed"),
        SYSTEM_ERROR("market.error.system-error");

        private final String messageKey;

        private TransactionError(String messageKey) {
            this.messageKey = messageKey;
        }

        public String getMessageKey() {
            return this.messageKey;
        }
    }
}

