/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.market;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;
import org.bukkit.Material;

public final class MarketTrend {
    private final Material material;
    private final TrendDirection direction;
    private final BigDecimal currentPrice;
    private final BigDecimal priceChange;
    private final BigDecimal priceChangePercentage;
    private final double volatility;
    private final double momentum;
    private final LocalDateTime analysisTime;
    private final String trendDescription;

    public MarketTrend(Material material, TrendDirection direction, BigDecimal currentPrice, BigDecimal priceChange, BigDecimal priceChangePercentage, double volatility, double momentum, LocalDateTime analysisTime, String trendDescription) {
        this.material = Objects.requireNonNull(material, "Material cannot be null");
        this.direction = Objects.requireNonNull(direction, "Direction cannot be null");
        this.currentPrice = Objects.requireNonNull(currentPrice, "Current price cannot be null");
        this.priceChange = Objects.requireNonNull(priceChange, "Price change cannot be null");
        this.priceChangePercentage = Objects.requireNonNull(priceChangePercentage, "Price change percentage cannot be null");
        this.volatility = Math.max(0.0, volatility);
        this.momentum = momentum;
        this.analysisTime = Objects.requireNonNull(analysisTime, "Analysis time cannot be null");
        this.trendDescription = trendDescription != null ? trendDescription : this.generateDescription();
    }

    public Material getMaterial() {
        return this.material;
    }

    public TrendDirection getDirection() {
        return this.direction;
    }

    public BigDecimal getCurrentPrice() {
        return this.currentPrice;
    }

    public BigDecimal getPriceChange() {
        return this.priceChange;
    }

    public BigDecimal getPriceChangePercentage() {
        return this.priceChangePercentage;
    }

    public double getVolatility() {
        return this.volatility;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public LocalDateTime getAnalysisTime() {
        return this.analysisTime;
    }

    public String getTrendDescription() {
        return this.trendDescription;
    }

    public String getVolatilityLevel() {
        if (this.volatility >= 0.3) {
            return "Very High";
        }
        if (this.volatility >= 0.2) {
            return "High";
        }
        if (this.volatility >= 0.1) {
            return "Medium";
        }
        if (this.volatility >= 0.05) {
            return "Low";
        }
        return "Very Low";
    }

    public String getMomentumLevel() {
        if (this.momentum >= 0.5) {
            return "Strong Bullish";
        }
        if (this.momentum >= 0.2) {
            return "Bullish";
        }
        if (this.momentum >= -0.2) {
            return "Neutral";
        }
        if (this.momentum >= -0.5) {
            return "Bearish";
        }
        return "Strong Bearish";
    }

    public boolean isBullish() {
        return this.direction.isUpward() && this.momentum > 0.0;
    }

    public boolean isBearish() {
        return this.direction.isDownward() && this.momentum < 0.0;
    }

    public double getTrendStrength() {
        return Math.abs(this.direction.getStrength());
    }

    private String generateDescription() {
        StringBuilder description = new StringBuilder();
        description.append(this.material.name().toLowerCase().replace('_', ' ')).append(" is showing a ").append(this.direction.getDisplayName().toLowerCase()).append(" trend with ").append(this.getVolatilityLevel().toLowerCase()).append(" volatility");
        if (Math.abs(this.priceChangePercentage.doubleValue()) > 5.0) {
            description.append(" and significant price movement (");
            if (this.priceChangePercentage.doubleValue() > 0.0) {
                description.append("+");
            }
            description.append(this.priceChangePercentage).append("%)");
        }
        return description.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MarketTrend that = (MarketTrend)obj;
        return this.material == that.material && Objects.equals(this.analysisTime, that.analysisTime);
    }

    public int hashCode() {
        return Objects.hash(this.material, this.analysisTime);
    }

    public String toString() {
        return String.format("MarketTrend{material=%s, direction=%s, change=%s%%, volatility=%s}", this.material, this.direction.getDisplayName(), this.priceChangePercentage, this.getVolatilityLevel());
    }

    public static enum TrendDirection {
        STRONG_UPWARD("Strong Upward", 1.0),
        UPWARD("Upward", 0.5),
        STABLE("Stable", 0.0),
        DOWNWARD("Downward", -0.5),
        STRONG_DOWNWARD("Strong Downward", -1.0),
        VOLATILE("Volatile", 0.0);

        private final String displayName;
        private final double strength;

        private TrendDirection(String displayName, double strength) {
            this.displayName = displayName;
            this.strength = strength;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public double getStrength() {
            return this.strength;
        }

        public boolean isUpward() {
            return this.strength > 0.0;
        }

        public boolean isDownward() {
            return this.strength < 0.0;
        }

        public boolean isStable() {
            return this.strength == 0.0 && this == STABLE;
        }
    }
}

