/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.professions;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.gui.BaseGUI;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.modules.professions.ProfessionRole;
import me.koyere.ecoxpert.modules.professions.ProfessionsManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ProfessionsGUI
extends BaseGUI {
    private final ProfessionsManager professionsManager;
    private final TranslationManager tm;

    public ProfessionsGUI(EcoXpertPlugin plugin, ProfessionsManager professionsManager, TranslationManager tm) {
        super(plugin);
        this.professionsManager = professionsManager;
        this.tm = tm;
    }

    @Override
    protected Inventory create(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)this.tm.getMessage("professions.gui.title", "Professions", new Object[0]));
        int slot = 10;
        for (ProfessionRole r : ProfessionRole.values()) {
            String name = this.pretty(r.name());
            String[] lore = this.buildLore(player, r);
            inv.setItem(slot++, this.button(this.iconFor(r), name, lore));
            if (slot == 17) {
                slot = 19;
            }
            if (slot > 25) break;
        }
        return inv;
    }

    private String[] buildLore(Player p, ProfessionRole r) {
        FileConfiguration cfg = this.plugin.getServiceRegistry().getInstance(ConfigManager.class).getModuleConfig("professions");
        double buyF = cfg.getDouble("roles." + r.name().toLowerCase() + ".buy_factor", 1.0);
        double sellF = cfg.getDouble("roles." + r.name().toLowerCase() + ".sell_factor", 1.0);
        double buyLvl = cfg.getDouble("roles." + r.name().toLowerCase() + ".buy_bonus_per_level", 0.0);
        double sellLvl = cfg.getDouble("roles." + r.name().toLowerCase() + ".sell_bonus_per_level", 0.0);
        int maxLevel = cfg.getInt("max_level", 5);
        int cooldown = cfg.getInt("cooldown_minutes", 1440);
        int level = 1;
        int xp = 0;
        try {
            ProfessionsManager pm = this.plugin.getServiceRegistry().getInstance(ProfessionsManager.class);
            level = pm.getLevel(p.getUniqueId()).join();
            xp = pm.getXp(p.getUniqueId()).join();
        }
        catch (Exception pm) {
            // empty catch block
        }
        List<Integer> thresholds = cfg.getIntegerList("xp.level_thresholds");
        if (thresholds == null || thresholds.isEmpty()) {
            thresholds = Arrays.asList(0, 100, 250, 500, 1000, 2000);
        }
        int curIdx = Math.max(0, Math.min(level - 1, thresholds.size() - 1));
        int curBase = (Integer)thresholds.get(curIdx);
        int nextIdx = Math.min(level, thresholds.size() - 1);
        int nextReq = level >= maxLevel ? curBase : (Integer)thresholds.get(nextIdx);
        int progress = 100;
        if (level < maxLevel && nextReq > curBase) {
            int num = Math.max(0, xp - curBase);
            int den = Math.max(1, nextReq - curBase);
            progress = (int)Math.max(0.0, Math.min(100.0, Math.floor((double)num * 100.0 / (double)den)));
        }
        double effBuy = buyF * (1.0 - buyLvl * (double)(level - 1));
        double effSell = sellF * (1.0 + sellLvl * (double)(level - 1));
        return new String[]{"\u00a77Buy factor: \u00a7e" + String.format(Locale.US, "%.3f", buyF) + " \u00a77(efectivo: \u00a7e" + String.format(Locale.US, "%.3f", effBuy) + ")", "\u00a77Sell factor: \u00a7e" + String.format(Locale.US, "%.3f", sellF) + " \u00a77(efectivo: \u00a7e" + String.format(Locale.US, "%.3f", effSell) + ")", "\u00a77Per level: \u00a7ebuy " + String.format(Locale.US, "%.3f", buyLvl) + ", sell " + String.format(Locale.US, "%.3f", sellLvl), "\u00a77Level: \u00a7e" + level + "/" + maxLevel + " \u00a77| Cooldown: \u00a7e" + cooldown + "m", this.tm.getMessage("professions.gui.lore.xp", xp, Math.max(curBase, nextReq)), this.tm.getMessage("professions.gui.lore.progress", progress), "", "\u00a7eClick to select"};
    }

    private Material iconFor(ProfessionRole r) {
        return switch (r) {
            default -> throw new IncompatibleClassChangeError();
            case ProfessionRole.SAVER -> Material.IRON_INGOT;
            case ProfessionRole.SPENDER -> Material.GOLD_INGOT;
            case ProfessionRole.TRADER -> Material.EMERALD;
            case ProfessionRole.INVESTOR -> Material.DIAMOND;
            case ProfessionRole.SPECULATOR -> Material.ENDER_PEARL;
            case ProfessionRole.HOARDER -> Material.CHEST;
            case ProfessionRole.PHILANTHROPIST -> Material.BOOK;
        };
    }

    private String pretty(String s) {
        return Arrays.stream(s.toLowerCase(Locale.ROOT).split("_")).map(w -> Character.toUpperCase(w.charAt(0)) + w.substring(1)).reduce((a, b) -> a + " " + b).orElse(s);
    }

    private ItemStack button(Material mat, String name, String[] lore) {
        ItemStack it = new ItemStack(mat);
        ItemMeta meta = it.getItemMeta();
        meta.setDisplayName("\u00a7e" + name);
        if (lore != null) {
            meta.setLore(Arrays.asList(lore));
        }
        it.setItemMeta(meta);
        return it;
    }

    @Override
    protected void onClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        ItemStack it = e.getCurrentItem();
        if (it == null || !it.hasItemMeta() || !it.getItemMeta().hasDisplayName()) {
            return;
        }
        String raw = it.getItemMeta().getDisplayName().replace("\u00a7e", "").toUpperCase(Locale.ROOT).replace(' ', '_');
        try {
            ProfessionRole role = ProfessionRole.valueOf(raw);
            this.professionsManager.setRole(p.getUniqueId(), role).thenAccept(ok -> {
                p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + (ok != false ? this.tm.getMessage("professions.selected", role.name(), new Object[0]) : this.tm.getMessage("errors.command-error", new Object[0])));
                p.closeInventory();
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

