/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import me.koyere.ecoxpert.api.EcoXpertAPI;
import me.koyere.ecoxpert.commands.CommandManager;
import me.koyere.ecoxpert.core.ServiceRegistry;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.dependencies.DependencyManager;
import me.koyere.ecoxpert.core.economy.EconomySyncManager;
import me.koyere.ecoxpert.core.failsafe.EconomyFailsafeManager;
import me.koyere.ecoxpert.core.platform.PlatformManager;
import me.koyere.ecoxpert.core.safety.SafeModeManager;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.core.update.UpdateChecker;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.economy.VaultEconomyProvider;
import me.koyere.ecoxpert.libs.bstats.bukkit.Metrics;
import me.koyere.ecoxpert.libs.bstats.charts.SimplePie;
import me.koyere.ecoxpert.modules.events.EconomicEventEngine;
import me.koyere.ecoxpert.modules.inflation.InflationManager;
import me.koyere.ecoxpert.modules.integrations.IntegrationsManager;
import me.koyere.ecoxpert.modules.integrations.PlaceholderProvider;
import me.koyere.ecoxpert.modules.integrations.jobs.JobsIntegration;
import me.koyere.ecoxpert.modules.loans.LoanDelinquencyScheduler;
import me.koyere.ecoxpert.modules.loans.LoanManager;
import me.koyere.ecoxpert.modules.market.MarketManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class EcoXpertPlugin
extends JavaPlugin {
    private ServiceRegistry serviceRegistry;
    private PlatformManager platformManager;
    private ConfigManager configManager;
    private DataManager dataManager;
    private TranslationManager translationManager;
    private UpdateChecker updateChecker;
    private DependencyManager dependencyManager;
    private EconomyFailsafeManager failsafeManager;
    private EconomyManager economyManager;
    private MarketManager marketManager;
    private EconomicEventEngine eventEngine;
    private SafeModeManager safeModeManager;
    private VaultEconomyProvider vaultProvider;
    private CommandManager commandManager;
    private Metrics metrics;
    private static EcoXpertAPI api;

    public void onLoad() {
        try {
            this.getLogger().info("Loading EcoXpert Pro v" + this.getDescription().getVersion());
            this.initializeServiceRegistry();
            this.getLogger().info("EcoXpert Pro service registry initialized");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load EcoXpert Pro", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onEnable() {
        try {
            this.getLogger().info("Enabling EcoXpert Pro...");
            this.getServiceInstances();
            this.initializeCoreManagers();
            this.registerCommands();
            this.registerVaultProvider();
            this.initializeMetrics();
            this.scheduleUpdateCheck();
            api = this.serviceRegistry.getInstance(EcoXpertAPI.class);
            this.getLogger().info("EcoXpert Pro v" + this.getDescription().getVersion() + " enabled successfully!");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to enable EcoXpert Pro", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        try {
            this.getLogger().info("Disabling EcoXpert Pro...");
            if (this.commandManager != null) {
                this.commandManager.unregisterCommands();
            }
            if (this.marketManager != null) {
                this.marketManager.shutdown();
            }
            if (this.economyManager != null) {
                this.economyManager.shutdown();
            }
            if (this.failsafeManager != null) {
                this.failsafeManager.shutdown();
            }
            if (this.dataManager != null) {
                this.dataManager.shutdown();
            }
            if (this.dependencyManager != null) {
                this.dependencyManager.shutdown();
            }
            api = null;
            this.getLogger().info("EcoXpert Pro disabled successfully!");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error during plugin shutdown", e);
        }
    }

    private void initializeServiceRegistry() {
        this.serviceRegistry = new ServiceRegistry(this);
    }

    private void getServiceInstances() {
        this.platformManager = this.serviceRegistry.getInstance(PlatformManager.class);
        this.configManager = this.serviceRegistry.getInstance(ConfigManager.class);
        this.dataManager = this.serviceRegistry.getInstance(DataManager.class);
        this.translationManager = this.serviceRegistry.getInstance(TranslationManager.class);
        this.updateChecker = this.serviceRegistry.getInstance(UpdateChecker.class);
        this.dependencyManager = this.serviceRegistry.getInstance(DependencyManager.class);
        this.failsafeManager = this.serviceRegistry.getInstance(EconomyFailsafeManager.class);
        this.economyManager = this.serviceRegistry.getInstance(EconomyManager.class);
        this.marketManager = this.serviceRegistry.getInstance(MarketManager.class);
        this.eventEngine = this.serviceRegistry.getInstance(EconomicEventEngine.class);
        this.safeModeManager = this.serviceRegistry.getInstance(SafeModeManager.class);
        this.vaultProvider = this.serviceRegistry.getInstance(VaultEconomyProvider.class);
        this.commandManager = this.serviceRegistry.getInstance(CommandManager.class);
    }

    private void initializeCoreManagers() {
        this.platformManager.detectPlatform();
        this.getLogger().info("Platform detected: " + this.platformManager.getPlatformName());
        this.configManager.initialize();
        try {
            if (this.configManager.isSimpleMode()) {
                FileConfiguration root = this.configManager.getConfig();
                double mc = root.getDouble("simple.market.max_price_change", 0.15);
                double vd = root.getDouble("simple.market.volatility_damping", 0.9);
                int th = root.getInt("simple.market.trend_analysis_hours", 24);
                double infl = root.getDouble("simple.inflation.target", 1.02);
                double wtax = root.getDouble("simple.policy.wealth_tax_rate", 0.005);
                this.getLogger().info("================ SIMPLE MODE ================");
                this.getLogger().info(String.format("Market: max_price_change=%.2f, volatility_damping=%.2f, trend_hours=%d", mc, vd, th));
                this.getLogger().info(String.format("Inflation target: %.2f (multiplier)", infl));
                this.getLogger().info(String.format("Wealth tax rate: %.3f", wtax));
                this.getLogger().info("(Switch to advanced via plugin.config_mode=\"advanced\")");
                this.getLogger().info("============================================");
            }
        }
        catch (Exception root) {
            // empty catch block
        }
        this.translationManager.initialize();
        this.dependencyManager.initialize();
        this.dataManager.initialize();
        this.failsafeManager.initialize();
        this.economyManager.initialize();
        this.marketManager.initialize();
        try {
            this.eventEngine.initialize();
        }
        catch (Exception e) {
            this.getLogger().warning("Dynamic Economic Events Engine failed to initialize: " + e.getMessage());
        }
        try {
            this.safeModeManager.initialize();
        }
        catch (Exception e) {
            this.getLogger().warning("Safe Mode monitor failed to initialize: " + e.getMessage());
        }
        try {
            new LoanDelinquencyScheduler(this, this.dataManager, this.economyManager).start();
        }
        catch (Exception e) {
            this.getLogger().warning("Loan delinquency scheduler failed to start: " + e.getMessage());
        }
        try {
            if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
                new PlaceholderProvider(this, this.economyManager, this.marketManager, this.serviceRegistry.getInstance(InflationManager.class), this.eventEngine, this.serviceRegistry.getInstance(LoanManager.class), this.serviceRegistry.getInstance(IntegrationsManager.class), this.translationManager).register();
                this.getLogger().info("PlaceholderAPI placeholders registered (identifier: ecox)");
            }
        }
        catch (Exception e) {
            this.getLogger().warning("PlaceholderAPI registration failed: " + e.getMessage());
        }
        try {
            this.serviceRegistry.getInstance(IntegrationsManager.class);
        }
        catch (Exception e) {
            this.getLogger().fine("Integrations manager init skipped: " + e.getMessage());
        }
        try {
            new JobsIntegration(this).registerIfPresent();
        }
        catch (Exception e) {
            this.getLogger().fine("Jobs integration not available: " + e.getMessage());
        }
        this.getLogger().info("Core managers initialized successfully");
    }

    private void registerCommands() {
        this.commandManager.registerCommands();
        this.getLogger().info("Plugin commands registered successfully");
    }

    private void registerVaultProvider() {
        boolean hasCMI;
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().warning("Vault not found - economy features limited");
            return;
        }
        boolean hasEssentials = this.getServer().getPluginManager().getPlugin("Essentials") != null || this.getServer().getPluginManager().getPlugin("EssentialsX") != null;
        boolean bl = hasCMI = this.getServer().getPluginManager().getPlugin("CMI") != null;
        if (hasEssentials) {
            this.getLogger().info("EssentialsX detected: use /ecox or /ecoxpert to avoid /eco conflicts");
        }
        boolean importOnStartup = this.getConfig().getBoolean("economy.migration.import_on_startup", true);
        boolean backupBeforeImport = this.getConfig().getBoolean("economy.migration.backup_before_import", true);
        if (importOnStartup && (hasEssentials || hasCMI)) {
            this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> {
                block8: {
                    try {
                        String providerPlugin;
                        RegisteredServiceProvider registration = this.getServer().getServicesManager().getRegistration(Economy.class);
                        if (registration == null) break block8;
                        String string = providerPlugin = registration.getPlugin() != null ? registration.getPlugin().getName() : "Unknown";
                        if (providerPlugin == null || providerPlugin.toLowerCase().contains("ecoxpert")) break block8;
                        if (backupBeforeImport) {
                            try {
                                Path backups = this.getDataFolder().toPath().resolve("backups");
                                Files.createDirectories(backups, new FileAttribute[0]);
                                String ts = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
                                Path backupPath = backups.resolve("pre_import-" + ts + ".db");
                                this.dataManager.exportDatabase(backupPath).join();
                                this.getLogger().info("Database backup created: " + String.valueOf(backupPath.getFileName()));
                            }
                            catch (Exception e) {
                                this.getLogger().warning("Could not create backup before import: " + e.getMessage());
                            }
                        }
                        this.getLogger().info("Importing balances from existing provider: " + providerPlugin + "...");
                        EconomySyncManager tempSync = new EconomySyncManager(this, this.economyManager, (Economy)registration.getProvider());
                        int imported = tempSync.importBalancesFromFallback().join();
                        this.getLogger().info("Import completed. Imported accounts: " + imported);
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Error during startup balance import: " + e.getMessage());
                    }
                    finally {
                        this.getServer().getScheduler().runTask((Plugin)this, () -> {
                            this.vaultProvider.register();
                            this.getLogger().info("Vault economy provider registered successfully");
                        });
                    }
                }
            }, 60L);
        } else {
            this.vaultProvider.register();
            this.getLogger().info("Vault economy provider registered successfully");
        }
    }

    private void initializeMetrics() {
        if (this.configManager.isMetricsEnabled()) {
            this.metrics = new Metrics(this, 26446);
            this.addCustomMetrics();
            this.getLogger().info("bStats metrics initialized");
        } else {
            this.getLogger().info("Metrics collection disabled in config");
        }
    }

    private void addCustomMetrics() {
        this.metrics.addCustomChart(new SimplePie("server_platform", () -> this.platformManager.getPlatformName()));
        this.metrics.addCustomChart(new SimplePie("bedrock_players", () -> this.platformManager.hasBedrockPlayers() ? "Yes" : "No"));
    }

    private void scheduleUpdateCheck() {
        if (this.configManager.isUpdateCheckEnabled()) {
            this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                this.updateChecker.checkForUpdates();
                this.updateChecker.notifyAdmins();
            });
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                this.updateChecker.checkForUpdates();
                this.updateChecker.notifyAdmins();
            }, 432000L, 432000L);
        }
    }

    public static EcoXpertAPI getAPI() {
        if (api == null) {
            throw new IllegalStateException("EcoXpert API not initialized - plugin may not be loaded");
        }
        return api;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

