/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.api.dto;

public class ServerEconomySnapshot {
    private final String cycle;
    private final double economicHealth;
    private final double inflationRate;
    private final double marketActivity;
    private final int activeEvents;

    public ServerEconomySnapshot(String cycle, double economicHealth, double inflationRate, double marketActivity, int activeEvents) {
        this.cycle = cycle;
        this.economicHealth = Math.max(0.0, Math.min(1.0, economicHealth));
        this.inflationRate = inflationRate;
        this.marketActivity = Math.max(0.0, Math.min(1.0, marketActivity));
        this.activeEvents = Math.max(0, activeEvents);
    }

    public String getCycle() {
        return this.cycle;
    }

    public double getEconomicHealth() {
        return this.economicHealth;
    }

    public double getInflationRate() {
        return this.inflationRate;
    }

    public double getMarketActivity() {
        return this.marketActivity;
    }

    public int getActiveEvents() {
        return this.activeEvents;
    }
}

