/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.api.services;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.api.BankingService;
import me.koyere.ecoxpert.api.dto.BankAccountInfo;
import me.koyere.ecoxpert.api.dto.BankOperationStatus;
import me.koyere.ecoxpert.api.dto.BankStats;
import me.koyere.ecoxpert.modules.bank.BankAccount;
import me.koyere.ecoxpert.modules.bank.BankManager;
import me.koyere.ecoxpert.modules.bank.BankTransaction;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class BankingServiceImpl
implements BankingService {
    private final BankManager bankManager;

    public BankingServiceImpl(BankManager bankManager) {
        this.bankManager = bankManager;
    }

    @Override
    public CompletableFuture<BankAccountInfo> getAccount(UUID playerId) {
        return ((CompletableFuture)this.bankManager.getAccount(playerId).thenApply(optAccount -> {
            if (optAccount.isEmpty()) {
                return null;
            }
            BankAccount account = (BankAccount)optAccount.get();
            Instant lastInterest = account.getLastInterestCalculation().atZone(ZoneId.systemDefault()).toInstant();
            return new BankAccountInfo(playerId, account.getBalance(), account.getTier().name(), account.getTier().getAnnualInterestRate().doubleValue(), lastInterest);
        })).exceptionally(ex -> null);
    }

    @Override
    public CompletableFuture<BankOperationStatus> createAccount(UUID playerId) {
        return ((CompletableFuture)this.bankManager.getOrCreateAccount(playerId).thenApply(account -> new BankOperationStatus(true, "Account created successfully", account.getBalance()))).exceptionally(ex -> new BankOperationStatus(false, "Failed to create account: " + ex.getMessage(), BigDecimal.ZERO));
    }

    @Override
    public CompletableFuture<BankOperationStatus> deposit(UUID playerId, BigDecimal amount) {
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return CompletableFuture.completedFuture(new BankOperationStatus(false, "Player not online", BigDecimal.ZERO));
        }
        return ((CompletableFuture)this.bankManager.deposit(player, amount).thenApply(result -> new BankOperationStatus(result.isSuccess(), result.getMessage(), result.getNewBalance()))).exceptionally(ex -> new BankOperationStatus(false, "Deposit failed: " + ex.getMessage(), BigDecimal.ZERO));
    }

    @Override
    public CompletableFuture<BankOperationStatus> withdraw(UUID playerId, BigDecimal amount) {
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return CompletableFuture.completedFuture(new BankOperationStatus(false, "Player not online", BigDecimal.ZERO));
        }
        return ((CompletableFuture)this.bankManager.withdraw(player, amount).thenApply(result -> new BankOperationStatus(result.isSuccess(), result.getMessage(), result.getNewBalance()))).exceptionally(ex -> new BankOperationStatus(false, "Withdrawal failed: " + ex.getMessage(), BigDecimal.ZERO));
    }

    @Override
    public CompletableFuture<BankStats> getStatistics(UUID playerId) {
        return ((CompletableFuture)this.bankManager.getTransactionHistory(playerId, 1000).thenApply(transactions -> {
            BigDecimal totalDeposited = BigDecimal.ZERO;
            BigDecimal totalWithdrawn = BigDecimal.ZERO;
            BigDecimal totalInterest = BigDecimal.ZERO;
            for (BankTransaction tx : transactions) {
                switch (tx.getType()) {
                    case DEPOSIT: {
                        totalDeposited = totalDeposited.add(tx.getAmount());
                        break;
                    }
                    case WITHDRAW: {
                        totalWithdrawn = totalWithdrawn.add(tx.getAmount());
                        break;
                    }
                    case INTEREST: {
                        totalInterest = totalInterest.add(tx.getAmount());
                    }
                }
            }
            return new BankStats(totalDeposited, totalWithdrawn, totalInterest, transactions.size());
        })).exceptionally(ex -> new BankStats(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0));
    }

    @Override
    public CompletableFuture<Double> getInterestRate(UUID playerId) {
        return ((CompletableFuture)this.bankManager.getAccountTier(playerId).thenApply(tier -> tier.getAnnualInterestRate().doubleValue())).exceptionally(ex -> 0.0);
    }
}

