/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.api.services;

import java.time.Duration;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.koyere.ecoxpert.api.EventsService;
import me.koyere.ecoxpert.api.dto.EventInfo;
import me.koyere.ecoxpert.api.dto.EventStatistics;
import me.koyere.ecoxpert.api.dto.EventType;
import me.koyere.ecoxpert.modules.events.EconomicEvent;
import me.koyere.ecoxpert.modules.events.EconomicEventEngine;
import me.koyere.ecoxpert.modules.events.EconomicEventType;

public class EventsServiceImpl
implements EventsService {
    private final EconomicEventEngine eventEngine;

    public EventsServiceImpl(EconomicEventEngine eventEngine) {
        this.eventEngine = eventEngine;
    }

    @Override
    public List<EventInfo> getActiveEvents() {
        Map<String, EconomicEvent> activeEventsMap = this.eventEngine.getActiveEvents();
        return activeEventsMap.values().stream().map(event -> new EventInfo(UUID.nameUUIDFromBytes(event.getId().getBytes()), this.mapEventType(event.getType()), event.getName(), event.getStartTime().atZone(ZoneId.systemDefault()).toInstant(), event.getEndTime() != null ? event.getEndTime().atZone(ZoneId.systemDefault()).toInstant() : null, event.getDescription())).collect(Collectors.toList());
    }

    @Override
    public Optional<EventInfo> getEventById(UUID eventId) {
        Map<String, EconomicEvent> activeEventsMap = this.eventEngine.getActiveEvents();
        return activeEventsMap.values().stream().filter(e -> UUID.nameUUIDFromBytes(e.getId().getBytes()).equals(eventId)).map(event -> new EventInfo(UUID.nameUUIDFromBytes(event.getId().getBytes()), this.mapEventType(event.getType()), event.getName(), event.getStartTime().atZone(ZoneId.systemDefault()).toInstant(), event.getEndTime() != null ? event.getEndTime().atZone(ZoneId.systemDefault()).toInstant() : null, event.getDescription())).findFirst();
    }

    @Override
    public boolean isEventActive(EventType type) {
        EconomicEventType internalType = this.unmapEventType(type);
        Map<String, EconomicEvent> activeEvents = this.eventEngine.getActiveEvents();
        return activeEvents.values().stream().anyMatch(e -> e.getType() == internalType);
    }

    @Override
    public Map<EventType, Long> getRemainingCooldowns() {
        HashMap<EventType, Long> cooldowns = new HashMap<EventType, Long>();
        for (EventType type : EventType.values()) {
            EconomicEventType internalType = this.unmapEventType(type);
            long remainingHours = this.eventEngine.getRemainingCooldownHours(internalType);
            cooldowns.put(type, remainingHours * 3600000L);
        }
        return cooldowns;
    }

    @Override
    public EventStatistics getEventStatistics(int days) {
        List<EconomicEvent> history = this.eventEngine.getEventHistory();
        HashMap<EventType, Integer> counts = new HashMap<EventType, Integer>();
        HashMap<EventType, Double> avgDurations = new HashMap<EventType, Double>();
        for (EconomicEvent event : history) {
            EventType apiType = this.mapEventType(event.getType());
            counts.put(apiType, counts.getOrDefault((Object)apiType, 0) + 1);
            if (event.getEndTime() == null || event.getStartTime() == null) continue;
            long duration = Duration.between(event.getStartTime(), event.getEndTime()).toMinutes();
            avgDurations.merge(apiType, Double.valueOf(duration), (old, newVal) -> (old + newVal) / 2.0);
        }
        return new EventStatistics(history.size(), counts, avgDurations);
    }

    private EventType mapEventType(EconomicEventType internal) {
        return switch (internal) {
            default -> throw new IncompatibleClassChangeError();
            case EconomicEventType.BLACK_SWAN_EVENT -> EventType.BLACK_SWAN;
            case EconomicEventType.TECHNOLOGICAL_BREAKTHROUGH -> EventType.TECHNOLOGICAL_ADVANCEMENT;
            case EconomicEventType.RESOURCE_SHORTAGE -> EventType.RESOURCE_SCARCITY;
            case EconomicEventType.MARKET_CORRECTION -> EventType.MARKET_CRASH;
            case EconomicEventType.MARKET_DISCOVERY -> EventType.MARKET_CRASH;
            case EconomicEventType.GOVERNMENT_STIMULUS -> EventType.GOVERNMENT_STIMULUS;
            case EconomicEventType.TRADE_BOOM -> EventType.TRADE_BOOM;
            case EconomicEventType.INVESTMENT_OPPORTUNITY -> EventType.INVESTMENT_OPPORTUNITY;
            case EconomicEventType.LUXURY_DEMAND -> EventType.LUXURY_DEMAND;
            case EconomicEventType.SEASONAL_DEMAND -> EventType.SEASONAL_DEMAND;
        };
    }

    private EconomicEventType unmapEventType(EventType external) {
        return switch (external) {
            default -> throw new IncompatibleClassChangeError();
            case EventType.BLACK_SWAN -> EconomicEventType.BLACK_SWAN_EVENT;
            case EventType.TECHNOLOGICAL_ADVANCEMENT -> EconomicEventType.TECHNOLOGICAL_BREAKTHROUGH;
            case EventType.RESOURCE_SCARCITY -> EconomicEventType.RESOURCE_SHORTAGE;
            case EventType.MARKET_CRASH -> EconomicEventType.MARKET_CORRECTION;
            case EventType.GOVERNMENT_STIMULUS -> EconomicEventType.GOVERNMENT_STIMULUS;
            case EventType.TRADE_BOOM -> EconomicEventType.TRADE_BOOM;
            case EventType.INVESTMENT_OPPORTUNITY -> EconomicEventType.INVESTMENT_OPPORTUNITY;
            case EventType.LUXURY_DEMAND -> EconomicEventType.LUXURY_DEMAND;
            case EventType.SEASONAL_DEMAND -> EconomicEventType.SEASONAL_DEMAND;
        };
    }
}

