/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.api.services;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.api.MarketService;
import me.koyere.ecoxpert.api.dto.MarketStats;
import me.koyere.ecoxpert.api.dto.MarketTrend;
import me.koyere.ecoxpert.api.dto.PriceType;
import me.koyere.ecoxpert.api.dto.TrendingItem;
import me.koyere.ecoxpert.modules.market.MarketItemStats;
import me.koyere.ecoxpert.modules.market.MarketManager;
import org.bukkit.Material;

public class MarketServiceImpl
implements MarketService {
    private final MarketManager marketManager;

    public MarketServiceImpl(MarketManager marketManager) {
        this.marketManager = marketManager;
    }

    @Override
    public CompletableFuture<Double> getCurrentPrice(Material material, PriceType type) {
        if (type == PriceType.BUY) {
            return ((CompletableFuture)this.marketManager.getBuyPrice(material).thenApply(price -> price.doubleValue())).exceptionally(ex -> 0.0);
        }
        return ((CompletableFuture)this.marketManager.getSellPrice(material).thenApply(price -> price.doubleValue())).exceptionally(ex -> 0.0);
    }

    @Override
    public CompletableFuture<MarketTrend> getItemTrend(Material material, Duration period) {
        return ((CompletableFuture)this.marketManager.getItemTrend(material).thenApply(trend -> {
            String trendDirection = trend.getDirection().name();
            double change = trend.getPriceChangePercentage().doubleValue();
            long vol = 0L;
            return new MarketTrend(material, trendDirection, change, vol);
        })).exceptionally(ex -> new MarketTrend(material, "UNKNOWN", 0.0, 0L));
    }

    @Override
    public CompletableFuture<List<TrendingItem>> getTrendingItems(int limit) {
        return ((CompletableFuture)this.marketManager.getTopTradedItems(limit).thenApply(itemStatsList -> {
            ArrayList<TrendingItem> trending = new ArrayList<TrendingItem>();
            for (MarketItemStats stats : itemStatsList) {
                Material mat = stats.getMaterial();
                double buyPrice = 0.0;
                double sellPrice = 0.0;
                try {
                    buyPrice = this.marketManager.getBuyPrice(mat).join().doubleValue();
                    sellPrice = this.marketManager.getSellPrice(mat).join().doubleValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                trending.add(new TrendingItem(mat, buyPrice, sellPrice, stats.getTotalBought() + stats.getTotalSold(), 0.0));
            }
            return trending;
        })).exceptionally(ex -> new ArrayList());
    }

    @Override
    public CompletableFuture<MarketStats> getMarketStatistics() {
        return ((CompletableFuture)this.marketManager.getMarketStatistics().thenApply(stats -> new MarketStats(stats.getTotalVolume().doubleValue(), stats.getMarketActivity(), stats.getActiveItems(), (int)stats.getTotalTransactions()))).exceptionally(ex -> new MarketStats(0.0, 0.0, 0, 0));
    }

    @Override
    public CompletableFuture<Long> getTradeVolume(Material material, Duration period) {
        return ((CompletableFuture)this.marketManager.getItemTrend(material).thenApply(trend -> 0L)).exceptionally(ex -> 0L);
    }
}

