/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.commands;

import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AdminGuiCommand
implements CommandExecutor,
Listener {
    private final EcoXpertPlugin plugin;
    private final TranslationManager tm;
    private Inventory inv;

    public AdminGuiCommand(EcoXpertPlugin plugin, TranslationManager tm) {
        this.plugin = plugin;
        this.tm = tm;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Players only");
            return true;
        }
        Player p = (Player)sender;
        if (!p.hasPermission("ecoxpert.admin")) {
            p.sendMessage(this.tm.getMessage("error.no-permission", new Object[0]));
            return true;
        }
        this.inv = Bukkit.createInventory(null, (int)27, (String)this.tm.getMessage("admin.gui.title", new Object[0]));
        this.inv.setItem(11, this.item(Material.NETHER_STAR, this.tm.getMessage("admin.gui.events", new Object[0])));
        this.inv.setItem(13, this.item(Material.EMERALD_BLOCK, this.tm.getMessage("admin.gui.market", new Object[0])));
        this.inv.setItem(15, this.item(Material.GOLD_BLOCK, this.tm.getMessage("admin.gui.loans", new Object[0])));
        this.inv.setItem(22, this.item(Material.BOOK, this.tm.getMessage("admin.gui.economy", new Object[0])));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        p.openInventory(this.inv);
        return true;
    }

    private ItemStack item(Material m, String name) {
        ItemStack it = new ItemStack(m);
        ItemMeta meta = it.getItemMeta();
        meta.setDisplayName("\u00a7e" + name);
        it.setItemMeta(meta);
        return it;
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (this.inv == null || e.getInventory() == null || !e.getInventory().equals(this.inv)) {
            return;
        }
        e.setCancelled(true);
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        ItemStack it = e.getCurrentItem();
        if (it == null || !it.hasItemMeta()) {
            return;
        }
        String name = it.getItemMeta().getDisplayName();
        if (name.contains(this.tm.getMessage("admin.gui.events", new Object[0]))) {
            p.performCommand("ecoxpert events status");
            p.closeInventory();
        } else if (name.contains(this.tm.getMessage("admin.gui.market", new Object[0]))) {
            p.performCommand("market stats");
            p.closeInventory();
        } else if (name.contains(this.tm.getMessage("admin.gui.loans", new Object[0]))) {
            p.performCommand("ecoxpert economy loans stats");
            p.closeInventory();
        } else if (name.contains(this.tm.getMessage("admin.gui.economy", new Object[0]))) {
            p.performCommand("ecoxpert economy status");
            p.closeInventory();
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (this.inv != null && e.getInventory() != null && e.getInventory().equals(this.inv)) {
            HandlerList.unregisterAll((Listener)this);
            this.inv = null;
        }
    }
}

