/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.commands;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.commands.BaseCommand;
import me.koyere.ecoxpert.core.ServiceRegistry;
import me.koyere.ecoxpert.core.safety.RateLimitManager;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PayCommand
extends BaseCommand {
    public PayCommand(EconomyManager economyManager, TranslationManager translationManager) {
        super(economyManager, translationManager);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        EcoXpertPlugin plugin;
        ServiceRegistry services;
        RateLimitManager limiter;
        if (sender instanceof Player && (limiter = (services = (plugin = (EcoXpertPlugin)EcoXpertPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry()).getInstance(RateLimitManager.class)) != null && !limiter.allow(((Player)sender).getUniqueId(), "pay")) {
            this.sendMessage(sender, "errors.command-error", new Object[0]);
            return true;
        }
        if (!this.hasPermission(sender, "ecoxpert.economy.pay")) {
            return true;
        }
        Player player = this.requirePlayer(sender);
        if (player == null) {
            return true;
        }
        if (args.length < 2) {
            this.sendMessage(sender, "commands.pay.usage", new Object[0]);
            return true;
        }
        OfflinePlayer target = this.findPlayer(sender, args[0]);
        if (target == null) {
            return true;
        }
        if (target.getUniqueId().equals(player.getUniqueId())) {
            this.sendMessage(sender, "error.cannot_pay_self", new Object[0]);
            return true;
        }
        BigDecimal amount = this.parseAmount(sender, args[1]);
        if (amount == null) {
            return true;
        }
        this.ensureAccount(player.getUniqueId());
        this.ensureAccount(target.getUniqueId());
        ((CompletableFuture)this.economyManager.transferMoney(player.getUniqueId(), target.getUniqueId(), amount, "Player payment from " + player.getName()).thenAccept(success -> {
            String formattedAmount = this.economyManager.formatMoney(amount);
            if (success.booleanValue()) {
                this.sendMessage(sender, "commands.pay.success", formattedAmount, target.getName());
                if (target.isOnline()) {
                    Player targetPlayer = target.getPlayer();
                    this.sendMessage((CommandSender)targetPlayer, "commands.pay.received", formattedAmount, player.getName());
                }
            } else {
                this.sendMessage(sender, "error.insufficient_funds", new Object[0]);
            }
        })).exceptionally(throwable -> {
            this.sendMessage(sender, "error.database_error", new Object[0]);
            return null;
        });
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> !name.equals(sender.getName())).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            ArrayList<String> amounts = new ArrayList<String>();
            amounts.add("10");
            amounts.add("50");
            amounts.add("100");
            amounts.add("500");
            amounts.add("1000");
            return amounts.stream().filter(amount -> amount.startsWith(args[1])).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

