/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.modules.professions.ProfessionRole;
import me.koyere.ecoxpert.modules.professions.ProfessionsManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class ProfessionCommand
implements TabExecutor {
    private final ProfessionsManager professionsManager;
    private final TranslationManager tm;

    public ProfessionCommand(ProfessionsManager professionsManager, TranslationManager tm) {
        this.professionsManager = professionsManager;
        this.tm = tm;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.tm.getMessage("player-only", new Object[0]));
            return true;
        }
        Player p = (Player)sender;
        if (args.length == 0 || args[0].equalsIgnoreCase("info")) {
            this.professionsManager.getRole(p.getUniqueId()).thenAccept(opt -> {
                String current = opt.map(Enum::name).orElse("NONE");
                String available = String.join((CharSequence)", ", Arrays.stream(ProfessionRole.values()).map(Enum::name).toList());
                p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + "\u00a77" + this.tm.getMessage("professions.current", current, new Object[0]));
                p.sendMessage("\u00a77" + this.tm.getMessage("professions.available", available, new Object[0]));
            });
            return true;
        }
        if (args[0].equalsIgnoreCase("select")) {
            ProfessionRole role;
            if (!p.hasPermission("ecoxpert.professions.select")) {
                p.sendMessage(this.tm.getMessage("no-permission", new Object[0]));
                return true;
            }
            if (args.length < 2) {
                p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + "\u00a7cUsage: /profession select <role>");
                return true;
            }
            try {
                role = ProfessionRole.fromString(args[1]);
            }
            catch (Exception e) {
                p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + "\u00a7cUnknown role");
                return true;
            }
            ProfessionRole r = role;
            this.professionsManager.setRole(p.getUniqueId(), role).thenAccept(ok -> {
                if (ok.booleanValue()) {
                    p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + this.tm.getMessage("professions.selected", r.name(), new Object[0]));
                } else {
                    p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + this.tm.getMessage("errors.command-error", new Object[0]));
                }
            });
            return true;
        }
        if (args[0].equalsIgnoreCase("level")) {
            this.professionsManager.getLevel(p.getUniqueId()).thenAccept(lv -> p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + "\u00a77Level: \u00a7e" + lv));
            return true;
        }
        if (args[0].equalsIgnoreCase("levelup")) {
            if (!p.hasPermission("ecoxpert.professions.levelup")) {
                p.sendMessage(this.tm.getMessage("no-permission", new Object[0]));
                return true;
            }
            ((CompletableFuture)this.professionsManager.getLevel(p.getUniqueId()).thenCompose(lv -> this.professionsManager.setLevel(p.getUniqueId(), lv + 1))).thenAccept(ok -> p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + (ok != false ? "\u00a7aLevel up!" : this.tm.getMessage("errors.command-error", new Object[0]))));
            return true;
        }
        p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + "\u00a7cUsage: /profession [info|select <role>|level|levelup]");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            list.add("info");
            list.add("select");
            list.add("level");
            list.add("levelup");
        } else if (args.length == 2 && args[0].equalsIgnoreCase("select")) {
            for (ProfessionRole r : ProfessionRole.values()) {
                list.add(r.name());
            }
        }
        return list;
    }
}

