/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.api.EcoXpertAPI;
import me.koyere.ecoxpert.api.EcoXpertAPIImpl;
import me.koyere.ecoxpert.commands.CommandManager;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.config.ConfigManagerImpl;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.data.DataManagerImpl;
import me.koyere.ecoxpert.core.dependencies.DependencyManager;
import me.koyere.ecoxpert.core.dependencies.DependencyManagerImpl;
import me.koyere.ecoxpert.core.failsafe.EconomyFailsafeManager;
import me.koyere.ecoxpert.core.failsafe.EconomyFailsafeManagerImpl;
import me.koyere.ecoxpert.core.platform.PlatformManager;
import me.koyere.ecoxpert.core.platform.PlatformManagerImpl;
import me.koyere.ecoxpert.core.safety.RateLimitManager;
import me.koyere.ecoxpert.core.safety.SafeModeManager;
import me.koyere.ecoxpert.core.safety.SafeModeManagerImpl;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.core.translation.TranslationManagerImpl;
import me.koyere.ecoxpert.core.update.UpdateChecker;
import me.koyere.ecoxpert.core.update.UpdateCheckerImpl;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.economy.EconomyManagerImpl;
import me.koyere.ecoxpert.economy.VaultEconomyProvider;
import me.koyere.ecoxpert.economy.VaultEconomyProviderImpl;
import me.koyere.ecoxpert.modules.bank.BankManager;
import me.koyere.ecoxpert.modules.bank.BankManagerImpl;
import me.koyere.ecoxpert.modules.events.EconomicEventEngine;
import me.koyere.ecoxpert.modules.inflation.InflationManager;
import me.koyere.ecoxpert.modules.inflation.InflationManagerImpl;
import me.koyere.ecoxpert.modules.integrations.IntegrationsManager;
import me.koyere.ecoxpert.modules.integrations.IntegrationsManagerImpl;
import me.koyere.ecoxpert.modules.loans.LoanManager;
import me.koyere.ecoxpert.modules.loans.LoanManagerImpl;
import me.koyere.ecoxpert.modules.market.MarketManager;
import me.koyere.ecoxpert.modules.market.MarketManagerImpl;
import me.koyere.ecoxpert.modules.market.orders.MarketOrderService;
import me.koyere.ecoxpert.modules.market.orders.MarketOrderServiceImpl;
import me.koyere.ecoxpert.modules.professions.ProfessionsManager;
import me.koyere.ecoxpert.modules.professions.ProfessionsManagerImpl;

public class ServiceRegistry {
    private final EcoXpertPlugin plugin;
    private final ConcurrentMap<Class<?>, Object> singletonInstances = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Supplier<?>> factoryMethods = new ConcurrentHashMap();

    public ServiceRegistry(EcoXpertPlugin plugin) {
        this.plugin = plugin;
        this.registerFactories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getInstance(Class<T> serviceClass) {
        Object instance = this.singletonInstances.get(serviceClass);
        if (instance != null) {
            return (T)instance;
        }
        Supplier factory = (Supplier)this.factoryMethods.get(serviceClass);
        if (factory == null) {
            throw new IllegalArgumentException("No factory registered for: " + serviceClass.getName());
        }
        ConcurrentMap<Class<?>, Object> concurrentMap = this.singletonInstances;
        synchronized (concurrentMap) {
            instance = this.singletonInstances.get(serviceClass);
            if (instance == null) {
                instance = factory.get();
                this.singletonInstances.put(serviceClass, instance);
            }
        }
        return (T)instance;
    }

    public boolean isInstantiated(Class<?> serviceClass) {
        return this.singletonInstances.containsKey(serviceClass);
    }

    public void clearInstances() {
        this.singletonInstances.clear();
    }

    private void registerFactories() {
        this.singletonInstances.put(EcoXpertPlugin.class, (Object)this.plugin);
        this.factoryMethods.put(PlatformManager.class, this::createPlatformManager);
        this.factoryMethods.put(ConfigManager.class, this::createConfigManager);
        this.factoryMethods.put(TranslationManager.class, this::createTranslationManager);
        this.factoryMethods.put(DependencyManager.class, this::createDependencyManager);
        this.factoryMethods.put(DataManager.class, this::createDataManager);
        this.factoryMethods.put(EconomyFailsafeManager.class, this::createEconomyFailsafeManager);
        this.factoryMethods.put(UpdateChecker.class, this::createUpdateChecker);
        this.factoryMethods.put(EconomyManager.class, this::createEconomyManager);
        this.factoryMethods.put(VaultEconomyProvider.class, this::createVaultEconomyProvider);
        this.factoryMethods.put(MarketManager.class, this::createMarketManager);
        this.factoryMethods.put(BankManager.class, this::createBankManager);
        this.factoryMethods.put(InflationManager.class, this::createInflationManager);
        this.factoryMethods.put(EconomicEventEngine.class, this::createEconomicEventEngine);
        this.factoryMethods.put(LoanManager.class, this::createLoanManager);
        this.factoryMethods.put(IntegrationsManager.class, this::createIntegrationsManager);
        this.factoryMethods.put(MarketOrderService.class, this::createMarketOrderService);
        this.factoryMethods.put(ProfessionsManager.class, this::createProfessionsManager);
        this.factoryMethods.put(CommandManager.class, this::createCommandManager);
        this.factoryMethods.put(EcoXpertAPI.class, this::createAPI);
        this.factoryMethods.put(SafeModeManager.class, this::createSafeModeManager);
        this.factoryMethods.put(RateLimitManager.class, this::createRateLimitManager);
    }

    private PlatformManager createPlatformManager() {
        return new PlatformManagerImpl(this.plugin);
    }

    private ConfigManager createConfigManager() {
        return new ConfigManagerImpl(this.plugin);
    }

    private TranslationManager createTranslationManager() {
        return new TranslationManagerImpl(this.plugin, this.getInstance(ConfigManager.class));
    }

    private DependencyManager createDependencyManager() {
        return new DependencyManagerImpl(this.plugin);
    }

    private DataManager createDataManager() {
        return new DataManagerImpl(this.plugin, this.getInstance(ConfigManager.class));
    }

    private EconomyFailsafeManager createEconomyFailsafeManager() {
        return new EconomyFailsafeManagerImpl(this.plugin, this.getInstance(DataManager.class));
    }

    private UpdateChecker createUpdateChecker() {
        return new UpdateCheckerImpl(this.plugin, this.getInstance(TranslationManager.class));
    }

    private EconomyManager createEconomyManager() {
        return new EconomyManagerImpl(this.plugin, this.getInstance(ConfigManager.class), this.getInstance(DataManager.class));
    }

    private VaultEconomyProvider createVaultEconomyProvider() {
        return new VaultEconomyProviderImpl(this.plugin, this.getInstance(EconomyManager.class));
    }

    private CommandManager createCommandManager() {
        return new CommandManager(this.plugin, this.getInstance(EconomyManager.class), this.getInstance(MarketManager.class), this.getInstance(BankManager.class), this.getInstance(TranslationManager.class));
    }

    private MarketManager createMarketManager() {
        return new MarketManagerImpl(this.plugin, this.getInstance(DataManager.class), this.getInstance(EconomyManager.class), this.getInstance(TranslationManager.class), this.getInstance(ConfigManager.class));
    }

    private BankManager createBankManager() {
        return new BankManagerImpl(this.plugin, this.getInstance(DataManager.class), this.getInstance(EconomyManager.class), this.getInstance(InflationManager.class));
    }

    private InflationManager createInflationManager() {
        return new InflationManagerImpl(this.plugin, this.getInstance(EconomyManager.class), this.getInstance(MarketManager.class), this.getInstance(ConfigManager.class));
    }

    private EconomicEventEngine createEconomicEventEngine() {
        return new EconomicEventEngine(this.plugin, this.getInstance(EconomyManager.class), this.getInstance(MarketManager.class), this.getInstance(InflationManager.class));
    }

    private LoanManager createLoanManager() {
        return new LoanManagerImpl(this.plugin, this.getInstance(DataManager.class), this.getInstance(EconomyManager.class));
    }

    private EcoXpertAPI createAPI() {
        return new EcoXpertAPIImpl(this.plugin);
    }

    private SafeModeManager createSafeModeManager() {
        return new SafeModeManagerImpl(this.plugin, this.getInstance(DataManager.class), this.getInstance(ConfigManager.class));
    }

    private RateLimitManager createRateLimitManager() {
        int opsPerSecond = 5;
        try {
            opsPerSecond = Math.max(1, this.plugin.getConfig().getInt("security.anti-exploit.ops_per_second", 5));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new RateLimitManager(opsPerSecond);
    }

    private IntegrationsManager createIntegrationsManager() {
        return new IntegrationsManagerImpl(this.plugin);
    }

    private MarketOrderService createMarketOrderService() {
        return new MarketOrderServiceImpl(this.plugin, this.getInstance(DataManager.class), this.getInstance(EconomyManager.class), this.getInstance(MarketManager.class), this.getInstance(TranslationManager.class));
    }

    private ProfessionsManager createProfessionsManager() {
        return new ProfessionsManagerImpl(this.plugin, this.getInstance(DataManager.class));
    }
}

