/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.config.DatabasePoolSettings;
import me.koyere.ecoxpert.core.config.MySqlConfig;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

@Singleton
public class ConfigManagerImpl
implements ConfigManager {
    private final EcoXpertPlugin plugin;
    private final Map<String, FileConfiguration> moduleConfigs = new HashMap<String, FileConfiguration>();
    private boolean metricsEnabled = true;
    private boolean updateCheckEnabled = true;
    private String databaseType = "sqlite";
    private String language = "en";
    private boolean debugEnabled = false;
    private boolean simpleMode = false;
    private MySqlConfig mySqlConfig;

    @Inject
    public ConfigManagerImpl(EcoXpertPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        this.plugin.getLogger().info("Initializing configuration system...");
        this.plugin.saveDefaultConfig();
        this.loadMainConfig();
        this.createModuleDirectories();
        this.loadModuleConfigs();
        this.plugin.getLogger().info("Configuration system initialized");
    }

    @Override
    public void reload() {
        this.plugin.reloadConfig();
        this.loadMainConfig();
        this.moduleConfigs.clear();
        this.loadModuleConfigs();
        this.plugin.getLogger().info("Configuration reloaded");
    }

    @Override
    public FileConfiguration getConfig() {
        return this.plugin.getConfig();
    }

    @Override
    public FileConfiguration getModuleConfig(String moduleName) {
        return this.moduleConfigs.computeIfAbsent(moduleName, this::loadModuleConfig);
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    @Override
    public boolean isUpdateCheckEnabled() {
        return this.updateCheckEnabled;
    }

    @Override
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public boolean isSimpleMode() {
        return this.simpleMode;
    }

    @Override
    public void saveAll() {
        this.plugin.saveConfig();
        this.moduleConfigs.forEach(this::saveModuleConfig);
    }

    private void loadMainConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.metricsEnabled = config.getBoolean("plugin.metrics.enabled", config.getBoolean("metrics.enabled", true));
        this.updateCheckEnabled = config.getBoolean("plugin.updates.check-enabled", config.getBoolean("updates.check-enabled", true));
        this.databaseType = config.getString("database.type", "sqlite");
        this.language = config.getString("plugin.language", config.getString("language", "en"));
        this.debugEnabled = config.getBoolean("plugin.debug", config.getBoolean("debug", false));
        String mode = config.getString("plugin.config_mode", "advanced");
        this.simpleMode = "simple".equalsIgnoreCase(mode);
        this.loadMySqlConfig(config);
    }

    @Override
    public MySqlConfig getMySqlConfig() {
        return this.mySqlConfig;
    }

    private void createModuleDirectories() {
        File modulesDir = new File(this.plugin.getDataFolder(), "modules");
        if (!modulesDir.exists()) {
            modulesDir.mkdirs();
        }
    }

    private void loadModuleConfigs() {
        String[] modules;
        for (String module : modules = new String[]{"market", "bank", "loans", "events", "professions", "inflation", "integrations"}) {
            this.loadModuleConfig(module);
        }
    }

    private void loadMySqlConfig(FileConfiguration config) {
        ConfigurationSection mysqlSection = config.getConfigurationSection("database.mysql");
        if (mysqlSection == null) {
            this.mySqlConfig = new MySqlConfig("localhost", 3306, "ecoxpert", "username", "password", false, true, new DatabasePoolSettings(null, null, null, null, null));
            return;
        }
        String host = mysqlSection.getString("host", "localhost");
        int port = mysqlSection.getInt("port", 3306);
        String databaseName = mysqlSection.getString("database", "ecoxpert");
        String usernameValue = mysqlSection.getString("username", "username");
        String passwordValue = mysqlSection.getString("password", "password");
        boolean useSsl = mysqlSection.getBoolean("use-ssl", false);
        boolean allowPublicKeyRetrieval = mysqlSection.getBoolean("allow-public-key-retrieval", true);
        Integer maximumPoolSize = null;
        Integer minimumIdle = null;
        Long connectionTimeout = null;
        Long idleTimeout = null;
        Long maxLifetime = null;
        ConfigurationSection poolSection = mysqlSection.getConfigurationSection("pool");
        if (poolSection != null) {
            if (poolSection.isSet("maximum-pool-size")) {
                maximumPoolSize = poolSection.getInt("maximum-pool-size");
            }
            if (poolSection.isSet("minimum-idle")) {
                minimumIdle = poolSection.getInt("minimum-idle");
            }
            if (poolSection.isSet("connection-timeout")) {
                connectionTimeout = poolSection.getLong("connection-timeout");
            }
            if (poolSection.isSet("idle-timeout")) {
                idleTimeout = poolSection.getLong("idle-timeout");
            }
            if (poolSection.isSet("max-lifetime")) {
                maxLifetime = poolSection.getLong("max-lifetime");
            }
        }
        this.mySqlConfig = new MySqlConfig(host, port, databaseName, usernameValue, passwordValue, useSsl, allowPublicKeyRetrieval, new DatabasePoolSettings(maximumPoolSize, minimumIdle, connectionTimeout, idleTimeout, maxLifetime));
    }

    private FileConfiguration loadModuleConfig(String moduleName) {
        File configFile = new File(this.plugin.getDataFolder(), "modules/" + moduleName + ".yml");
        if (!configFile.exists()) {
            this.createDefaultModuleConfig(moduleName, configFile);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        this.moduleConfigs.put(moduleName, (FileConfiguration)config);
        return config;
    }

    private void createDefaultModuleConfig(String moduleName, File configFile) {
        try {
            configFile.getParentFile().mkdirs();
            try (InputStream in = this.plugin.getResource("modules/" + moduleName + ".yml");){
                if (in != null) {
                    Files.copy(in, configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    return;
                }
            }
            configFile.createNewFile();
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            config.options().setHeader(List.of("EcoXpert Pro - " + moduleName.substring(0, 1).toUpperCase() + moduleName.substring(1) + " Module Configuration"));
            config.set("enabled", (Object)true);
            config.set("version", (Object)1);
            config.save(configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to create default config for module: " + moduleName);
        }
    }

    private void saveModuleConfig(String moduleName, FileConfiguration config) {
        try {
            File configFile = new File(this.plugin.getDataFolder(), "modules/" + moduleName + ".yml");
            config.save(configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save config for module: " + moduleName);
        }
    }
}

