/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.data;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.koyere.ecoxpert.core.data.QueryResult;

public class QueryResultImpl
implements QueryResult {
    private final ResultSet resultSet;
    private final ResultSetMetaData metaData;
    private final List<String> columnNames;
    private boolean closed = false;
    private int rowCount = -1;
    private final Connection connection;
    private final PreparedStatement statement;

    public QueryResultImpl(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        this.metaData = resultSet.getMetaData();
        this.columnNames = this.buildColumnNames();
        this.connection = null;
        this.statement = null;
    }

    public QueryResultImpl(ResultSet resultSet, Connection connection, PreparedStatement statement) throws SQLException {
        this.resultSet = resultSet;
        this.metaData = resultSet.getMetaData();
        this.columnNames = this.buildColumnNames();
        this.connection = connection;
        this.statement = statement;
    }

    @Override
    public boolean next() {
        try {
            this.checkClosed();
            return this.resultSet.next();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to move to next row", e);
        }
    }

    @Override
    public String getString(String columnName) {
        try {
            this.checkClosed();
            return this.resultSet.getString(columnName);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get string value for column: " + columnName, e);
        }
    }

    @Override
    public Integer getInt(String columnName) {
        try {
            this.checkClosed();
            int value = this.resultSet.getInt(columnName);
            return this.resultSet.wasNull() ? null : Integer.valueOf(value);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get int value for column: " + columnName, e);
        }
    }

    @Override
    public Long getLong(String columnName) {
        try {
            this.checkClosed();
            long value = this.resultSet.getLong(columnName);
            return this.resultSet.wasNull() ? null : Long.valueOf(value);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get long value for column: " + columnName, e);
        }
    }

    @Override
    public Double getDouble(String columnName) {
        try {
            this.checkClosed();
            double value = this.resultSet.getDouble(columnName);
            return this.resultSet.wasNull() ? null : Double.valueOf(value);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get double value for column: " + columnName, e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) {
        try {
            this.checkClosed();
            return this.resultSet.getBigDecimal(columnName);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get BigDecimal value for column: " + columnName, e);
        }
    }

    @Override
    public Boolean getBoolean(String columnName) {
        try {
            this.checkClosed();
            boolean value = this.resultSet.getBoolean(columnName);
            return this.resultSet.wasNull() ? null : Boolean.valueOf(value);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get boolean value for column: " + columnName, e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) {
        try {
            this.checkClosed();
            return this.resultSet.getTimestamp(columnName);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get timestamp value for column: " + columnName, e);
        }
    }

    @Override
    public Optional<String> getOptionalString(String columnName) {
        return Optional.ofNullable(this.getString(columnName));
    }

    @Override
    public Optional<Integer> getOptionalInt(String columnName) {
        return Optional.ofNullable(this.getInt(columnName));
    }

    @Override
    public boolean isEmpty() {
        try {
            this.checkClosed();
            return !this.resultSet.isBeforeFirst() && !this.resultSet.isAfterLast() && this.resultSet.getRow() == 0;
        }
        catch (SQLException e) {
            return true;
        }
    }

    @Override
    public int getRowCount() {
        if (this.rowCount == -1) {
            try {
                this.checkClosed();
                int currentRow = this.resultSet.getRow();
                this.resultSet.last();
                this.rowCount = this.resultSet.getRow();
                if (currentRow == 0) {
                    this.resultSet.beforeFirst();
                } else {
                    this.resultSet.absolute(currentRow);
                }
            }
            catch (SQLException e) {
                this.rowCount = 0;
            }
        }
        return this.rowCount;
    }

    @Override
    public List<String> getColumnNames() {
        return new ArrayList<String>(this.columnNames);
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                System.err.println("Warning: Failed to close ResultSet: " + e.getMessage());
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException e) {
                    System.err.println("Warning: Failed to close PreparedStatement: " + e.getMessage());
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    System.err.println("Warning: Failed to close Connection: " + e.getMessage());
                }
            }
            this.closed = true;
        }
    }

    private List<String> buildColumnNames() throws SQLException {
        ArrayList<String> names = new ArrayList<String>();
        int columnCount = this.metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            names.add(this.metaData.getColumnName(i));
        }
        return names;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("QueryResult has been closed");
        }
    }
}

